/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>DescribeReplicationGroups</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReplicationGroupsResponse extends ElastiCacheResponse implements
        ToCopyableBuilder<DescribeReplicationGroupsResponse.Builder, DescribeReplicationGroupsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeReplicationGroupsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<ReplicationGroup>> REPLICATION_GROUPS_FIELD = SdkField
            .<List<ReplicationGroup>> builder(MarshallingType.LIST)
            .getter(getter(DescribeReplicationGroupsResponse::replicationGroups))
            .setter(setter(Builder::replicationGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ReplicationGroup")
                            .memberFieldInfo(
                                    SdkField.<ReplicationGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicationGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ReplicationGroup").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            REPLICATION_GROUPS_FIELD));

    private final String marker;

    private final List<ReplicationGroup> replicationGroups;

    private DescribeReplicationGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.replicationGroups = builder.replicationGroups;
    }

    /**
     * <p>
     * Provides an identifier to allow retrieval of paginated results.
     * </p>
     * 
     * @return Provides an identifier to allow retrieval of paginated results.
     */
    public String marker() {
        return marker;
    }

    /**
     * Returns true if the ReplicationGroups property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasReplicationGroups() {
        return replicationGroups != null && !(replicationGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of replication groups. Each item in the list contains detailed information about one replication group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReplicationGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of replication groups. Each item in the list contains detailed information about one replication
     *         group.
     */
    public List<ReplicationGroup> replicationGroups() {
        return replicationGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(replicationGroups());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReplicationGroupsResponse)) {
            return false;
        }
        DescribeReplicationGroupsResponse other = (DescribeReplicationGroupsResponse) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(replicationGroups(), other.replicationGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeReplicationGroupsResponse").add("Marker", marker())
                .add("ReplicationGroups", replicationGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "ReplicationGroups":
            return Optional.ofNullable(clazz.cast(replicationGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReplicationGroupsResponse, T> g) {
        return obj -> g.apply((DescribeReplicationGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeReplicationGroupsResponse> {
        /**
         * <p>
         * Provides an identifier to allow retrieval of paginated results.
         * </p>
         * 
         * @param marker
         *        Provides an identifier to allow retrieval of paginated results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A list of replication groups. Each item in the list contains detailed information about one replication
         * group.
         * </p>
         * 
         * @param replicationGroups
         *        A list of replication groups. Each item in the list contains detailed information about one
         *        replication group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroups(Collection<ReplicationGroup> replicationGroups);

        /**
         * <p>
         * A list of replication groups. Each item in the list contains detailed information about one replication
         * group.
         * </p>
         * 
         * @param replicationGroups
         *        A list of replication groups. Each item in the list contains detailed information about one
         *        replication group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroups(ReplicationGroup... replicationGroups);

        /**
         * <p>
         * A list of replication groups. Each item in the list contains detailed information about one replication
         * group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReplicationGroup>.Builder} avoiding the
         * need to create one manually via {@link List<ReplicationGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReplicationGroup>.Builder#build()} is called immediately and
         * its result is passed to {@link #replicationGroups(List<ReplicationGroup>)}.
         * 
         * @param replicationGroups
         *        a consumer that will call methods on {@link List<ReplicationGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationGroups(List<ReplicationGroup>)
         */
        Builder replicationGroups(Consumer<ReplicationGroup.Builder>... replicationGroups);
    }

    static final class BuilderImpl extends ElastiCacheResponse.BuilderImpl implements Builder {
        private String marker;

        private List<ReplicationGroup> replicationGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReplicationGroupsResponse model) {
            super(model);
            marker(model.marker);
            replicationGroups(model.replicationGroups);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ReplicationGroup.Builder> getReplicationGroups() {
            return replicationGroups != null ? replicationGroups.stream().map(ReplicationGroup::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder replicationGroups(Collection<ReplicationGroup> replicationGroups) {
            this.replicationGroups = ReplicationGroupListCopier.copy(replicationGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationGroups(ReplicationGroup... replicationGroups) {
            replicationGroups(Arrays.asList(replicationGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationGroups(Consumer<ReplicationGroup.Builder>... replicationGroups) {
            replicationGroups(Stream.of(replicationGroups).map(c -> ReplicationGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setReplicationGroups(Collection<ReplicationGroup.BuilderImpl> replicationGroups) {
            this.replicationGroups = ReplicationGroupListCopier.copyFromBuilder(replicationGroups);
        }

        @Override
        public DescribeReplicationGroupsResponse build() {
            return new DescribeReplicationGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
