/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>DescribeCacheClusters</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCacheClustersResponse extends ElastiCacheResponse implements
        ToCopyableBuilder<DescribeCacheClustersResponse.Builder, DescribeCacheClustersResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeCacheClustersResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<CacheCluster>> CACHE_CLUSTERS_FIELD = SdkField
            .<List<CacheCluster>> builder(MarshallingType.LIST)
            .getter(getter(DescribeCacheClustersResponse::cacheClusters))
            .setter(setter(Builder::cacheClusters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("CacheCluster")
                            .memberFieldInfo(
                                    SdkField.<CacheCluster> builder(MarshallingType.SDK_POJO)
                                            .constructor(CacheCluster::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("CacheCluster").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            CACHE_CLUSTERS_FIELD));

    private final String marker;

    private final List<CacheCluster> cacheClusters;

    private DescribeCacheClustersResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.cacheClusters = builder.cacheClusters;
    }

    /**
     * <p>
     * Provides an identifier to allow retrieval of paginated results.
     * </p>
     * 
     * @return Provides an identifier to allow retrieval of paginated results.
     */
    public String marker() {
        return marker;
    }

    /**
     * Returns true if the CacheClusters property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasCacheClusters() {
        return cacheClusters != null && !(cacheClusters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of clusters. Each item in the list contains detailed information about one cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCacheClusters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of clusters. Each item in the list contains detailed information about one cluster.
     */
    public List<CacheCluster> cacheClusters() {
        return cacheClusters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(cacheClusters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCacheClustersResponse)) {
            return false;
        }
        DescribeCacheClustersResponse other = (DescribeCacheClustersResponse) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(cacheClusters(), other.cacheClusters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeCacheClustersResponse").add("Marker", marker()).add("CacheClusters", cacheClusters())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "CacheClusters":
            return Optional.ofNullable(clazz.cast(cacheClusters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCacheClustersResponse, T> g) {
        return obj -> g.apply((DescribeCacheClustersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeCacheClustersResponse> {
        /**
         * <p>
         * Provides an identifier to allow retrieval of paginated results.
         * </p>
         * 
         * @param marker
         *        Provides an identifier to allow retrieval of paginated results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A list of clusters. Each item in the list contains detailed information about one cluster.
         * </p>
         * 
         * @param cacheClusters
         *        A list of clusters. Each item in the list contains detailed information about one cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheClusters(Collection<CacheCluster> cacheClusters);

        /**
         * <p>
         * A list of clusters. Each item in the list contains detailed information about one cluster.
         * </p>
         * 
         * @param cacheClusters
         *        A list of clusters. Each item in the list contains detailed information about one cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheClusters(CacheCluster... cacheClusters);

        /**
         * <p>
         * A list of clusters. Each item in the list contains detailed information about one cluster.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CacheCluster>.Builder} avoiding the need to
         * create one manually via {@link List<CacheCluster>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CacheCluster>.Builder#build()} is called immediately and its
         * result is passed to {@link #cacheClusters(List<CacheCluster>)}.
         * 
         * @param cacheClusters
         *        a consumer that will call methods on {@link List<CacheCluster>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cacheClusters(List<CacheCluster>)
         */
        Builder cacheClusters(Consumer<CacheCluster.Builder>... cacheClusters);
    }

    static final class BuilderImpl extends ElastiCacheResponse.BuilderImpl implements Builder {
        private String marker;

        private List<CacheCluster> cacheClusters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCacheClustersResponse model) {
            super(model);
            marker(model.marker);
            cacheClusters(model.cacheClusters);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<CacheCluster.Builder> getCacheClusters() {
            return cacheClusters != null ? cacheClusters.stream().map(CacheCluster::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder cacheClusters(Collection<CacheCluster> cacheClusters) {
            this.cacheClusters = CacheClusterListCopier.copy(cacheClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheClusters(CacheCluster... cacheClusters) {
            cacheClusters(Arrays.asList(cacheClusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheClusters(Consumer<CacheCluster.Builder>... cacheClusters) {
            cacheClusters(Stream.of(cacheClusters).map(c -> CacheCluster.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCacheClusters(Collection<CacheCluster.BuilderImpl> cacheClusters) {
            this.cacheClusters = CacheClusterListCopier.copyFromBuilder(cacheClusters);
        }

        @Override
        public DescribeCacheClustersResponse build() {
            return new DescribeCacheClustersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
