/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>DeleteReplicationGroup</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteReplicationGroupRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<DeleteReplicationGroupRequest.Builder, DeleteReplicationGroupRequest> {
    private static final SdkField<String> REPLICATION_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteReplicationGroupRequest::replicationGroupId)).setter(setter(Builder::replicationGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupId").build())
            .build();

    private static final SdkField<Boolean> RETAIN_PRIMARY_CLUSTER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DeleteReplicationGroupRequest::retainPrimaryCluster)).setter(setter(Builder::retainPrimaryCluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetainPrimaryCluster").build())
            .build();

    private static final SdkField<String> FINAL_SNAPSHOT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteReplicationGroupRequest::finalSnapshotIdentifier))
            .setter(setter(Builder::finalSnapshotIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalSnapshotIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_GROUP_ID_FIELD,
            RETAIN_PRIMARY_CLUSTER_FIELD, FINAL_SNAPSHOT_IDENTIFIER_FIELD));

    private final String replicationGroupId;

    private final Boolean retainPrimaryCluster;

    private final String finalSnapshotIdentifier;

    private DeleteReplicationGroupRequest(BuilderImpl builder) {
        super(builder);
        this.replicationGroupId = builder.replicationGroupId;
        this.retainPrimaryCluster = builder.retainPrimaryCluster;
        this.finalSnapshotIdentifier = builder.finalSnapshotIdentifier;
    }

    /**
     * <p>
     * The identifier for the cluster to be deleted. This parameter is not case sensitive.
     * </p>
     * 
     * @return The identifier for the cluster to be deleted. This parameter is not case sensitive.
     */
    public String replicationGroupId() {
        return replicationGroupId;
    }

    /**
     * <p>
     * If set to <code>true</code>, all of the read replicas are deleted, but the primary node is retained.
     * </p>
     * 
     * @return If set to <code>true</code>, all of the read replicas are deleted, but the primary node is retained.
     */
    public Boolean retainPrimaryCluster() {
        return retainPrimaryCluster;
    }

    /**
     * <p>
     * The name of a final node group (shard) snapshot. ElastiCache creates the snapshot from the primary node in the
     * cluster, rather than one of the replicas; this is to ensure that it captures the freshest data. After the final
     * snapshot is taken, the replication group is immediately deleted.
     * </p>
     * 
     * @return The name of a final node group (shard) snapshot. ElastiCache creates the snapshot from the primary node
     *         in the cluster, rather than one of the replicas; this is to ensure that it captures the freshest data.
     *         After the final snapshot is taken, the replication group is immediately deleted.
     */
    public String finalSnapshotIdentifier() {
        return finalSnapshotIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(retainPrimaryCluster());
        hashCode = 31 * hashCode + Objects.hashCode(finalSnapshotIdentifier());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteReplicationGroupRequest)) {
            return false;
        }
        DeleteReplicationGroupRequest other = (DeleteReplicationGroupRequest) obj;
        return Objects.equals(replicationGroupId(), other.replicationGroupId())
                && Objects.equals(retainPrimaryCluster(), other.retainPrimaryCluster())
                && Objects.equals(finalSnapshotIdentifier(), other.finalSnapshotIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteReplicationGroupRequest").add("ReplicationGroupId", replicationGroupId())
                .add("RetainPrimaryCluster", retainPrimaryCluster()).add("FinalSnapshotIdentifier", finalSnapshotIdentifier())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationGroupId":
            return Optional.ofNullable(clazz.cast(replicationGroupId()));
        case "RetainPrimaryCluster":
            return Optional.ofNullable(clazz.cast(retainPrimaryCluster()));
        case "FinalSnapshotIdentifier":
            return Optional.ofNullable(clazz.cast(finalSnapshotIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteReplicationGroupRequest, T> g) {
        return obj -> g.apply((DeleteReplicationGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteReplicationGroupRequest> {
        /**
         * <p>
         * The identifier for the cluster to be deleted. This parameter is not case sensitive.
         * </p>
         * 
         * @param replicationGroupId
         *        The identifier for the cluster to be deleted. This parameter is not case sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroupId(String replicationGroupId);

        /**
         * <p>
         * If set to <code>true</code>, all of the read replicas are deleted, but the primary node is retained.
         * </p>
         * 
         * @param retainPrimaryCluster
         *        If set to <code>true</code>, all of the read replicas are deleted, but the primary node is retained.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retainPrimaryCluster(Boolean retainPrimaryCluster);

        /**
         * <p>
         * The name of a final node group (shard) snapshot. ElastiCache creates the snapshot from the primary node in
         * the cluster, rather than one of the replicas; this is to ensure that it captures the freshest data. After the
         * final snapshot is taken, the replication group is immediately deleted.
         * </p>
         * 
         * @param finalSnapshotIdentifier
         *        The name of a final node group (shard) snapshot. ElastiCache creates the snapshot from the primary
         *        node in the cluster, rather than one of the replicas; this is to ensure that it captures the freshest
         *        data. After the final snapshot is taken, the replication group is immediately deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalSnapshotIdentifier(String finalSnapshotIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String replicationGroupId;

        private Boolean retainPrimaryCluster;

        private String finalSnapshotIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteReplicationGroupRequest model) {
            super(model);
            replicationGroupId(model.replicationGroupId);
            retainPrimaryCluster(model.retainPrimaryCluster);
            finalSnapshotIdentifier(model.finalSnapshotIdentifier);
        }

        public final String getReplicationGroupId() {
            return replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        public final Boolean getRetainPrimaryCluster() {
            return retainPrimaryCluster;
        }

        @Override
        public final Builder retainPrimaryCluster(Boolean retainPrimaryCluster) {
            this.retainPrimaryCluster = retainPrimaryCluster;
            return this;
        }

        public final void setRetainPrimaryCluster(Boolean retainPrimaryCluster) {
            this.retainPrimaryCluster = retainPrimaryCluster;
        }

        public final String getFinalSnapshotIdentifier() {
            return finalSnapshotIdentifier;
        }

        @Override
        public final Builder finalSnapshotIdentifier(String finalSnapshotIdentifier) {
            this.finalSnapshotIdentifier = finalSnapshotIdentifier;
            return this;
        }

        public final void setFinalSnapshotIdentifier(String finalSnapshotIdentifier) {
            this.finalSnapshotIdentifier = finalSnapshotIdentifier;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteReplicationGroupRequest build() {
            return new DeleteReplicationGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
