/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DecreaseReplicaCountRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<DecreaseReplicaCountRequest.Builder, DecreaseReplicaCountRequest> {
    private static final SdkField<String> REPLICATION_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DecreaseReplicaCountRequest::replicationGroupId)).setter(setter(Builder::replicationGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupId").build())
            .build();

    private static final SdkField<Integer> NEW_REPLICA_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DecreaseReplicaCountRequest::newReplicaCount)).setter(setter(Builder::newReplicaCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewReplicaCount").build()).build();

    private static final SdkField<List<ConfigureShard>> REPLICA_CONFIGURATION_FIELD = SdkField
            .<List<ConfigureShard>> builder(MarshallingType.LIST)
            .getter(getter(DecreaseReplicaCountRequest::replicaConfiguration))
            .setter(setter(Builder::replicaConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaConfiguration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ConfigureShard")
                            .memberFieldInfo(
                                    SdkField.<ConfigureShard> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigureShard::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ConfigureShard").build()).build()).build()).build();

    private static final SdkField<List<String>> REPLICAS_TO_REMOVE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DecreaseReplicaCountRequest::replicasToRemove))
            .setter(setter(Builder::replicasToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicasToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> APPLY_IMMEDIATELY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DecreaseReplicaCountRequest::applyImmediately)).setter(setter(Builder::applyImmediately))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyImmediately").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_GROUP_ID_FIELD,
            NEW_REPLICA_COUNT_FIELD, REPLICA_CONFIGURATION_FIELD, REPLICAS_TO_REMOVE_FIELD, APPLY_IMMEDIATELY_FIELD));

    private final String replicationGroupId;

    private final Integer newReplicaCount;

    private final List<ConfigureShard> replicaConfiguration;

    private final List<String> replicasToRemove;

    private final Boolean applyImmediately;

    private DecreaseReplicaCountRequest(BuilderImpl builder) {
        super(builder);
        this.replicationGroupId = builder.replicationGroupId;
        this.newReplicaCount = builder.newReplicaCount;
        this.replicaConfiguration = builder.replicaConfiguration;
        this.replicasToRemove = builder.replicasToRemove;
        this.applyImmediately = builder.applyImmediately;
    }

    /**
     * <p>
     * The id of the replication group from which you want to remove replica nodes.
     * </p>
     * 
     * @return The id of the replication group from which you want to remove replica nodes.
     */
    public String replicationGroupId() {
        return replicationGroupId;
    }

    /**
     * <p>
     * The number of read replica nodes you want at the completion of this operation. For Redis (cluster mode disabled)
     * replication groups, this is the number of replica nodes in the replication group. For Redis (cluster mode
     * enabled) replication groups, this is the number of replica nodes in each of the replication group's node groups.
     * </p>
     * <p>
     * The minimum number of replicas in a shard or replication group is:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Redis (cluster mode disabled)
     * </p>
     * <ul>
     * <li>
     * <p>
     * If Multi-AZ with Automatic Failover is enabled: 1
     * </p>
     * </li>
     * <li>
     * <p>
     * If Multi-AZ with Automatic Failover is not enabled: 0
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Redis (cluster mode enabled): 0 (though you will not be able to failover to a replica if your primary node fails)
     * </p>
     * </li>
     * </ul>
     * 
     * @return The number of read replica nodes you want at the completion of this operation. For Redis (cluster mode
     *         disabled) replication groups, this is the number of replica nodes in the replication group. For Redis
     *         (cluster mode enabled) replication groups, this is the number of replica nodes in each of the replication
     *         group's node groups.</p>
     *         <p>
     *         The minimum number of replicas in a shard or replication group is:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Redis (cluster mode disabled)
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If Multi-AZ with Automatic Failover is enabled: 1
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If Multi-AZ with Automatic Failover is not enabled: 0
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Redis (cluster mode enabled): 0 (though you will not be able to failover to a replica if your primary
     *         node fails)
     *         </p>
     *         </li>
     */
    public Integer newReplicaCount() {
        return newReplicaCount;
    }

    /**
     * Returns true if the ReplicaConfiguration property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasReplicaConfiguration() {
        return replicaConfiguration != null && !(replicaConfiguration instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>ConfigureShard</code> objects that can be used to configure each shard in a Redis (cluster mode
     * enabled) replication group. The <code>ConfigureShard</code> has three members: <code>NewReplicaCount</code>,
     * <code>NodeGroupId</code>, and <code>PreferredAvailabilityZones</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReplicaConfiguration()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <code>ConfigureShard</code> objects that can be used to configure each shard in a Redis
     *         (cluster mode enabled) replication group. The <code>ConfigureShard</code> has three members:
     *         <code>NewReplicaCount</code>, <code>NodeGroupId</code>, and <code>PreferredAvailabilityZones</code>.
     */
    public List<ConfigureShard> replicaConfiguration() {
        return replicaConfiguration;
    }

    /**
     * Returns true if the ReplicasToRemove property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasReplicasToRemove() {
        return replicasToRemove != null && !(replicasToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the node ids to remove from the replication group or node group (shard).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReplicasToRemove()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the node ids to remove from the replication group or node group (shard).
     */
    public List<String> replicasToRemove() {
        return replicasToRemove;
    }

    /**
     * <p>
     * If <code>True</code>, the number of replica nodes is decreased immediately. <code>ApplyImmediately=False</code>
     * is not currently supported.
     * </p>
     * 
     * @return If <code>True</code>, the number of replica nodes is decreased immediately.
     *         <code>ApplyImmediately=False</code> is not currently supported.
     */
    public Boolean applyImmediately() {
        return applyImmediately;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(newReplicaCount());
        hashCode = 31 * hashCode + Objects.hashCode(replicaConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(replicasToRemove());
        hashCode = 31 * hashCode + Objects.hashCode(applyImmediately());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecreaseReplicaCountRequest)) {
            return false;
        }
        DecreaseReplicaCountRequest other = (DecreaseReplicaCountRequest) obj;
        return Objects.equals(replicationGroupId(), other.replicationGroupId())
                && Objects.equals(newReplicaCount(), other.newReplicaCount())
                && Objects.equals(replicaConfiguration(), other.replicaConfiguration())
                && Objects.equals(replicasToRemove(), other.replicasToRemove())
                && Objects.equals(applyImmediately(), other.applyImmediately());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DecreaseReplicaCountRequest").add("ReplicationGroupId", replicationGroupId())
                .add("NewReplicaCount", newReplicaCount()).add("ReplicaConfiguration", replicaConfiguration())
                .add("ReplicasToRemove", replicasToRemove()).add("ApplyImmediately", applyImmediately()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationGroupId":
            return Optional.ofNullable(clazz.cast(replicationGroupId()));
        case "NewReplicaCount":
            return Optional.ofNullable(clazz.cast(newReplicaCount()));
        case "ReplicaConfiguration":
            return Optional.ofNullable(clazz.cast(replicaConfiguration()));
        case "ReplicasToRemove":
            return Optional.ofNullable(clazz.cast(replicasToRemove()));
        case "ApplyImmediately":
            return Optional.ofNullable(clazz.cast(applyImmediately()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DecreaseReplicaCountRequest, T> g) {
        return obj -> g.apply((DecreaseReplicaCountRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo, CopyableBuilder<Builder, DecreaseReplicaCountRequest> {
        /**
         * <p>
         * The id of the replication group from which you want to remove replica nodes.
         * </p>
         * 
         * @param replicationGroupId
         *        The id of the replication group from which you want to remove replica nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroupId(String replicationGroupId);

        /**
         * <p>
         * The number of read replica nodes you want at the completion of this operation. For Redis (cluster mode
         * disabled) replication groups, this is the number of replica nodes in the replication group. For Redis
         * (cluster mode enabled) replication groups, this is the number of replica nodes in each of the replication
         * group's node groups.
         * </p>
         * <p>
         * The minimum number of replicas in a shard or replication group is:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Redis (cluster mode disabled)
         * </p>
         * <ul>
         * <li>
         * <p>
         * If Multi-AZ with Automatic Failover is enabled: 1
         * </p>
         * </li>
         * <li>
         * <p>
         * If Multi-AZ with Automatic Failover is not enabled: 0
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Redis (cluster mode enabled): 0 (though you will not be able to failover to a replica if your primary node
         * fails)
         * </p>
         * </li>
         * </ul>
         * 
         * @param newReplicaCount
         *        The number of read replica nodes you want at the completion of this operation. For Redis (cluster mode
         *        disabled) replication groups, this is the number of replica nodes in the replication group. For Redis
         *        (cluster mode enabled) replication groups, this is the number of replica nodes in each of the
         *        replication group's node groups.</p>
         *        <p>
         *        The minimum number of replicas in a shard or replication group is:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Redis (cluster mode disabled)
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If Multi-AZ with Automatic Failover is enabled: 1
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If Multi-AZ with Automatic Failover is not enabled: 0
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Redis (cluster mode enabled): 0 (though you will not be able to failover to a replica if your primary
         *        node fails)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newReplicaCount(Integer newReplicaCount);

        /**
         * <p>
         * A list of <code>ConfigureShard</code> objects that can be used to configure each shard in a Redis (cluster
         * mode enabled) replication group. The <code>ConfigureShard</code> has three members:
         * <code>NewReplicaCount</code>, <code>NodeGroupId</code>, and <code>PreferredAvailabilityZones</code>.
         * </p>
         * 
         * @param replicaConfiguration
         *        A list of <code>ConfigureShard</code> objects that can be used to configure each shard in a Redis
         *        (cluster mode enabled) replication group. The <code>ConfigureShard</code> has three members:
         *        <code>NewReplicaCount</code>, <code>NodeGroupId</code>, and <code>PreferredAvailabilityZones</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaConfiguration(Collection<ConfigureShard> replicaConfiguration);

        /**
         * <p>
         * A list of <code>ConfigureShard</code> objects that can be used to configure each shard in a Redis (cluster
         * mode enabled) replication group. The <code>ConfigureShard</code> has three members:
         * <code>NewReplicaCount</code>, <code>NodeGroupId</code>, and <code>PreferredAvailabilityZones</code>.
         * </p>
         * 
         * @param replicaConfiguration
         *        A list of <code>ConfigureShard</code> objects that can be used to configure each shard in a Redis
         *        (cluster mode enabled) replication group. The <code>ConfigureShard</code> has three members:
         *        <code>NewReplicaCount</code>, <code>NodeGroupId</code>, and <code>PreferredAvailabilityZones</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaConfiguration(ConfigureShard... replicaConfiguration);

        /**
         * <p>
         * A list of <code>ConfigureShard</code> objects that can be used to configure each shard in a Redis (cluster
         * mode enabled) replication group. The <code>ConfigureShard</code> has three members:
         * <code>NewReplicaCount</code>, <code>NodeGroupId</code>, and <code>PreferredAvailabilityZones</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ConfigureShard>.Builder} avoiding the need
         * to create one manually via {@link List<ConfigureShard>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConfigureShard>.Builder#build()} is called immediately and
         * its result is passed to {@link #replicaConfiguration(List<ConfigureShard>)}.
         * 
         * @param replicaConfiguration
         *        a consumer that will call methods on {@link List<ConfigureShard>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicaConfiguration(List<ConfigureShard>)
         */
        Builder replicaConfiguration(Consumer<ConfigureShard.Builder>... replicaConfiguration);

        /**
         * <p>
         * A list of the node ids to remove from the replication group or node group (shard).
         * </p>
         * 
         * @param replicasToRemove
         *        A list of the node ids to remove from the replication group or node group (shard).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicasToRemove(Collection<String> replicasToRemove);

        /**
         * <p>
         * A list of the node ids to remove from the replication group or node group (shard).
         * </p>
         * 
         * @param replicasToRemove
         *        A list of the node ids to remove from the replication group or node group (shard).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicasToRemove(String... replicasToRemove);

        /**
         * <p>
         * If <code>True</code>, the number of replica nodes is decreased immediately.
         * <code>ApplyImmediately=False</code> is not currently supported.
         * </p>
         * 
         * @param applyImmediately
         *        If <code>True</code>, the number of replica nodes is decreased immediately.
         *        <code>ApplyImmediately=False</code> is not currently supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyImmediately(Boolean applyImmediately);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String replicationGroupId;

        private Integer newReplicaCount;

        private List<ConfigureShard> replicaConfiguration = DefaultSdkAutoConstructList.getInstance();

        private List<String> replicasToRemove = DefaultSdkAutoConstructList.getInstance();

        private Boolean applyImmediately;

        private BuilderImpl() {
        }

        private BuilderImpl(DecreaseReplicaCountRequest model) {
            super(model);
            replicationGroupId(model.replicationGroupId);
            newReplicaCount(model.newReplicaCount);
            replicaConfiguration(model.replicaConfiguration);
            replicasToRemove(model.replicasToRemove);
            applyImmediately(model.applyImmediately);
        }

        public final String getReplicationGroupId() {
            return replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        public final Integer getNewReplicaCount() {
            return newReplicaCount;
        }

        @Override
        public final Builder newReplicaCount(Integer newReplicaCount) {
            this.newReplicaCount = newReplicaCount;
            return this;
        }

        public final void setNewReplicaCount(Integer newReplicaCount) {
            this.newReplicaCount = newReplicaCount;
        }

        public final Collection<ConfigureShard.Builder> getReplicaConfiguration() {
            return replicaConfiguration != null ? replicaConfiguration.stream().map(ConfigureShard::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder replicaConfiguration(Collection<ConfigureShard> replicaConfiguration) {
            this.replicaConfiguration = ReplicaConfigurationListCopier.copy(replicaConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaConfiguration(ConfigureShard... replicaConfiguration) {
            replicaConfiguration(Arrays.asList(replicaConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaConfiguration(Consumer<ConfigureShard.Builder>... replicaConfiguration) {
            replicaConfiguration(Stream.of(replicaConfiguration).map(c -> ConfigureShard.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setReplicaConfiguration(Collection<ConfigureShard.BuilderImpl> replicaConfiguration) {
            this.replicaConfiguration = ReplicaConfigurationListCopier.copyFromBuilder(replicaConfiguration);
        }

        public final Collection<String> getReplicasToRemove() {
            return replicasToRemove;
        }

        @Override
        public final Builder replicasToRemove(Collection<String> replicasToRemove) {
            this.replicasToRemove = RemoveReplicasListCopier.copy(replicasToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicasToRemove(String... replicasToRemove) {
            replicasToRemove(Arrays.asList(replicasToRemove));
            return this;
        }

        public final void setReplicasToRemove(Collection<String> replicasToRemove) {
            this.replicasToRemove = RemoveReplicasListCopier.copy(replicasToRemove);
        }

        public final Boolean getApplyImmediately() {
            return applyImmediately;
        }

        @Override
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DecreaseReplicaCountRequest build() {
            return new DecreaseReplicaCountRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
