/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a CreateCacheCluster operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCacheClusterRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<CreateCacheClusterRequest.Builder, CreateCacheClusterRequest> {
    private static final SdkField<String> CACHE_CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCacheClusterRequest::cacheClusterId)).setter(setter(Builder::cacheClusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusterId").build()).build();

    private static final SdkField<String> REPLICATION_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCacheClusterRequest::replicationGroupId)).setter(setter(Builder::replicationGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupId").build())
            .build();

    private static final SdkField<String> AZ_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCacheClusterRequest::azModeAsString)).setter(setter(Builder::azMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AZMode").build()).build();

    private static final SdkField<String> PREFERRED_AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCacheClusterRequest::preferredAvailabilityZone))
            .setter(setter(Builder::preferredAvailabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredAvailabilityZone").build())
            .build();

    private static final SdkField<List<String>> PREFERRED_AVAILABILITY_ZONES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateCacheClusterRequest::preferredAvailabilityZones))
            .setter(setter(Builder::preferredAvailabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredAvailabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("PreferredAvailabilityZone")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("PreferredAvailabilityZone").build()).build()).build()).build();

    private static final SdkField<Integer> NUM_CACHE_NODES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateCacheClusterRequest::numCacheNodes)).setter(setter(Builder::numCacheNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumCacheNodes").build()).build();

    private static final SdkField<String> CACHE_NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCacheClusterRequest::cacheNodeType)).setter(setter(Builder::cacheNodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeType").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCacheClusterRequest::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCacheClusterRequest::engineVersion)).setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<String> CACHE_PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCacheClusterRequest::cacheParameterGroupName)).setter(setter(Builder::cacheParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheParameterGroupName").build())
            .build();

    private static final SdkField<String> CACHE_SUBNET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCacheClusterRequest::cacheSubnetGroupName)).setter(setter(Builder::cacheSubnetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSubnetGroupName").build())
            .build();

    private static final SdkField<List<String>> CACHE_SECURITY_GROUP_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateCacheClusterRequest::cacheSecurityGroupNames))
            .setter(setter(Builder::cacheSecurityGroupNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSecurityGroupNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("CacheSecurityGroupName")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("CacheSecurityGroupName").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateCacheClusterRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SecurityGroupId").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateCacheClusterRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final SdkField<List<String>> SNAPSHOT_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateCacheClusterRequest::snapshotArns))
            .setter(setter(Builder::snapshotArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SnapshotArn")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SnapshotArn").build()).build()).build()).build();

    private static final SdkField<String> SNAPSHOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCacheClusterRequest::snapshotName)).setter(setter(Builder::snapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotName").build()).build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCacheClusterRequest::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateCacheClusterRequest::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> NOTIFICATION_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCacheClusterRequest::notificationTopicArn)).setter(setter(Builder::notificationTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationTopicArn").build())
            .build();

    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateCacheClusterRequest::autoMinorVersionUpgrade)).setter(setter(Builder::autoMinorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build())
            .build();

    private static final SdkField<Integer> SNAPSHOT_RETENTION_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateCacheClusterRequest::snapshotRetentionLimit)).setter(setter(Builder::snapshotRetentionLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotRetentionLimit").build())
            .build();

    private static final SdkField<String> SNAPSHOT_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCacheClusterRequest::snapshotWindow)).setter(setter(Builder::snapshotWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotWindow").build()).build();

    private static final SdkField<String> AUTH_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCacheClusterRequest::authToken)).setter(setter(Builder::authToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_CLUSTER_ID_FIELD,
            REPLICATION_GROUP_ID_FIELD, AZ_MODE_FIELD, PREFERRED_AVAILABILITY_ZONE_FIELD, PREFERRED_AVAILABILITY_ZONES_FIELD,
            NUM_CACHE_NODES_FIELD, CACHE_NODE_TYPE_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, CACHE_PARAMETER_GROUP_NAME_FIELD,
            CACHE_SUBNET_GROUP_NAME_FIELD, CACHE_SECURITY_GROUP_NAMES_FIELD, SECURITY_GROUP_IDS_FIELD, TAGS_FIELD,
            SNAPSHOT_ARNS_FIELD, SNAPSHOT_NAME_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, PORT_FIELD,
            NOTIFICATION_TOPIC_ARN_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, SNAPSHOT_RETENTION_LIMIT_FIELD,
            SNAPSHOT_WINDOW_FIELD, AUTH_TOKEN_FIELD));

    private final String cacheClusterId;

    private final String replicationGroupId;

    private final String azMode;

    private final String preferredAvailabilityZone;

    private final List<String> preferredAvailabilityZones;

    private final Integer numCacheNodes;

    private final String cacheNodeType;

    private final String engine;

    private final String engineVersion;

    private final String cacheParameterGroupName;

    private final String cacheSubnetGroupName;

    private final List<String> cacheSecurityGroupNames;

    private final List<String> securityGroupIds;

    private final List<Tag> tags;

    private final List<String> snapshotArns;

    private final String snapshotName;

    private final String preferredMaintenanceWindow;

    private final Integer port;

    private final String notificationTopicArn;

    private final Boolean autoMinorVersionUpgrade;

    private final Integer snapshotRetentionLimit;

    private final String snapshotWindow;

    private final String authToken;

    private CreateCacheClusterRequest(BuilderImpl builder) {
        super(builder);
        this.cacheClusterId = builder.cacheClusterId;
        this.replicationGroupId = builder.replicationGroupId;
        this.azMode = builder.azMode;
        this.preferredAvailabilityZone = builder.preferredAvailabilityZone;
        this.preferredAvailabilityZones = builder.preferredAvailabilityZones;
        this.numCacheNodes = builder.numCacheNodes;
        this.cacheNodeType = builder.cacheNodeType;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.cacheParameterGroupName = builder.cacheParameterGroupName;
        this.cacheSubnetGroupName = builder.cacheSubnetGroupName;
        this.cacheSecurityGroupNames = builder.cacheSecurityGroupNames;
        this.securityGroupIds = builder.securityGroupIds;
        this.tags = builder.tags;
        this.snapshotArns = builder.snapshotArns;
        this.snapshotName = builder.snapshotName;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.port = builder.port;
        this.notificationTopicArn = builder.notificationTopicArn;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.snapshotWindow = builder.snapshotWindow;
        this.authToken = builder.authToken;
    }

    /**
     * <p>
     * The node group (shard) identifier. This parameter is stored as a lowercase string.
     * </p>
     * <p>
     * <b>Constraints:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * A name must contain from 1 to 50 alphanumeric characters or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * The first character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * A name cannot end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The node group (shard) identifier. This parameter is stored as a lowercase string.</p>
     *         <p>
     *         <b>Constraints:</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A name must contain from 1 to 50 alphanumeric characters or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The first character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A name cannot end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     */
    public String cacheClusterId() {
        return cacheClusterId;
    }

    /**
     * <p>
     * The ID of the replication group to which this cluster should belong. If this parameter is specified, the cluster
     * is added to the specified replication group as a read replica; otherwise, the cluster is a standalone primary
     * that is not part of any replication group.
     * </p>
     * <p>
     * If the specified replication group is Multi-AZ enabled and the Availability Zone is not specified, the cluster is
     * created in Availability Zones that provide the best spread of read replicas across Availability Zones.
     * </p>
     * <note>
     * <p>
     * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
     * </p>
     * </note>
     * 
     * @return The ID of the replication group to which this cluster should belong. If this parameter is specified, the
     *         cluster is added to the specified replication group as a read replica; otherwise, the cluster is a
     *         standalone primary that is not part of any replication group.</p>
     *         <p>
     *         If the specified replication group is Multi-AZ enabled and the Availability Zone is not specified, the
     *         cluster is created in Availability Zones that provide the best spread of read replicas across
     *         Availability Zones.
     *         </p>
     *         <note>
     *         <p>
     *         This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
     *         </p>
     */
    public String replicationGroupId() {
        return replicationGroupId;
    }

    /**
     * <p>
     * Specifies whether the nodes in this Memcached cluster are created in a single Availability Zone or created across
     * multiple Availability Zones in the cluster's region.
     * </p>
     * <p>
     * This parameter is only supported for Memcached clusters.
     * </p>
     * <p>
     * If the <code>AZMode</code> and <code>PreferredAvailabilityZones</code> are not specified, ElastiCache assumes
     * <code>single-az</code> mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #azMode} will
     * return {@link AZMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #azModeAsString}.
     * </p>
     * 
     * @return Specifies whether the nodes in this Memcached cluster are created in a single Availability Zone or
     *         created across multiple Availability Zones in the cluster's region.</p>
     *         <p>
     *         This parameter is only supported for Memcached clusters.
     *         </p>
     *         <p>
     *         If the <code>AZMode</code> and <code>PreferredAvailabilityZones</code> are not specified, ElastiCache
     *         assumes <code>single-az</code> mode.
     * @see AZMode
     */
    public AZMode azMode() {
        return AZMode.fromValue(azMode);
    }

    /**
     * <p>
     * Specifies whether the nodes in this Memcached cluster are created in a single Availability Zone or created across
     * multiple Availability Zones in the cluster's region.
     * </p>
     * <p>
     * This parameter is only supported for Memcached clusters.
     * </p>
     * <p>
     * If the <code>AZMode</code> and <code>PreferredAvailabilityZones</code> are not specified, ElastiCache assumes
     * <code>single-az</code> mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #azMode} will
     * return {@link AZMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #azModeAsString}.
     * </p>
     * 
     * @return Specifies whether the nodes in this Memcached cluster are created in a single Availability Zone or
     *         created across multiple Availability Zones in the cluster's region.</p>
     *         <p>
     *         This parameter is only supported for Memcached clusters.
     *         </p>
     *         <p>
     *         If the <code>AZMode</code> and <code>PreferredAvailabilityZones</code> are not specified, ElastiCache
     *         assumes <code>single-az</code> mode.
     * @see AZMode
     */
    public String azModeAsString() {
        return azMode;
    }

    /**
     * <p>
     * The EC2 Availability Zone in which the cluster is created.
     * </p>
     * <p>
     * All nodes belonging to this Memcached cluster are placed in the preferred Availability Zone. If you want to
     * create your nodes across multiple Availability Zones, use <code>PreferredAvailabilityZones</code>.
     * </p>
     * <p>
     * Default: System chosen Availability Zone.
     * </p>
     * 
     * @return The EC2 Availability Zone in which the cluster is created.</p>
     *         <p>
     *         All nodes belonging to this Memcached cluster are placed in the preferred Availability Zone. If you want
     *         to create your nodes across multiple Availability Zones, use <code>PreferredAvailabilityZones</code>.
     *         </p>
     *         <p>
     *         Default: System chosen Availability Zone.
     */
    public String preferredAvailabilityZone() {
        return preferredAvailabilityZone;
    }

    /**
     * Returns true if the PreferredAvailabilityZones property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasPreferredAvailabilityZones() {
        return preferredAvailabilityZones != null && !(preferredAvailabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the Availability Zones in which cache nodes are created. The order of the zones in the list is not
     * important.
     * </p>
     * <p>
     * This option is only supported on Memcached.
     * </p>
     * <note>
     * <p>
     * If you are creating your cluster in an Amazon VPC (recommended) you can only locate nodes in Availability Zones
     * that are associated with the subnets in the selected subnet group.
     * </p>
     * <p>
     * The number of Availability Zones listed must equal the value of <code>NumCacheNodes</code>.
     * </p>
     * </note>
     * <p>
     * If you want all the nodes in the same Availability Zone, use <code>PreferredAvailabilityZone</code> instead, or
     * repeat the Availability Zone multiple times in the list.
     * </p>
     * <p>
     * Default: System chosen Availability Zones.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPreferredAvailabilityZones()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the Availability Zones in which cache nodes are created. The order of the zones in the list is
     *         not important.</p>
     *         <p>
     *         This option is only supported on Memcached.
     *         </p>
     *         <note>
     *         <p>
     *         If you are creating your cluster in an Amazon VPC (recommended) you can only locate nodes in Availability
     *         Zones that are associated with the subnets in the selected subnet group.
     *         </p>
     *         <p>
     *         The number of Availability Zones listed must equal the value of <code>NumCacheNodes</code>.
     *         </p>
     *         </note>
     *         <p>
     *         If you want all the nodes in the same Availability Zone, use <code>PreferredAvailabilityZone</code>
     *         instead, or repeat the Availability Zone multiple times in the list.
     *         </p>
     *         <p>
     *         Default: System chosen Availability Zones.
     */
    public List<String> preferredAvailabilityZones() {
        return preferredAvailabilityZones;
    }

    /**
     * <p>
     * The initial number of cache nodes that the cluster has.
     * </p>
     * <p>
     * For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be between 1
     * and 20.
     * </p>
     * <p>
     * If you need more than 20 nodes for your Memcached cluster, please fill out the ElastiCache Limit Increase Request
     * form at <a
     * href="http://aws.amazon.com/contact-us/elasticache-node-limit-request/">http://aws.amazon.com/contact-us
     * /elasticache-node-limit-request/</a>.
     * </p>
     * 
     * @return The initial number of cache nodes that the cluster has.</p>
     *         <p>
     *         For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be
     *         between 1 and 20.
     *         </p>
     *         <p>
     *         If you need more than 20 nodes for your Memcached cluster, please fill out the ElastiCache Limit Increase
     *         Request form at <a
     *         href="http://aws.amazon.com/contact-us/elasticache-node-limit-request/">http://aws.amazon
     *         .com/contact-us/elasticache-node-limit-request/</a>.
     */
    public Integer numCacheNodes() {
        return numCacheNodes;
    }

    /**
     * <p>
     * The compute and memory capacity of the nodes in the node group (shard).
     * </p>
     * <p>
     * The following node types are supported by ElastiCache. Generally speaking, the current generation types provide
     * more memory and computational power at lower cost when compared to their equivalent previous generation
     * counterparts.
     * </p>
     * <ul>
     * <li>
     * <p>
     * General purpose:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Current generation:
     * </p>
     * <p>
     * <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>,
     * <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code>
     * </p>
     * <p>
     * <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>,
     * <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code>
     * </p>
     * <p>
     * <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Previous generation: (not recommended)
     * </p>
     * <p>
     * <b>T1 node types:</b> <code>cache.t1.micro</code>
     * </p>
     * <p>
     * <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>,
     * <code>cache.m1.xlarge</code>
     * </p>
     * <p>
     * <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>,
     * <code>cache.m3.2xlarge</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Compute optimized:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Previous generation: (not recommended)
     * </p>
     * <p>
     * <b>C1 node types:</b> <code>cache.c1.xlarge</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Memory optimized:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Current generation:
     * </p>
     * <p>
     * <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>,
     * <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code>
     * </p>
     * <p>
     * <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>,
     * <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Previous generation: (not recommended)
     * </p>
     * <p>
     * <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code>
     * </p>
     * <p>
     * <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>,
     * <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * <b>Additional node type info</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * All current generation instance types are created in Amazon VPC by default.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis append-only files (AOF) are not supported for T1 or T2 instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis Multi-AZ with automatic failover is not supported on T1 instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis
     * version 2.8.22 and later.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The compute and memory capacity of the nodes in the node group (shard).</p>
     *         <p>
     *         The following node types are supported by ElastiCache. Generally speaking, the current generation types
     *         provide more memory and computational power at lower cost when compared to their equivalent previous
     *         generation counterparts.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         General purpose:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Current generation:
     *         </p>
     *         <p>
     *         <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>,
     *         <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>,
     *         <code>cache.m5.24xlarge</code>
     *         </p>
     *         <p>
     *         <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>,
     *         <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code>
     *         </p>
     *         <p>
     *         <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>,
     *         <code>cache.t2.medium</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Previous generation: (not recommended)
     *         </p>
     *         <p>
     *         <b>T1 node types:</b> <code>cache.t1.micro</code>
     *         </p>
     *         <p>
     *         <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>,
     *         <code>cache.m1.large</code>, <code>cache.m1.xlarge</code>
     *         </p>
     *         <p>
     *         <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>,
     *         <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Compute optimized:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Previous generation: (not recommended)
     *         </p>
     *         <p>
     *         <b>C1 node types:</b> <code>cache.c1.xlarge</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Memory optimized:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Current generation:
     *         </p>
     *         <p>
     *         <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>,
     *         <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>,
     *         <code>cache.r5.24xlarge</code>
     *         </p>
     *         <p>
     *         <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>,
     *         <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>,
     *         <code>cache.r4.16xlarge</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Previous generation: (not recommended)
     *         </p>
     *         <p>
     *         <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>,
     *         <code>cache.m2.4xlarge</code>
     *         </p>
     *         <p>
     *         <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>,
     *         <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Additional node type info</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         All current generation instance types are created in Amazon VPC by default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Redis append-only files (AOF) are not supported for T1 or T2 instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Redis Multi-AZ with automatic failover is not supported on T1 instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on
     *         Redis version 2.8.22 and later.
     *         </p>
     *         </li>
     */
    public String cacheNodeType() {
        return cacheNodeType;
    }

    /**
     * <p>
     * The name of the cache engine to be used for this cluster.
     * </p>
     * <p>
     * Valid values for this parameter are: <code>memcached</code> | <code>redis</code>
     * </p>
     * 
     * @return The name of the cache engine to be used for this cluster.</p>
     *         <p>
     *         Valid values for this parameter are: <code>memcached</code> | <code>redis</code>
     */
    public String engine() {
        return engine;
    }

    /**
     * <p>
     * The version number of the cache engine to be used for this cluster. To view the supported cache engine versions,
     * use the DescribeCacheEngineVersions operation.
     * </p>
     * <p>
     * <b>Important:</b> You can upgrade to a newer engine version (see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting
     * a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you want to use an
     * earlier engine version, you must delete the existing cluster or replication group and create it anew with the
     * earlier engine version.
     * </p>
     * 
     * @return The version number of the cache engine to be used for this cluster. To view the supported cache engine
     *         versions, use the DescribeCacheEngineVersions operation.</p>
     *         <p>
     *         <b>Important:</b> You can upgrade to a newer engine version (see <a
     *         href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement"
     *         >Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you
     *         want to use an earlier engine version, you must delete the existing cluster or replication group and
     *         create it anew with the earlier engine version.
     */
    public String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The name of the parameter group to associate with this cluster. If this argument is omitted, the default
     * parameter group for the specified engine is used. You cannot use any parameter group which has
     * <code>cluster-enabled='yes'</code> when creating a cluster.
     * </p>
     * 
     * @return The name of the parameter group to associate with this cluster. If this argument is omitted, the default
     *         parameter group for the specified engine is used. You cannot use any parameter group which has
     *         <code>cluster-enabled='yes'</code> when creating a cluster.
     */
    public String cacheParameterGroupName() {
        return cacheParameterGroupName;
    }

    /**
     * <p>
     * The name of the subnet group to be used for the cluster.
     * </p>
     * <p>
     * Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).
     * </p>
     * <important>
     * <p>
     * If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start
     * creating a cluster. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html">Subnets and Subnet
     * Groups</a>.
     * </p>
     * </important>
     * 
     * @return The name of the subnet group to be used for the cluster.</p>
     *         <p>
     *         Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).
     *         </p>
     *         <important>
     *         <p>
     *         If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you
     *         start creating a cluster. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html">Subnets and Subnet
     *         Groups</a>.
     *         </p>
     */
    public String cacheSubnetGroupName() {
        return cacheSubnetGroupName;
    }

    /**
     * Returns true if the CacheSecurityGroupNames property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasCacheSecurityGroupNames() {
        return cacheSecurityGroupNames != null && !(cacheSecurityGroupNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of security group names to associate with this cluster.
     * </p>
     * <p>
     * Use this parameter only when you are creating a cluster outside of an Amazon Virtual Private Cloud (Amazon VPC).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCacheSecurityGroupNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of security group names to associate with this cluster.</p>
     *         <p>
     *         Use this parameter only when you are creating a cluster outside of an Amazon Virtual Private Cloud
     *         (Amazon VPC).
     */
    public List<String> cacheSecurityGroupNames() {
        return cacheSecurityGroupNames;
    }

    /**
     * Returns true if the SecurityGroupIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more VPC security groups associated with the cluster.
     * </p>
     * <p>
     * Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroupIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more VPC security groups associated with the cluster.</p>
     *         <p>
     *         Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).
     */
    public List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of cost allocation tags to be added to this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of cost allocation tags to be added to this resource.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * Returns true if the SnapshotArns property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSnapshotArns() {
        return snapshotArns != null && !(snapshotArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A single-element string list containing an Amazon Resource Name (ARN) that uniquely identifies a Redis RDB
     * snapshot file stored in Amazon S3. The snapshot file is used to populate the node group (shard). The Amazon S3
     * object name in the ARN cannot contain any commas.
     * </p>
     * <note>
     * <p>
     * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
     * </p>
     * </note>
     * <p>
     * Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSnapshotArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A single-element string list containing an Amazon Resource Name (ARN) that uniquely identifies a Redis
     *         RDB snapshot file stored in Amazon S3. The snapshot file is used to populate the node group (shard). The
     *         Amazon S3 object name in the ARN cannot contain any commas.</p> <note>
     *         <p>
     *         This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
     *         </p>
     *         </note>
     *         <p>
     *         Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
     */
    public List<String> snapshotArns() {
        return snapshotArns;
    }

    /**
     * <p>
     * The name of a Redis snapshot from which to restore data into the new node group (shard). The snapshot status
     * changes to <code>restoring</code> while the new node group (shard) is being created.
     * </p>
     * <note>
     * <p>
     * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
     * </p>
     * </note>
     * 
     * @return The name of a Redis snapshot from which to restore data into the new node group (shard). The snapshot
     *         status changes to <code>restoring</code> while the new node group (shard) is being created.</p> <note>
     *         <p>
     *         This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
     *         </p>
     */
    public String snapshotName() {
        return snapshotName;
    }

    /**
     * <p>
     * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range
     * in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
     * Valid values for <code>ddd</code> are:
     * </p>
     * <p>
     * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range
     * in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
     * </p>
     * <p>
     * Valid values for <code>ddd</code> are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>sun</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>mon</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tue</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>wed</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>thu</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fri</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sat</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>sun:23:00-mon:01:30</code>
     * </p>
     * 
     * @return Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as
     *         a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60
     *         minute period. Valid values for <code>ddd</code> are:</p>
     *         <p>
     *         Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as
     *         a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60
     *         minute period.
     *         </p>
     *         <p>
     *         Valid values for <code>ddd</code> are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>sun</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>mon</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tue</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>wed</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>thu</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>fri</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sat</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>sun:23:00-mon:01:30</code>
     */
    public String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * The port number on which each of the cache nodes accepts connections.
     * </p>
     * 
     * @return The port number on which each of the cache nodes accepts connections.
     */
    public Integer port() {
        return port;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are
     * sent.
     * </p>
     * <note>
     * <p>
     * The Amazon SNS topic owner must be the same as the cluster owner.
     * </p>
     * </note>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which
     *         notifications are sent.</p> <note>
     *         <p>
     *         The Amazon SNS topic owner must be the same as the cluster owner.
     *         </p>
     */
    public String notificationTopicArn() {
        return notificationTopicArn;
    }

    /**
     * <p>
     * This parameter is currently disabled.
     * </p>
     * 
     * @return This parameter is currently disabled.
     */
    public Boolean autoMinorVersionUpgrade() {
        return autoMinorVersionUpgrade;
    }

    /**
     * <p>
     * The number of days for which ElastiCache retains automatic snapshots before deleting them. For example, if you
     * set <code>SnapshotRetentionLimit</code> to 5, a snapshot taken today is retained for 5 days before being deleted.
     * </p>
     * <note>
     * <p>
     * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
     * </p>
     * </note>
     * <p>
     * Default: 0 (i.e., automatic backups are disabled for this cache cluster).
     * </p>
     * 
     * @return The number of days for which ElastiCache retains automatic snapshots before deleting them. For example,
     *         if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot taken today is retained for 5 days before
     *         being deleted.</p> <note>
     *         <p>
     *         This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
     *         </p>
     *         </note>
     *         <p>
     *         Default: 0 (i.e., automatic backups are disabled for this cache cluster).
     */
    public Integer snapshotRetentionLimit() {
        return snapshotRetentionLimit;
    }

    /**
     * <p>
     * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).
     * </p>
     * <p>
     * Example: <code>05:00-09:00</code>
     * </p>
     * <p>
     * If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
     * </p>
     * <note>
     * <p>
     * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
     * </p>
     * </note>
     * 
     * @return The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group
     *         (shard).</p>
     *         <p>
     *         Example: <code>05:00-09:00</code>
     *         </p>
     *         <p>
     *         If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
     *         </p>
     *         <note>
     *         <p>
     *         This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
     *         </p>
     */
    public String snapshotWindow() {
        return snapshotWindow;
    }

    /**
     * <p>
     * <b>Reserved parameter.</b> The password used to access a password protected server.
     * </p>
     * <p>
     * Password constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be only printable ASCII characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be at least 16 characters and no more than 128 characters in length.
     * </p>
     * </li>
     * <li>
     * <p>
     * The only permitted printable special characters are !, &amp;, #, $, ^, &lt;, &gt;, and -. Other printable special
     * characters cannot be used in the AUTH token.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href="http://redis.io/commands/AUTH">AUTH password</a> at
     * http://redis.io/commands/AUTH.
     * </p>
     * 
     * @return <b>Reserved parameter.</b> The password used to access a password protected server.</p>
     *         <p>
     *         Password constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be only printable ASCII characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be at least 16 characters and no more than 128 characters in length.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The only permitted printable special characters are !, &amp;, #, $, ^, &lt;, &gt;, and -. Other printable
     *         special characters cannot be used in the AUTH token.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a href="http://redis.io/commands/AUTH">AUTH password</a> at
     *         http://redis.io/commands/AUTH.
     */
    public String authToken() {
        return authToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cacheClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(azModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(preferredAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(preferredAvailabilityZones());
        hashCode = 31 * hashCode + Objects.hashCode(numCacheNodes());
        hashCode = 31 * hashCode + Objects.hashCode(cacheNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(cacheParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(cacheSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(cacheSecurityGroupNames());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotArns());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(notificationTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotRetentionLimit());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotWindow());
        hashCode = 31 * hashCode + Objects.hashCode(authToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCacheClusterRequest)) {
            return false;
        }
        CreateCacheClusterRequest other = (CreateCacheClusterRequest) obj;
        return Objects.equals(cacheClusterId(), other.cacheClusterId())
                && Objects.equals(replicationGroupId(), other.replicationGroupId())
                && Objects.equals(azModeAsString(), other.azModeAsString())
                && Objects.equals(preferredAvailabilityZone(), other.preferredAvailabilityZone())
                && Objects.equals(preferredAvailabilityZones(), other.preferredAvailabilityZones())
                && Objects.equals(numCacheNodes(), other.numCacheNodes())
                && Objects.equals(cacheNodeType(), other.cacheNodeType()) && Objects.equals(engine(), other.engine())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(cacheParameterGroupName(), other.cacheParameterGroupName())
                && Objects.equals(cacheSubnetGroupName(), other.cacheSubnetGroupName())
                && Objects.equals(cacheSecurityGroupNames(), other.cacheSecurityGroupNames())
                && Objects.equals(securityGroupIds(), other.securityGroupIds()) && Objects.equals(tags(), other.tags())
                && Objects.equals(snapshotArns(), other.snapshotArns()) && Objects.equals(snapshotName(), other.snapshotName())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(port(), other.port()) && Objects.equals(notificationTopicArn(), other.notificationTopicArn())
                && Objects.equals(autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade())
                && Objects.equals(snapshotRetentionLimit(), other.snapshotRetentionLimit())
                && Objects.equals(snapshotWindow(), other.snapshotWindow()) && Objects.equals(authToken(), other.authToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateCacheClusterRequest").add("CacheClusterId", cacheClusterId())
                .add("ReplicationGroupId", replicationGroupId()).add("AZMode", azModeAsString())
                .add("PreferredAvailabilityZone", preferredAvailabilityZone())
                .add("PreferredAvailabilityZones", preferredAvailabilityZones()).add("NumCacheNodes", numCacheNodes())
                .add("CacheNodeType", cacheNodeType()).add("Engine", engine()).add("EngineVersion", engineVersion())
                .add("CacheParameterGroupName", cacheParameterGroupName()).add("CacheSubnetGroupName", cacheSubnetGroupName())
                .add("CacheSecurityGroupNames", cacheSecurityGroupNames()).add("SecurityGroupIds", securityGroupIds())
                .add("Tags", tags()).add("SnapshotArns", snapshotArns()).add("SnapshotName", snapshotName())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow()).add("Port", port())
                .add("NotificationTopicArn", notificationTopicArn()).add("AutoMinorVersionUpgrade", autoMinorVersionUpgrade())
                .add("SnapshotRetentionLimit", snapshotRetentionLimit()).add("SnapshotWindow", snapshotWindow())
                .add("AuthToken", authToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CacheClusterId":
            return Optional.ofNullable(clazz.cast(cacheClusterId()));
        case "ReplicationGroupId":
            return Optional.ofNullable(clazz.cast(replicationGroupId()));
        case "AZMode":
            return Optional.ofNullable(clazz.cast(azModeAsString()));
        case "PreferredAvailabilityZone":
            return Optional.ofNullable(clazz.cast(preferredAvailabilityZone()));
        case "PreferredAvailabilityZones":
            return Optional.ofNullable(clazz.cast(preferredAvailabilityZones()));
        case "NumCacheNodes":
            return Optional.ofNullable(clazz.cast(numCacheNodes()));
        case "CacheNodeType":
            return Optional.ofNullable(clazz.cast(cacheNodeType()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "CacheParameterGroupName":
            return Optional.ofNullable(clazz.cast(cacheParameterGroupName()));
        case "CacheSubnetGroupName":
            return Optional.ofNullable(clazz.cast(cacheSubnetGroupName()));
        case "CacheSecurityGroupNames":
            return Optional.ofNullable(clazz.cast(cacheSecurityGroupNames()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "SnapshotArns":
            return Optional.ofNullable(clazz.cast(snapshotArns()));
        case "SnapshotName":
            return Optional.ofNullable(clazz.cast(snapshotName()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "NotificationTopicArn":
            return Optional.ofNullable(clazz.cast(notificationTopicArn()));
        case "AutoMinorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(autoMinorVersionUpgrade()));
        case "SnapshotRetentionLimit":
            return Optional.ofNullable(clazz.cast(snapshotRetentionLimit()));
        case "SnapshotWindow":
            return Optional.ofNullable(clazz.cast(snapshotWindow()));
        case "AuthToken":
            return Optional.ofNullable(clazz.cast(authToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCacheClusterRequest, T> g) {
        return obj -> g.apply((CreateCacheClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateCacheClusterRequest> {
        /**
         * <p>
         * The node group (shard) identifier. This parameter is stored as a lowercase string.
         * </p>
         * <p>
         * <b>Constraints:</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * A name must contain from 1 to 50 alphanumeric characters or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * The first character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * A name cannot end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * </ul>
         * 
         * @param cacheClusterId
         *        The node group (shard) identifier. This parameter is stored as a lowercase string.</p>
         *        <p>
         *        <b>Constraints:</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A name must contain from 1 to 50 alphanumeric characters or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The first character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A name cannot end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheClusterId(String cacheClusterId);

        /**
         * <p>
         * The ID of the replication group to which this cluster should belong. If this parameter is specified, the
         * cluster is added to the specified replication group as a read replica; otherwise, the cluster is a standalone
         * primary that is not part of any replication group.
         * </p>
         * <p>
         * If the specified replication group is Multi-AZ enabled and the Availability Zone is not specified, the
         * cluster is created in Availability Zones that provide the best spread of read replicas across Availability
         * Zones.
         * </p>
         * <note>
         * <p>
         * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
         * </p>
         * </note>
         * 
         * @param replicationGroupId
         *        The ID of the replication group to which this cluster should belong. If this parameter is specified,
         *        the cluster is added to the specified replication group as a read replica; otherwise, the cluster is a
         *        standalone primary that is not part of any replication group.</p>
         *        <p>
         *        If the specified replication group is Multi-AZ enabled and the Availability Zone is not specified, the
         *        cluster is created in Availability Zones that provide the best spread of read replicas across
         *        Availability Zones.
         *        </p>
         *        <note>
         *        <p>
         *        This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroupId(String replicationGroupId);

        /**
         * <p>
         * Specifies whether the nodes in this Memcached cluster are created in a single Availability Zone or created
         * across multiple Availability Zones in the cluster's region.
         * </p>
         * <p>
         * This parameter is only supported for Memcached clusters.
         * </p>
         * <p>
         * If the <code>AZMode</code> and <code>PreferredAvailabilityZones</code> are not specified, ElastiCache assumes
         * <code>single-az</code> mode.
         * </p>
         * 
         * @param azMode
         *        Specifies whether the nodes in this Memcached cluster are created in a single Availability Zone or
         *        created across multiple Availability Zones in the cluster's region.</p>
         *        <p>
         *        This parameter is only supported for Memcached clusters.
         *        </p>
         *        <p>
         *        If the <code>AZMode</code> and <code>PreferredAvailabilityZones</code> are not specified, ElastiCache
         *        assumes <code>single-az</code> mode.
         * @see AZMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AZMode
         */
        Builder azMode(String azMode);

        /**
         * <p>
         * Specifies whether the nodes in this Memcached cluster are created in a single Availability Zone or created
         * across multiple Availability Zones in the cluster's region.
         * </p>
         * <p>
         * This parameter is only supported for Memcached clusters.
         * </p>
         * <p>
         * If the <code>AZMode</code> and <code>PreferredAvailabilityZones</code> are not specified, ElastiCache assumes
         * <code>single-az</code> mode.
         * </p>
         * 
         * @param azMode
         *        Specifies whether the nodes in this Memcached cluster are created in a single Availability Zone or
         *        created across multiple Availability Zones in the cluster's region.</p>
         *        <p>
         *        This parameter is only supported for Memcached clusters.
         *        </p>
         *        <p>
         *        If the <code>AZMode</code> and <code>PreferredAvailabilityZones</code> are not specified, ElastiCache
         *        assumes <code>single-az</code> mode.
         * @see AZMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AZMode
         */
        Builder azMode(AZMode azMode);

        /**
         * <p>
         * The EC2 Availability Zone in which the cluster is created.
         * </p>
         * <p>
         * All nodes belonging to this Memcached cluster are placed in the preferred Availability Zone. If you want to
         * create your nodes across multiple Availability Zones, use <code>PreferredAvailabilityZones</code>.
         * </p>
         * <p>
         * Default: System chosen Availability Zone.
         * </p>
         * 
         * @param preferredAvailabilityZone
         *        The EC2 Availability Zone in which the cluster is created.</p>
         *        <p>
         *        All nodes belonging to this Memcached cluster are placed in the preferred Availability Zone. If you
         *        want to create your nodes across multiple Availability Zones, use
         *        <code>PreferredAvailabilityZones</code>.
         *        </p>
         *        <p>
         *        Default: System chosen Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredAvailabilityZone(String preferredAvailabilityZone);

        /**
         * <p>
         * A list of the Availability Zones in which cache nodes are created. The order of the zones in the list is not
         * important.
         * </p>
         * <p>
         * This option is only supported on Memcached.
         * </p>
         * <note>
         * <p>
         * If you are creating your cluster in an Amazon VPC (recommended) you can only locate nodes in Availability
         * Zones that are associated with the subnets in the selected subnet group.
         * </p>
         * <p>
         * The number of Availability Zones listed must equal the value of <code>NumCacheNodes</code>.
         * </p>
         * </note>
         * <p>
         * If you want all the nodes in the same Availability Zone, use <code>PreferredAvailabilityZone</code> instead,
         * or repeat the Availability Zone multiple times in the list.
         * </p>
         * <p>
         * Default: System chosen Availability Zones.
         * </p>
         * 
         * @param preferredAvailabilityZones
         *        A list of the Availability Zones in which cache nodes are created. The order of the zones in the list
         *        is not important.</p>
         *        <p>
         *        This option is only supported on Memcached.
         *        </p>
         *        <note>
         *        <p>
         *        If you are creating your cluster in an Amazon VPC (recommended) you can only locate nodes in
         *        Availability Zones that are associated with the subnets in the selected subnet group.
         *        </p>
         *        <p>
         *        The number of Availability Zones listed must equal the value of <code>NumCacheNodes</code>.
         *        </p>
         *        </note>
         *        <p>
         *        If you want all the nodes in the same Availability Zone, use <code>PreferredAvailabilityZone</code>
         *        instead, or repeat the Availability Zone multiple times in the list.
         *        </p>
         *        <p>
         *        Default: System chosen Availability Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredAvailabilityZones(Collection<String> preferredAvailabilityZones);

        /**
         * <p>
         * A list of the Availability Zones in which cache nodes are created. The order of the zones in the list is not
         * important.
         * </p>
         * <p>
         * This option is only supported on Memcached.
         * </p>
         * <note>
         * <p>
         * If you are creating your cluster in an Amazon VPC (recommended) you can only locate nodes in Availability
         * Zones that are associated with the subnets in the selected subnet group.
         * </p>
         * <p>
         * The number of Availability Zones listed must equal the value of <code>NumCacheNodes</code>.
         * </p>
         * </note>
         * <p>
         * If you want all the nodes in the same Availability Zone, use <code>PreferredAvailabilityZone</code> instead,
         * or repeat the Availability Zone multiple times in the list.
         * </p>
         * <p>
         * Default: System chosen Availability Zones.
         * </p>
         * 
         * @param preferredAvailabilityZones
         *        A list of the Availability Zones in which cache nodes are created. The order of the zones in the list
         *        is not important.</p>
         *        <p>
         *        This option is only supported on Memcached.
         *        </p>
         *        <note>
         *        <p>
         *        If you are creating your cluster in an Amazon VPC (recommended) you can only locate nodes in
         *        Availability Zones that are associated with the subnets in the selected subnet group.
         *        </p>
         *        <p>
         *        The number of Availability Zones listed must equal the value of <code>NumCacheNodes</code>.
         *        </p>
         *        </note>
         *        <p>
         *        If you want all the nodes in the same Availability Zone, use <code>PreferredAvailabilityZone</code>
         *        instead, or repeat the Availability Zone multiple times in the list.
         *        </p>
         *        <p>
         *        Default: System chosen Availability Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredAvailabilityZones(String... preferredAvailabilityZones);

        /**
         * <p>
         * The initial number of cache nodes that the cluster has.
         * </p>
         * <p>
         * For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be between
         * 1 and 20.
         * </p>
         * <p>
         * If you need more than 20 nodes for your Memcached cluster, please fill out the ElastiCache Limit Increase
         * Request form at <a
         * href="http://aws.amazon.com/contact-us/elasticache-node-limit-request/">http://aws.amazon.com
         * /contact-us/elasticache-node-limit-request/</a>.
         * </p>
         * 
         * @param numCacheNodes
         *        The initial number of cache nodes that the cluster has.</p>
         *        <p>
         *        For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be
         *        between 1 and 20.
         *        </p>
         *        <p>
         *        If you need more than 20 nodes for your Memcached cluster, please fill out the ElastiCache Limit
         *        Increase Request form at <a
         *        href="http://aws.amazon.com/contact-us/elasticache-node-limit-request/">http
         *        ://aws.amazon.com/contact-us/elasticache-node-limit-request/</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numCacheNodes(Integer numCacheNodes);

        /**
         * <p>
         * The compute and memory capacity of the nodes in the node group (shard).
         * </p>
         * <p>
         * The following node types are supported by ElastiCache. Generally speaking, the current generation types
         * provide more memory and computational power at lower cost when compared to their equivalent previous
         * generation counterparts.
         * </p>
         * <ul>
         * <li>
         * <p>
         * General purpose:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Current generation:
         * </p>
         * <p>
         * <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>,
         * <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>,
         * <code>cache.m5.24xlarge</code>
         * </p>
         * <p>
         * <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>,
         * <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code>
         * </p>
         * <p>
         * <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Previous generation: (not recommended)
         * </p>
         * <p>
         * <b>T1 node types:</b> <code>cache.t1.micro</code>
         * </p>
         * <p>
         * <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>,
         * <code>cache.m1.xlarge</code>
         * </p>
         * <p>
         * <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Compute optimized:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Previous generation: (not recommended)
         * </p>
         * <p>
         * <b>C1 node types:</b> <code>cache.c1.xlarge</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Memory optimized:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Current generation:
         * </p>
         * <p>
         * <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>,
         * <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>,
         * <code>cache.r5.24xlarge</code>
         * </p>
         * <p>
         * <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>,
         * <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>,
         * <code>cache.r4.16xlarge</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Previous generation: (not recommended)
         * </p>
         * <p>
         * <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>,
         * <code>cache.m2.4xlarge</code>
         * </p>
         * <p>
         * <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>,
         * <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <p>
         * <b>Additional node type info</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * All current generation instance types are created in Amazon VPC by default.
         * </p>
         * </li>
         * <li>
         * <p>
         * Redis append-only files (AOF) are not supported for T1 or T2 instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * Redis Multi-AZ with automatic failover is not supported on T1 instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis
         * version 2.8.22 and later.
         * </p>
         * </li>
         * </ul>
         * 
         * @param cacheNodeType
         *        The compute and memory capacity of the nodes in the node group (shard).</p>
         *        <p>
         *        The following node types are supported by ElastiCache. Generally speaking, the current generation
         *        types provide more memory and computational power at lower cost when compared to their equivalent
         *        previous generation counterparts.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        General purpose:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Current generation:
         *        </p>
         *        <p>
         *        <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>,
         *        <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>,
         *        <code>cache.m5.24xlarge</code>
         *        </p>
         *        <p>
         *        <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>,
         *        <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code>
         *        </p>
         *        <p>
         *        <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>,
         *        <code>cache.t2.medium</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Previous generation: (not recommended)
         *        </p>
         *        <p>
         *        <b>T1 node types:</b> <code>cache.t1.micro</code>
         *        </p>
         *        <p>
         *        <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>,
         *        <code>cache.m1.large</code>, <code>cache.m1.xlarge</code>
         *        </p>
         *        <p>
         *        <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>,
         *        <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Compute optimized:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Previous generation: (not recommended)
         *        </p>
         *        <p>
         *        <b>C1 node types:</b> <code>cache.c1.xlarge</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Memory optimized:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Current generation:
         *        </p>
         *        <p>
         *        <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>,
         *        <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>,
         *        <code>cache.r5.24xlarge</code>
         *        </p>
         *        <p>
         *        <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>,
         *        <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>,
         *        <code>cache.r4.16xlarge</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Previous generation: (not recommended)
         *        </p>
         *        <p>
         *        <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>,
         *        <code>cache.m2.4xlarge</code>
         *        </p>
         *        <p>
         *        <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>,
         *        <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Additional node type info</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        All current generation instance types are created in Amazon VPC by default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Redis append-only files (AOF) are not supported for T1 or T2 instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Redis Multi-AZ with automatic failover is not supported on T1 instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported
         *        on Redis version 2.8.22 and later.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheNodeType(String cacheNodeType);

        /**
         * <p>
         * The name of the cache engine to be used for this cluster.
         * </p>
         * <p>
         * Valid values for this parameter are: <code>memcached</code> | <code>redis</code>
         * </p>
         * 
         * @param engine
         *        The name of the cache engine to be used for this cluster.</p>
         *        <p>
         *        Valid values for this parameter are: <code>memcached</code> | <code>redis</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The version number of the cache engine to be used for this cluster. To view the supported cache engine
         * versions, use the DescribeCacheEngineVersions operation.
         * </p>
         * <p>
         * <b>Important:</b> You can upgrade to a newer engine version (see <a
         * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement"
         * >Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you
         * want to use an earlier engine version, you must delete the existing cluster or replication group and create
         * it anew with the earlier engine version.
         * </p>
         * 
         * @param engineVersion
         *        The version number of the cache engine to be used for this cluster. To view the supported cache engine
         *        versions, use the DescribeCacheEngineVersions operation.</p>
         *        <p>
         *        <b>Important:</b> You can upgrade to a newer engine version (see <a href=
         *        "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement"
         *        >Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If
         *        you want to use an earlier engine version, you must delete the existing cluster or replication group
         *        and create it anew with the earlier engine version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The name of the parameter group to associate with this cluster. If this argument is omitted, the default
         * parameter group for the specified engine is used. You cannot use any parameter group which has
         * <code>cluster-enabled='yes'</code> when creating a cluster.
         * </p>
         * 
         * @param cacheParameterGroupName
         *        The name of the parameter group to associate with this cluster. If this argument is omitted, the
         *        default parameter group for the specified engine is used. You cannot use any parameter group which has
         *        <code>cluster-enabled='yes'</code> when creating a cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheParameterGroupName(String cacheParameterGroupName);

        /**
         * <p>
         * The name of the subnet group to be used for the cluster.
         * </p>
         * <p>
         * Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).
         * </p>
         * <important>
         * <p>
         * If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start
         * creating a cluster. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html">Subnets and Subnet
         * Groups</a>.
         * </p>
         * </important>
         * 
         * @param cacheSubnetGroupName
         *        The name of the subnet group to be used for the cluster.</p>
         *        <p>
         *        Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon
         *        VPC).
         *        </p>
         *        <important>
         *        <p>
         *        If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you
         *        start creating a cluster. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html">Subnets and
         *        Subnet Groups</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheSubnetGroupName(String cacheSubnetGroupName);

        /**
         * <p>
         * A list of security group names to associate with this cluster.
         * </p>
         * <p>
         * Use this parameter only when you are creating a cluster outside of an Amazon Virtual Private Cloud (Amazon
         * VPC).
         * </p>
         * 
         * @param cacheSecurityGroupNames
         *        A list of security group names to associate with this cluster.</p>
         *        <p>
         *        Use this parameter only when you are creating a cluster outside of an Amazon Virtual Private Cloud
         *        (Amazon VPC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames);

        /**
         * <p>
         * A list of security group names to associate with this cluster.
         * </p>
         * <p>
         * Use this parameter only when you are creating a cluster outside of an Amazon Virtual Private Cloud (Amazon
         * VPC).
         * </p>
         * 
         * @param cacheSecurityGroupNames
         *        A list of security group names to associate with this cluster.</p>
         *        <p>
         *        Use this parameter only when you are creating a cluster outside of an Amazon Virtual Private Cloud
         *        (Amazon VPC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheSecurityGroupNames(String... cacheSecurityGroupNames);

        /**
         * <p>
         * One or more VPC security groups associated with the cluster.
         * </p>
         * <p>
         * Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).
         * </p>
         * 
         * @param securityGroupIds
         *        One or more VPC security groups associated with the cluster.</p>
         *        <p>
         *        Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon
         *        VPC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * One or more VPC security groups associated with the cluster.
         * </p>
         * <p>
         * Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).
         * </p>
         * 
         * @param securityGroupIds
         *        One or more VPC security groups associated with the cluster.</p>
         *        <p>
         *        Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon
         *        VPC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * A list of cost allocation tags to be added to this resource.
         * </p>
         * 
         * @param tags
         *        A list of cost allocation tags to be added to this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of cost allocation tags to be added to this resource.
         * </p>
         * 
         * @param tags
         *        A list of cost allocation tags to be added to this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of cost allocation tags to be added to this resource.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * A single-element string list containing an Amazon Resource Name (ARN) that uniquely identifies a Redis RDB
         * snapshot file stored in Amazon S3. The snapshot file is used to populate the node group (shard). The Amazon
         * S3 object name in the ARN cannot contain any commas.
         * </p>
         * <note>
         * <p>
         * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
         * </p>
         * </note>
         * <p>
         * Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
         * </p>
         * 
         * @param snapshotArns
         *        A single-element string list containing an Amazon Resource Name (ARN) that uniquely identifies a Redis
         *        RDB snapshot file stored in Amazon S3. The snapshot file is used to populate the node group (shard).
         *        The Amazon S3 object name in the ARN cannot contain any commas.</p> <note>
         *        <p>
         *        This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
         *        </p>
         *        </note>
         *        <p>
         *        Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotArns(Collection<String> snapshotArns);

        /**
         * <p>
         * A single-element string list containing an Amazon Resource Name (ARN) that uniquely identifies a Redis RDB
         * snapshot file stored in Amazon S3. The snapshot file is used to populate the node group (shard). The Amazon
         * S3 object name in the ARN cannot contain any commas.
         * </p>
         * <note>
         * <p>
         * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
         * </p>
         * </note>
         * <p>
         * Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
         * </p>
         * 
         * @param snapshotArns
         *        A single-element string list containing an Amazon Resource Name (ARN) that uniquely identifies a Redis
         *        RDB snapshot file stored in Amazon S3. The snapshot file is used to populate the node group (shard).
         *        The Amazon S3 object name in the ARN cannot contain any commas.</p> <note>
         *        <p>
         *        This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
         *        </p>
         *        </note>
         *        <p>
         *        Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotArns(String... snapshotArns);

        /**
         * <p>
         * The name of a Redis snapshot from which to restore data into the new node group (shard). The snapshot status
         * changes to <code>restoring</code> while the new node group (shard) is being created.
         * </p>
         * <note>
         * <p>
         * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
         * </p>
         * </note>
         * 
         * @param snapshotName
         *        The name of a Redis snapshot from which to restore data into the new node group (shard). The snapshot
         *        status changes to <code>restoring</code> while the new node group (shard) is being created.</p> <note>
         *        <p>
         *        This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotName(String snapshotName);

        /**
         * <p>
         * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a
         * range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute
         * period. Valid values for <code>ddd</code> are:
         * </p>
         * <p>
         * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a
         * range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute
         * period.
         * </p>
         * <p>
         * Valid values for <code>ddd</code> are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>sun</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>mon</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tue</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>wed</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>thu</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fri</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sat</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>sun:23:00-mon:01:30</code>
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        Specifies the weekly time range during which maintenance on the cluster is performed. It is specified
         *        as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a
         *        60 minute period. Valid values for <code>ddd</code> are:</p>
         *        <p>
         *        Specifies the weekly time range during which maintenance on the cluster is performed. It is specified
         *        as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a
         *        60 minute period.
         *        </p>
         *        <p>
         *        Valid values for <code>ddd</code> are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>sun</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>mon</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tue</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>wed</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>thu</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fri</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sat</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>sun:23:00-mon:01:30</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * The port number on which each of the cache nodes accepts connections.
         * </p>
         * 
         * @param port
         *        The port number on which each of the cache nodes accepts connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications
         * are sent.
         * </p>
         * <note>
         * <p>
         * The Amazon SNS topic owner must be the same as the cluster owner.
         * </p>
         * </note>
         * 
         * @param notificationTopicArn
         *        The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which
         *        notifications are sent.</p> <note>
         *        <p>
         *        The Amazon SNS topic owner must be the same as the cluster owner.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationTopicArn(String notificationTopicArn);

        /**
         * <p>
         * This parameter is currently disabled.
         * </p>
         * 
         * @param autoMinorVersionUpgrade
         *        This parameter is currently disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade);

        /**
         * <p>
         * The number of days for which ElastiCache retains automatic snapshots before deleting them. For example, if
         * you set <code>SnapshotRetentionLimit</code> to 5, a snapshot taken today is retained for 5 days before being
         * deleted.
         * </p>
         * <note>
         * <p>
         * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
         * </p>
         * </note>
         * <p>
         * Default: 0 (i.e., automatic backups are disabled for this cache cluster).
         * </p>
         * 
         * @param snapshotRetentionLimit
         *        The number of days for which ElastiCache retains automatic snapshots before deleting them. For
         *        example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot taken today is retained for 5
         *        days before being deleted.</p> <note>
         *        <p>
         *        This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
         *        </p>
         *        </note>
         *        <p>
         *        Default: 0 (i.e., automatic backups are disabled for this cache cluster).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotRetentionLimit(Integer snapshotRetentionLimit);

        /**
         * <p>
         * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group
         * (shard).
         * </p>
         * <p>
         * Example: <code>05:00-09:00</code>
         * </p>
         * <p>
         * If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
         * </p>
         * <note>
         * <p>
         * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
         * </p>
         * </note>
         * 
         * @param snapshotWindow
         *        The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node
         *        group (shard).</p>
         *        <p>
         *        Example: <code>05:00-09:00</code>
         *        </p>
         *        <p>
         *        If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
         *        </p>
         *        <note>
         *        <p>
         *        This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotWindow(String snapshotWindow);

        /**
         * <p>
         * <b>Reserved parameter.</b> The password used to access a password protected server.
         * </p>
         * <p>
         * Password constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be only printable ASCII characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be at least 16 characters and no more than 128 characters in length.
         * </p>
         * </li>
         * <li>
         * <p>
         * The only permitted printable special characters are !, &amp;, #, $, ^, &lt;, &gt;, and -. Other printable
         * special characters cannot be used in the AUTH token.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a href="http://redis.io/commands/AUTH">AUTH password</a> at
         * http://redis.io/commands/AUTH.
         * </p>
         * 
         * @param authToken
         *        <b>Reserved parameter.</b> The password used to access a password protected server.</p>
         *        <p>
         *        Password constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be only printable ASCII characters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be at least 16 characters and no more than 128 characters in length.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The only permitted printable special characters are !, &amp;, #, $, ^, &lt;, &gt;, and -. Other
         *        printable special characters cannot be used in the AUTH token.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href="http://redis.io/commands/AUTH">AUTH password</a> at
         *        http://redis.io/commands/AUTH.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authToken(String authToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String cacheClusterId;

        private String replicationGroupId;

        private String azMode;

        private String preferredAvailabilityZone;

        private List<String> preferredAvailabilityZones = DefaultSdkAutoConstructList.getInstance();

        private Integer numCacheNodes;

        private String cacheNodeType;

        private String engine;

        private String engineVersion;

        private String cacheParameterGroupName;

        private String cacheSubnetGroupName;

        private List<String> cacheSecurityGroupNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private List<String> snapshotArns = DefaultSdkAutoConstructList.getInstance();

        private String snapshotName;

        private String preferredMaintenanceWindow;

        private Integer port;

        private String notificationTopicArn;

        private Boolean autoMinorVersionUpgrade;

        private Integer snapshotRetentionLimit;

        private String snapshotWindow;

        private String authToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCacheClusterRequest model) {
            super(model);
            cacheClusterId(model.cacheClusterId);
            replicationGroupId(model.replicationGroupId);
            azMode(model.azMode);
            preferredAvailabilityZone(model.preferredAvailabilityZone);
            preferredAvailabilityZones(model.preferredAvailabilityZones);
            numCacheNodes(model.numCacheNodes);
            cacheNodeType(model.cacheNodeType);
            engine(model.engine);
            engineVersion(model.engineVersion);
            cacheParameterGroupName(model.cacheParameterGroupName);
            cacheSubnetGroupName(model.cacheSubnetGroupName);
            cacheSecurityGroupNames(model.cacheSecurityGroupNames);
            securityGroupIds(model.securityGroupIds);
            tags(model.tags);
            snapshotArns(model.snapshotArns);
            snapshotName(model.snapshotName);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            port(model.port);
            notificationTopicArn(model.notificationTopicArn);
            autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            snapshotRetentionLimit(model.snapshotRetentionLimit);
            snapshotWindow(model.snapshotWindow);
            authToken(model.authToken);
        }

        public final String getCacheClusterId() {
            return cacheClusterId;
        }

        @Override
        public final Builder cacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
            return this;
        }

        public final void setCacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
        }

        public final String getReplicationGroupId() {
            return replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        public final String getAzModeAsString() {
            return azMode;
        }

        @Override
        public final Builder azMode(String azMode) {
            this.azMode = azMode;
            return this;
        }

        @Override
        public final Builder azMode(AZMode azMode) {
            this.azMode(azMode == null ? null : azMode.toString());
            return this;
        }

        public final void setAzMode(String azMode) {
            this.azMode = azMode;
        }

        public final String getPreferredAvailabilityZone() {
            return preferredAvailabilityZone;
        }

        @Override
        public final Builder preferredAvailabilityZone(String preferredAvailabilityZone) {
            this.preferredAvailabilityZone = preferredAvailabilityZone;
            return this;
        }

        public final void setPreferredAvailabilityZone(String preferredAvailabilityZone) {
            this.preferredAvailabilityZone = preferredAvailabilityZone;
        }

        public final Collection<String> getPreferredAvailabilityZones() {
            return preferredAvailabilityZones;
        }

        @Override
        public final Builder preferredAvailabilityZones(Collection<String> preferredAvailabilityZones) {
            this.preferredAvailabilityZones = PreferredAvailabilityZoneListCopier.copy(preferredAvailabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preferredAvailabilityZones(String... preferredAvailabilityZones) {
            preferredAvailabilityZones(Arrays.asList(preferredAvailabilityZones));
            return this;
        }

        public final void setPreferredAvailabilityZones(Collection<String> preferredAvailabilityZones) {
            this.preferredAvailabilityZones = PreferredAvailabilityZoneListCopier.copy(preferredAvailabilityZones);
        }

        public final Integer getNumCacheNodes() {
            return numCacheNodes;
        }

        @Override
        public final Builder numCacheNodes(Integer numCacheNodes) {
            this.numCacheNodes = numCacheNodes;
            return this;
        }

        public final void setNumCacheNodes(Integer numCacheNodes) {
            this.numCacheNodes = numCacheNodes;
        }

        public final String getCacheNodeType() {
            return cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        public final String getEngine() {
            return engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getCacheParameterGroupName() {
            return cacheParameterGroupName;
        }

        @Override
        public final Builder cacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
            return this;
        }

        public final void setCacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
        }

        public final String getCacheSubnetGroupName() {
            return cacheSubnetGroupName;
        }

        @Override
        public final Builder cacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
            return this;
        }

        public final void setCacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
        }

        public final Collection<String> getCacheSecurityGroupNames() {
            return cacheSecurityGroupNames;
        }

        @Override
        public final Builder cacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames = CacheSecurityGroupNameListCopier.copy(cacheSecurityGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheSecurityGroupNames(String... cacheSecurityGroupNames) {
            cacheSecurityGroupNames(Arrays.asList(cacheSecurityGroupNames));
            return this;
        }

        public final void setCacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames = CacheSecurityGroupNameListCopier.copy(cacheSecurityGroupNames);
        }

        public final Collection<String> getSecurityGroupIds() {
            return securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Collection<String> getSnapshotArns() {
            return snapshotArns;
        }

        @Override
        public final Builder snapshotArns(Collection<String> snapshotArns) {
            this.snapshotArns = SnapshotArnsListCopier.copy(snapshotArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotArns(String... snapshotArns) {
            snapshotArns(Arrays.asList(snapshotArns));
            return this;
        }

        public final void setSnapshotArns(Collection<String> snapshotArns) {
            this.snapshotArns = SnapshotArnsListCopier.copy(snapshotArns);
        }

        public final String getSnapshotName() {
            return snapshotName;
        }

        @Override
        public final Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public final void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final Integer getPort() {
            return port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getNotificationTopicArn() {
            return notificationTopicArn;
        }

        @Override
        public final Builder notificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
            return this;
        }

        public final void setNotificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        public final Integer getSnapshotRetentionLimit() {
            return snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        public final String getSnapshotWindow() {
            return snapshotWindow;
        }

        @Override
        public final Builder snapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
            return this;
        }

        public final void setSnapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
        }

        public final String getAuthToken() {
            return authToken;
        }

        @Override
        public final Builder authToken(String authToken) {
            this.authToken = authToken;
            return this;
        }

        public final void setAuthToken(String authToken) {
            this.authToken = authToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCacheClusterRequest build() {
            return new CreateCacheClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
