/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides all of the details about a particular cache engine version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CacheEngineVersion implements SdkPojo, Serializable,
        ToCopyableBuilder<CacheEngineVersion.Builder, CacheEngineVersion> {
    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CacheEngineVersion::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CacheEngineVersion::engineVersion)).setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<String> CACHE_PARAMETER_GROUP_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CacheEngineVersion::cacheParameterGroupFamily)).setter(setter(Builder::cacheParameterGroupFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheParameterGroupFamily").build())
            .build();

    private static final SdkField<String> CACHE_ENGINE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CacheEngineVersion::cacheEngineDescription)).setter(setter(Builder::cacheEngineDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheEngineDescription").build())
            .build();

    private static final SdkField<String> CACHE_ENGINE_VERSION_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CacheEngineVersion::cacheEngineVersionDescription))
            .setter(setter(Builder::cacheEngineVersionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheEngineVersionDescription")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_FIELD,
            ENGINE_VERSION_FIELD, CACHE_PARAMETER_GROUP_FAMILY_FIELD, CACHE_ENGINE_DESCRIPTION_FIELD,
            CACHE_ENGINE_VERSION_DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String engine;

    private final String engineVersion;

    private final String cacheParameterGroupFamily;

    private final String cacheEngineDescription;

    private final String cacheEngineVersionDescription;

    private CacheEngineVersion(BuilderImpl builder) {
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.cacheParameterGroupFamily = builder.cacheParameterGroupFamily;
        this.cacheEngineDescription = builder.cacheEngineDescription;
        this.cacheEngineVersionDescription = builder.cacheEngineVersionDescription;
    }

    /**
     * <p>
     * The name of the cache engine.
     * </p>
     * 
     * @return The name of the cache engine.
     */
    public String engine() {
        return engine;
    }

    /**
     * <p>
     * The version number of the cache engine.
     * </p>
     * 
     * @return The version number of the cache engine.
     */
    public String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The name of the cache parameter group family associated with this cache engine.
     * </p>
     * <p>
     * Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>redis2.6</code> |
     * <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> | <code>redis5.0</code> |
     * </p>
     * 
     * @return The name of the cache parameter group family associated with this cache engine.</p>
     *         <p>
     *         Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>redis2.6</code> |
     *         <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> | <code>redis5.0</code> |
     */
    public String cacheParameterGroupFamily() {
        return cacheParameterGroupFamily;
    }

    /**
     * <p>
     * The description of the cache engine.
     * </p>
     * 
     * @return The description of the cache engine.
     */
    public String cacheEngineDescription() {
        return cacheEngineDescription;
    }

    /**
     * <p>
     * The description of the cache engine version.
     * </p>
     * 
     * @return The description of the cache engine version.
     */
    public String cacheEngineVersionDescription() {
        return cacheEngineVersionDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(cacheParameterGroupFamily());
        hashCode = 31 * hashCode + Objects.hashCode(cacheEngineDescription());
        hashCode = 31 * hashCode + Objects.hashCode(cacheEngineVersionDescription());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheEngineVersion)) {
            return false;
        }
        CacheEngineVersion other = (CacheEngineVersion) obj;
        return Objects.equals(engine(), other.engine()) && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(cacheParameterGroupFamily(), other.cacheParameterGroupFamily())
                && Objects.equals(cacheEngineDescription(), other.cacheEngineDescription())
                && Objects.equals(cacheEngineVersionDescription(), other.cacheEngineVersionDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CacheEngineVersion").add("Engine", engine()).add("EngineVersion", engineVersion())
                .add("CacheParameterGroupFamily", cacheParameterGroupFamily())
                .add("CacheEngineDescription", cacheEngineDescription())
                .add("CacheEngineVersionDescription", cacheEngineVersionDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "CacheParameterGroupFamily":
            return Optional.ofNullable(clazz.cast(cacheParameterGroupFamily()));
        case "CacheEngineDescription":
            return Optional.ofNullable(clazz.cast(cacheEngineDescription()));
        case "CacheEngineVersionDescription":
            return Optional.ofNullable(clazz.cast(cacheEngineVersionDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CacheEngineVersion, T> g) {
        return obj -> g.apply((CacheEngineVersion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CacheEngineVersion> {
        /**
         * <p>
         * The name of the cache engine.
         * </p>
         * 
         * @param engine
         *        The name of the cache engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The version number of the cache engine.
         * </p>
         * 
         * @param engineVersion
         *        The version number of the cache engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The name of the cache parameter group family associated with this cache engine.
         * </p>
         * <p>
         * Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>redis2.6</code> |
         * <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> | <code>redis5.0</code> |
         * </p>
         * 
         * @param cacheParameterGroupFamily
         *        The name of the cache parameter group family associated with this cache engine.</p>
         *        <p>
         *        Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>redis2.6</code> |
         *        <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> | <code>redis5.0</code> |
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheParameterGroupFamily(String cacheParameterGroupFamily);

        /**
         * <p>
         * The description of the cache engine.
         * </p>
         * 
         * @param cacheEngineDescription
         *        The description of the cache engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheEngineDescription(String cacheEngineDescription);

        /**
         * <p>
         * The description of the cache engine version.
         * </p>
         * 
         * @param cacheEngineVersionDescription
         *        The description of the cache engine version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheEngineVersionDescription(String cacheEngineVersionDescription);
    }

    static final class BuilderImpl implements Builder {
        private String engine;

        private String engineVersion;

        private String cacheParameterGroupFamily;

        private String cacheEngineDescription;

        private String cacheEngineVersionDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(CacheEngineVersion model) {
            engine(model.engine);
            engineVersion(model.engineVersion);
            cacheParameterGroupFamily(model.cacheParameterGroupFamily);
            cacheEngineDescription(model.cacheEngineDescription);
            cacheEngineVersionDescription(model.cacheEngineVersionDescription);
        }

        public final String getEngine() {
            return engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getCacheParameterGroupFamily() {
            return cacheParameterGroupFamily;
        }

        @Override
        public final Builder cacheParameterGroupFamily(String cacheParameterGroupFamily) {
            this.cacheParameterGroupFamily = cacheParameterGroupFamily;
            return this;
        }

        public final void setCacheParameterGroupFamily(String cacheParameterGroupFamily) {
            this.cacheParameterGroupFamily = cacheParameterGroupFamily;
        }

        public final String getCacheEngineDescription() {
            return cacheEngineDescription;
        }

        @Override
        public final Builder cacheEngineDescription(String cacheEngineDescription) {
            this.cacheEngineDescription = cacheEngineDescription;
            return this;
        }

        public final void setCacheEngineDescription(String cacheEngineDescription) {
            this.cacheEngineDescription = cacheEngineDescription;
        }

        public final String getCacheEngineVersionDescription() {
            return cacheEngineVersionDescription;
        }

        @Override
        public final Builder cacheEngineVersionDescription(String cacheEngineVersionDescription) {
            this.cacheEngineVersionDescription = cacheEngineVersionDescription;
            return this;
        }

        public final void setCacheEngineVersionDescription(String cacheEngineVersionDescription) {
            this.cacheEngineVersionDescription = cacheEngineVersionDescription;
        }

        @Override
        public CacheEngineVersion build() {
            return new CacheEngineVersion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
