/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of an AuthorizeCacheSecurityGroupIngress operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthorizeCacheSecurityGroupIngressRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<AuthorizeCacheSecurityGroupIngressRequest.Builder, AuthorizeCacheSecurityGroupIngressRequest> {
    private static final SdkField<String> CACHE_SECURITY_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AuthorizeCacheSecurityGroupIngressRequest::cacheSecurityGroupName))
            .setter(setter(Builder::cacheSecurityGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSecurityGroupName").build())
            .build();

    private static final SdkField<String> EC2_SECURITY_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AuthorizeCacheSecurityGroupIngressRequest::ec2SecurityGroupName))
            .setter(setter(Builder::ec2SecurityGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2SecurityGroupName").build())
            .build();

    private static final SdkField<String> EC2_SECURITY_GROUP_OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AuthorizeCacheSecurityGroupIngressRequest::ec2SecurityGroupOwnerId))
            .setter(setter(Builder::ec2SecurityGroupOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2SecurityGroupOwnerId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CACHE_SECURITY_GROUP_NAME_FIELD, EC2_SECURITY_GROUP_NAME_FIELD, EC2_SECURITY_GROUP_OWNER_ID_FIELD));

    private final String cacheSecurityGroupName;

    private final String ec2SecurityGroupName;

    private final String ec2SecurityGroupOwnerId;

    private AuthorizeCacheSecurityGroupIngressRequest(BuilderImpl builder) {
        super(builder);
        this.cacheSecurityGroupName = builder.cacheSecurityGroupName;
        this.ec2SecurityGroupName = builder.ec2SecurityGroupName;
        this.ec2SecurityGroupOwnerId = builder.ec2SecurityGroupOwnerId;
    }

    /**
     * <p>
     * The cache security group that allows network ingress.
     * </p>
     * 
     * @return The cache security group that allows network ingress.
     */
    public String cacheSecurityGroupName() {
        return cacheSecurityGroupName;
    }

    /**
     * <p>
     * The Amazon EC2 security group to be authorized for ingress to the cache security group.
     * </p>
     * 
     * @return The Amazon EC2 security group to be authorized for ingress to the cache security group.
     */
    public String ec2SecurityGroupName() {
        return ec2SecurityGroupName;
    }

    /**
     * <p>
     * The AWS account number of the Amazon EC2 security group owner. Note that this is not the same thing as an AWS
     * access key ID - you must provide a valid AWS account number for this parameter.
     * </p>
     * 
     * @return The AWS account number of the Amazon EC2 security group owner. Note that this is not the same thing as an
     *         AWS access key ID - you must provide a valid AWS account number for this parameter.
     */
    public String ec2SecurityGroupOwnerId() {
        return ec2SecurityGroupOwnerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cacheSecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(ec2SecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(ec2SecurityGroupOwnerId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizeCacheSecurityGroupIngressRequest)) {
            return false;
        }
        AuthorizeCacheSecurityGroupIngressRequest other = (AuthorizeCacheSecurityGroupIngressRequest) obj;
        return Objects.equals(cacheSecurityGroupName(), other.cacheSecurityGroupName())
                && Objects.equals(ec2SecurityGroupName(), other.ec2SecurityGroupName())
                && Objects.equals(ec2SecurityGroupOwnerId(), other.ec2SecurityGroupOwnerId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AuthorizeCacheSecurityGroupIngressRequest")
                .add("CacheSecurityGroupName", cacheSecurityGroupName()).add("EC2SecurityGroupName", ec2SecurityGroupName())
                .add("EC2SecurityGroupOwnerId", ec2SecurityGroupOwnerId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CacheSecurityGroupName":
            return Optional.ofNullable(clazz.cast(cacheSecurityGroupName()));
        case "EC2SecurityGroupName":
            return Optional.ofNullable(clazz.cast(ec2SecurityGroupName()));
        case "EC2SecurityGroupOwnerId":
            return Optional.ofNullable(clazz.cast(ec2SecurityGroupOwnerId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuthorizeCacheSecurityGroupIngressRequest, T> g) {
        return obj -> g.apply((AuthorizeCacheSecurityGroupIngressRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AuthorizeCacheSecurityGroupIngressRequest> {
        /**
         * <p>
         * The cache security group that allows network ingress.
         * </p>
         * 
         * @param cacheSecurityGroupName
         *        The cache security group that allows network ingress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheSecurityGroupName(String cacheSecurityGroupName);

        /**
         * <p>
         * The Amazon EC2 security group to be authorized for ingress to the cache security group.
         * </p>
         * 
         * @param ec2SecurityGroupName
         *        The Amazon EC2 security group to be authorized for ingress to the cache security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2SecurityGroupName(String ec2SecurityGroupName);

        /**
         * <p>
         * The AWS account number of the Amazon EC2 security group owner. Note that this is not the same thing as an AWS
         * access key ID - you must provide a valid AWS account number for this parameter.
         * </p>
         * 
         * @param ec2SecurityGroupOwnerId
         *        The AWS account number of the Amazon EC2 security group owner. Note that this is not the same thing as
         *        an AWS access key ID - you must provide a valid AWS account number for this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2SecurityGroupOwnerId(String ec2SecurityGroupOwnerId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String cacheSecurityGroupName;

        private String ec2SecurityGroupName;

        private String ec2SecurityGroupOwnerId;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizeCacheSecurityGroupIngressRequest model) {
            super(model);
            cacheSecurityGroupName(model.cacheSecurityGroupName);
            ec2SecurityGroupName(model.ec2SecurityGroupName);
            ec2SecurityGroupOwnerId(model.ec2SecurityGroupOwnerId);
        }

        public final String getCacheSecurityGroupName() {
            return cacheSecurityGroupName;
        }

        @Override
        public final Builder cacheSecurityGroupName(String cacheSecurityGroupName) {
            this.cacheSecurityGroupName = cacheSecurityGroupName;
            return this;
        }

        public final void setCacheSecurityGroupName(String cacheSecurityGroupName) {
            this.cacheSecurityGroupName = cacheSecurityGroupName;
        }

        public final String getEc2SecurityGroupName() {
            return ec2SecurityGroupName;
        }

        @Override
        public final Builder ec2SecurityGroupName(String ec2SecurityGroupName) {
            this.ec2SecurityGroupName = ec2SecurityGroupName;
            return this;
        }

        public final void setEc2SecurityGroupName(String ec2SecurityGroupName) {
            this.ec2SecurityGroupName = ec2SecurityGroupName;
        }

        public final String getEc2SecurityGroupOwnerId() {
            return ec2SecurityGroupOwnerId;
        }

        @Override
        public final Builder ec2SecurityGroupOwnerId(String ec2SecurityGroupOwnerId) {
            this.ec2SecurityGroupOwnerId = ec2SecurityGroupOwnerId;
            return this;
        }

        public final void setEc2SecurityGroupOwnerId(String ec2SecurityGroupOwnerId) {
            this.ec2SecurityGroupOwnerId = ec2SecurityGroupOwnerId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AuthorizeCacheSecurityGroupIngressRequest build() {
            return new AuthorizeCacheSecurityGroupIngressRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
