/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticache.model.TestFailoverRequest;

public class TestFailoverRequestMarshaller
implements Marshaller<Request<TestFailoverRequest>, TestFailoverRequest> {
    public Request<TestFailoverRequest> marshall(TestFailoverRequest testFailoverRequest) {
        if (testFailoverRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)testFailoverRequest, "ElastiCacheClient");
        request.addParameter("Action", "TestFailover");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (testFailoverRequest.replicationGroupId() != null) {
            request.addParameter("ReplicationGroupId", StringUtils.fromString((String)testFailoverRequest.replicationGroupId()));
        }
        if (testFailoverRequest.nodeGroupId() != null) {
            request.addParameter("NodeGroupId", StringUtils.fromString((String)testFailoverRequest.nodeGroupId()));
        }
        return request;
    }
}

