/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.elasticache.ElastiCacheAsyncClient;
import software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsResponse;
import software.amazon.awssdk.services.elasticache.model.ReservedCacheNodesOffering;

public class DescribeReservedCacheNodesOfferingsPublisher
implements SdkPublisher<DescribeReservedCacheNodesOfferingsResponse> {
    private final ElastiCacheAsyncClient client;
    private final DescribeReservedCacheNodesOfferingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeReservedCacheNodesOfferingsPublisher(ElastiCacheAsyncClient client, DescribeReservedCacheNodesOfferingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeReservedCacheNodesOfferingsPublisher(ElastiCacheAsyncClient client, DescribeReservedCacheNodesOfferingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeReservedCacheNodesOfferingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeReservedCacheNodesOfferingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<ReservedCacheNodesOffering> reservedCacheNodesOfferings() {
        Function<DescribeReservedCacheNodesOfferingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservedCacheNodesOfferings() != null) {
                return response.reservedCacheNodesOfferings().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeReservedCacheNodesOfferingsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeReservedCacheNodesOfferingsPublisher resume(DescribeReservedCacheNodesOfferingsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeReservedCacheNodesOfferingsPublisher(this.client, (DescribeReservedCacheNodesOfferingsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeReservedCacheNodesOfferingsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeReservedCacheNodesOfferingsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeReservedCacheNodesOfferingsResponseFetcher
    implements AsyncPageFetcher<DescribeReservedCacheNodesOfferingsResponse> {
        private DescribeReservedCacheNodesOfferingsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedCacheNodesOfferingsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public CompletableFuture<DescribeReservedCacheNodesOfferingsResponse> nextPage(DescribeReservedCacheNodesOfferingsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedCacheNodesOfferingsPublisher.this.client.describeReservedCacheNodesOfferings(DescribeReservedCacheNodesOfferingsPublisher.this.firstRequest);
            }
            return DescribeReservedCacheNodesOfferingsPublisher.this.client.describeReservedCacheNodesOfferings((DescribeReservedCacheNodesOfferingsRequest)((Object)DescribeReservedCacheNodesOfferingsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

