/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.elasticache.ElastiCacheAsyncClient;
import software.amazon.awssdk.services.elasticache.model.CacheSecurityGroup;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsResponse;

public class DescribeCacheSecurityGroupsPublisher
implements SdkPublisher<DescribeCacheSecurityGroupsResponse> {
    private final ElastiCacheAsyncClient client;
    private final DescribeCacheSecurityGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeCacheSecurityGroupsPublisher(ElastiCacheAsyncClient client, DescribeCacheSecurityGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeCacheSecurityGroupsPublisher(ElastiCacheAsyncClient client, DescribeCacheSecurityGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeCacheSecurityGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeCacheSecurityGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<CacheSecurityGroup> cacheSecurityGroups() {
        Function<DescribeCacheSecurityGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.cacheSecurityGroups() != null) {
                return response.cacheSecurityGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeCacheSecurityGroupsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeCacheSecurityGroupsPublisher resume(DescribeCacheSecurityGroupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeCacheSecurityGroupsPublisher(this.client, (DescribeCacheSecurityGroupsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeCacheSecurityGroupsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeCacheSecurityGroupsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeCacheSecurityGroupsResponseFetcher
    implements AsyncPageFetcher<DescribeCacheSecurityGroupsResponse> {
        private DescribeCacheSecurityGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCacheSecurityGroupsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public CompletableFuture<DescribeCacheSecurityGroupsResponse> nextPage(DescribeCacheSecurityGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeCacheSecurityGroupsPublisher.this.client.describeCacheSecurityGroups(DescribeCacheSecurityGroupsPublisher.this.firstRequest);
            }
            return DescribeCacheSecurityGroupsPublisher.this.client.describeCacheSecurityGroups((DescribeCacheSecurityGroupsRequest)((Object)DescribeCacheSecurityGroupsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

