/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.elasticache.ElastiCacheClient;
import software.amazon.awssdk.services.elasticache.model.CacheParameterGroup;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsResponse;

public class DescribeCacheParameterGroupsIterable
implements SdkIterable<DescribeCacheParameterGroupsResponse> {
    private final ElastiCacheClient client;
    private final DescribeCacheParameterGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeCacheParameterGroupsIterable(ElastiCacheClient client, DescribeCacheParameterGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeCacheParameterGroupsResponseFetcher();
    }

    public Iterator<DescribeCacheParameterGroupsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<CacheParameterGroup> cacheParameterGroups() {
        Function<DescribeCacheParameterGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.cacheParameterGroups() != null) {
                return response.cacheParameterGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeCacheParameterGroupsIterable resume(DescribeCacheParameterGroupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeCacheParameterGroupsIterable(this.client, (DescribeCacheParameterGroupsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeCacheParameterGroupsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeCacheParameterGroupsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeCacheParameterGroupsResponseFetcher
    implements SyncPageFetcher<DescribeCacheParameterGroupsResponse> {
        private DescribeCacheParameterGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCacheParameterGroupsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeCacheParameterGroupsResponse nextPage(DescribeCacheParameterGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeCacheParameterGroupsIterable.this.client.describeCacheParameterGroups(DescribeCacheParameterGroupsIterable.this.firstRequest);
            }
            return DescribeCacheParameterGroupsIterable.this.client.describeCacheParameterGroups((DescribeCacheParameterGroupsRequest)((Object)DescribeCacheParameterGroupsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

