/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.elasticache.ElastiCacheClient;
import software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsResponse;
import software.amazon.awssdk.services.elasticache.model.ReservedCacheNodesOffering;

public final class DescribeReservedCacheNodesOfferingsPaginator
implements SdkIterable<DescribeReservedCacheNodesOfferingsResponse> {
    private final ElastiCacheClient client;
    private final DescribeReservedCacheNodesOfferingsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeReservedCacheNodesOfferingsPaginator(ElastiCacheClient client, DescribeReservedCacheNodesOfferingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeReservedCacheNodesOfferingsResponseFetcher();
    }

    public Iterator<DescribeReservedCacheNodesOfferingsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<ReservedCacheNodesOffering> reservedCacheNodesOfferings() {
        Function<DescribeReservedCacheNodesOfferingsResponse, Iterator> getIterator = response -> response != null ? response.reservedCacheNodesOfferings().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeReservedCacheNodesOfferingsResponseFetcher
    implements NextPageFetcher<DescribeReservedCacheNodesOfferingsResponse> {
        private DescribeReservedCacheNodesOfferingsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedCacheNodesOfferingsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeReservedCacheNodesOfferingsResponse nextPage(DescribeReservedCacheNodesOfferingsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedCacheNodesOfferingsPaginator.this.client.describeReservedCacheNodesOfferings(DescribeReservedCacheNodesOfferingsPaginator.this.firstRequest);
            }
            return DescribeReservedCacheNodesOfferingsPaginator.this.client.describeReservedCacheNodesOfferings((DescribeReservedCacheNodesOfferingsRequest)((Object)DescribeReservedCacheNodesOfferingsPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

