/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.elasticache.ElastiCacheClient;
import software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsResponse;
import software.amazon.awssdk.services.elasticache.model.ReplicationGroup;

public final class DescribeReplicationGroupsPaginator
implements SdkIterable<DescribeReplicationGroupsResponse> {
    private final ElastiCacheClient client;
    private final DescribeReplicationGroupsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeReplicationGroupsPaginator(ElastiCacheClient client, DescribeReplicationGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeReplicationGroupsResponseFetcher();
    }

    public Iterator<DescribeReplicationGroupsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<ReplicationGroup> replicationGroups() {
        Function<DescribeReplicationGroupsResponse, Iterator> getIterator = response -> response != null ? response.replicationGroups().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeReplicationGroupsResponseFetcher
    implements NextPageFetcher<DescribeReplicationGroupsResponse> {
        private DescribeReplicationGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReplicationGroupsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeReplicationGroupsResponse nextPage(DescribeReplicationGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReplicationGroupsPaginator.this.client.describeReplicationGroups(DescribeReplicationGroupsPaginator.this.firstRequest);
            }
            return DescribeReplicationGroupsPaginator.this.client.describeReplicationGroups((DescribeReplicationGroupsRequest)((Object)DescribeReplicationGroupsPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

