/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.elasticache.ElastiCacheClient;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersResponse;
import software.amazon.awssdk.services.elasticache.model.Parameter;

public final class DescribeCacheParametersPaginator
implements SdkIterable<DescribeCacheParametersResponse> {
    private final ElastiCacheClient client;
    private final DescribeCacheParametersRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeCacheParametersPaginator(ElastiCacheClient client, DescribeCacheParametersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeCacheParametersResponseFetcher();
    }

    public Iterator<DescribeCacheParametersResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Parameter> parameters() {
        Function<DescribeCacheParametersResponse, Iterator> getIterator = response -> response != null ? response.parameters().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeCacheParametersResponseFetcher
    implements NextPageFetcher<DescribeCacheParametersResponse> {
        private DescribeCacheParametersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCacheParametersResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeCacheParametersResponse nextPage(DescribeCacheParametersResponse previousPage) {
            if (previousPage == null) {
                return DescribeCacheParametersPaginator.this.client.describeCacheParameters(DescribeCacheParametersPaginator.this.firstRequest);
            }
            return DescribeCacheParametersPaginator.this.client.describeCacheParameters((DescribeCacheParametersRequest)((Object)DescribeCacheParametersPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

