/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TestFailoverRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, TestFailoverRequest> {
    private final String replicationGroupId;
    private final String nodeGroupId;

    private TestFailoverRequest(BuilderImpl builder) {
        super(builder);
        this.replicationGroupId = builder.replicationGroupId;
        this.nodeGroupId = builder.nodeGroupId;
    }

    public String replicationGroupId() {
        return this.replicationGroupId;
    }

    public String nodeGroupId() {
        return this.nodeGroupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeGroupId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestFailoverRequest)) {
            return false;
        }
        TestFailoverRequest other = (TestFailoverRequest)((Object)obj);
        return Objects.equals(this.replicationGroupId(), other.replicationGroupId()) && Objects.equals(this.nodeGroupId(), other.nodeGroupId());
    }

    public String toString() {
        return ToString.builder((String)"TestFailoverRequest").add("ReplicationGroupId", (Object)this.replicationGroupId()).add("NodeGroupId", (Object)this.nodeGroupId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationGroupId": {
                return Optional.of(clazz.cast(this.replicationGroupId()));
            }
            case "NodeGroupId": {
                return Optional.of(clazz.cast(this.nodeGroupId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String replicationGroupId;
        private String nodeGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(TestFailoverRequest model) {
            this.replicationGroupId(model.replicationGroupId);
            this.nodeGroupId(model.nodeGroupId);
        }

        public final String getReplicationGroupId() {
            return this.replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        public final String getNodeGroupId() {
            return this.nodeGroupId;
        }

        @Override
        public final Builder nodeGroupId(String nodeGroupId) {
            this.nodeGroupId = nodeGroupId;
            return this;
        }

        public final void setNodeGroupId(String nodeGroupId) {
            this.nodeGroupId = nodeGroupId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public TestFailoverRequest build() {
            return new TestFailoverRequest(this);
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    CopyableBuilder<Builder, TestFailoverRequest> {
        public Builder replicationGroupId(String var1);

        public Builder nodeGroupId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

