/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.elasticache.ElastiCacheClient;
import software.amazon.awssdk.services.elasticache.model.CacheSubnetGroup;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsResponse;

public final class DescribeCacheSubnetGroupsPaginator
implements SdkIterable<DescribeCacheSubnetGroupsResponse> {
    private final ElastiCacheClient client;
    private final DescribeCacheSubnetGroupsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeCacheSubnetGroupsPaginator(ElastiCacheClient client, DescribeCacheSubnetGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeCacheSubnetGroupsResponseFetcher();
    }

    public Iterator<DescribeCacheSubnetGroupsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<CacheSubnetGroup> cacheSubnetGroups() {
        Function<DescribeCacheSubnetGroupsResponse, Iterator> getIterator = response -> response != null ? response.cacheSubnetGroups().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeCacheSubnetGroupsResponseFetcher
    implements NextPageFetcher<DescribeCacheSubnetGroupsResponse> {
        private DescribeCacheSubnetGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCacheSubnetGroupsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeCacheSubnetGroupsResponse nextPage(DescribeCacheSubnetGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeCacheSubnetGroupsPaginator.this.client.describeCacheSubnetGroups(DescribeCacheSubnetGroupsPaginator.this.firstRequest);
            }
            return DescribeCacheSubnetGroupsPaginator.this.client.describeCacheSubnetGroups((DescribeCacheSubnetGroupsRequest)((Object)DescribeCacheSubnetGroupsPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

