/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.elasticache.model.CacheNodeIdsListCopier;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RebootCacheClusterRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, RebootCacheClusterRequest> {
    private final String cacheClusterId;
    private final List<String> cacheNodeIdsToReboot;

    private RebootCacheClusterRequest(BuilderImpl builder) {
        super(builder);
        this.cacheClusterId = builder.cacheClusterId;
        this.cacheNodeIdsToReboot = builder.cacheNodeIdsToReboot;
    }

    public String cacheClusterId() {
        return this.cacheClusterId;
    }

    public List<String> cacheNodeIdsToReboot() {
        return this.cacheNodeIdsToReboot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNodeIdsToReboot());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RebootCacheClusterRequest)) {
            return false;
        }
        RebootCacheClusterRequest other = (RebootCacheClusterRequest)((Object)obj);
        return Objects.equals(this.cacheClusterId(), other.cacheClusterId()) && Objects.equals(this.cacheNodeIdsToReboot(), other.cacheNodeIdsToReboot());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.cacheClusterId() != null) {
            sb.append("CacheClusterId: ").append(this.cacheClusterId()).append(",");
        }
        if (this.cacheNodeIdsToReboot() != null) {
            sb.append("CacheNodeIdsToReboot: ").append(this.cacheNodeIdsToReboot()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CacheClusterId": {
                return Optional.of(clazz.cast(this.cacheClusterId()));
            }
            case "CacheNodeIdsToReboot": {
                return Optional.of(clazz.cast(this.cacheNodeIdsToReboot()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String cacheClusterId;
        private List<String> cacheNodeIdsToReboot;

        private BuilderImpl() {
        }

        private BuilderImpl(RebootCacheClusterRequest model) {
            this.cacheClusterId(model.cacheClusterId);
            this.cacheNodeIdsToReboot(model.cacheNodeIdsToReboot);
        }

        public final String getCacheClusterId() {
            return this.cacheClusterId;
        }

        @Override
        public final Builder cacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
            return this;
        }

        public final void setCacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
        }

        public final Collection<String> getCacheNodeIdsToReboot() {
            return this.cacheNodeIdsToReboot;
        }

        @Override
        public final Builder cacheNodeIdsToReboot(Collection<String> cacheNodeIdsToReboot) {
            this.cacheNodeIdsToReboot = CacheNodeIdsListCopier.copy(cacheNodeIdsToReboot);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheNodeIdsToReboot(String ... cacheNodeIdsToReboot) {
            this.cacheNodeIdsToReboot(Arrays.asList(cacheNodeIdsToReboot));
            return this;
        }

        public final void setCacheNodeIdsToReboot(Collection<String> cacheNodeIdsToReboot) {
            this.cacheNodeIdsToReboot = CacheNodeIdsListCopier.copy(cacheNodeIdsToReboot);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public RebootCacheClusterRequest build() {
            return new RebootCacheClusterRequest(this);
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    CopyableBuilder<Builder, RebootCacheClusterRequest> {
        public Builder cacheClusterId(String var1);

        public Builder cacheNodeIdsToReboot(Collection<String> var1);

        public Builder cacheNodeIdsToReboot(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

