/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.services.elasticache.model.NodeGroupsToRemoveListCopier;
import software.amazon.awssdk.services.elasticache.model.ReshardingConfiguration;
import software.amazon.awssdk.services.elasticache.model.ReshardingConfigurationListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyReplicationGroupShardConfigurationRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, ModifyReplicationGroupShardConfigurationRequest> {
    private final String replicationGroupId;
    private final Integer nodeGroupCount;
    private final Boolean applyImmediately;
    private final List<ReshardingConfiguration> reshardingConfiguration;
    private final List<String> nodeGroupsToRemove;

    private ModifyReplicationGroupShardConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.replicationGroupId = builder.replicationGroupId;
        this.nodeGroupCount = builder.nodeGroupCount;
        this.applyImmediately = builder.applyImmediately;
        this.reshardingConfiguration = builder.reshardingConfiguration;
        this.nodeGroupsToRemove = builder.nodeGroupsToRemove;
    }

    public String replicationGroupId() {
        return this.replicationGroupId;
    }

    public Integer nodeGroupCount() {
        return this.nodeGroupCount;
    }

    public Boolean applyImmediately() {
        return this.applyImmediately;
    }

    public List<ReshardingConfiguration> reshardingConfiguration() {
        return this.reshardingConfiguration;
    }

    public List<String> nodeGroupsToRemove() {
        return this.nodeGroupsToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeGroupCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.applyImmediately());
        hashCode = 31 * hashCode + Objects.hashCode(this.reshardingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeGroupsToRemove());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyReplicationGroupShardConfigurationRequest)) {
            return false;
        }
        ModifyReplicationGroupShardConfigurationRequest other = (ModifyReplicationGroupShardConfigurationRequest)((Object)obj);
        return Objects.equals(this.replicationGroupId(), other.replicationGroupId()) && Objects.equals(this.nodeGroupCount(), other.nodeGroupCount()) && Objects.equals(this.applyImmediately(), other.applyImmediately()) && Objects.equals(this.reshardingConfiguration(), other.reshardingConfiguration()) && Objects.equals(this.nodeGroupsToRemove(), other.nodeGroupsToRemove());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.replicationGroupId() != null) {
            sb.append("ReplicationGroupId: ").append(this.replicationGroupId()).append(",");
        }
        if (this.nodeGroupCount() != null) {
            sb.append("NodeGroupCount: ").append(this.nodeGroupCount()).append(",");
        }
        if (this.applyImmediately() != null) {
            sb.append("ApplyImmediately: ").append(this.applyImmediately()).append(",");
        }
        if (this.reshardingConfiguration() != null) {
            sb.append("ReshardingConfiguration: ").append(this.reshardingConfiguration()).append(",");
        }
        if (this.nodeGroupsToRemove() != null) {
            sb.append("NodeGroupsToRemove: ").append(this.nodeGroupsToRemove()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationGroupId": {
                return Optional.of(clazz.cast(this.replicationGroupId()));
            }
            case "NodeGroupCount": {
                return Optional.of(clazz.cast(this.nodeGroupCount()));
            }
            case "ApplyImmediately": {
                return Optional.of(clazz.cast(this.applyImmediately()));
            }
            case "ReshardingConfiguration": {
                return Optional.of(clazz.cast(this.reshardingConfiguration()));
            }
            case "NodeGroupsToRemove": {
                return Optional.of(clazz.cast(this.nodeGroupsToRemove()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String replicationGroupId;
        private Integer nodeGroupCount;
        private Boolean applyImmediately;
        private List<ReshardingConfiguration> reshardingConfiguration;
        private List<String> nodeGroupsToRemove;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyReplicationGroupShardConfigurationRequest model) {
            this.replicationGroupId(model.replicationGroupId);
            this.nodeGroupCount(model.nodeGroupCount);
            this.applyImmediately(model.applyImmediately);
            this.reshardingConfiguration(model.reshardingConfiguration);
            this.nodeGroupsToRemove(model.nodeGroupsToRemove);
        }

        public final String getReplicationGroupId() {
            return this.replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        public final Integer getNodeGroupCount() {
            return this.nodeGroupCount;
        }

        @Override
        public final Builder nodeGroupCount(Integer nodeGroupCount) {
            this.nodeGroupCount = nodeGroupCount;
            return this;
        }

        public final void setNodeGroupCount(Integer nodeGroupCount) {
            this.nodeGroupCount = nodeGroupCount;
        }

        public final Boolean getApplyImmediately() {
            return this.applyImmediately;
        }

        @Override
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        public final Collection<ReshardingConfiguration.Builder> getReshardingConfiguration() {
            return this.reshardingConfiguration != null ? (Collection)this.reshardingConfiguration.stream().map(ReshardingConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reshardingConfiguration(Collection<ReshardingConfiguration> reshardingConfiguration) {
            this.reshardingConfiguration = ReshardingConfigurationListCopier.copy(reshardingConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reshardingConfiguration(ReshardingConfiguration ... reshardingConfiguration) {
            this.reshardingConfiguration(Arrays.asList(reshardingConfiguration));
            return this;
        }

        public final void setReshardingConfiguration(Collection<ReshardingConfiguration.BuilderImpl> reshardingConfiguration) {
            this.reshardingConfiguration = ReshardingConfigurationListCopier.copyFromBuilder(reshardingConfiguration);
        }

        public final Collection<String> getNodeGroupsToRemove() {
            return this.nodeGroupsToRemove;
        }

        @Override
        public final Builder nodeGroupsToRemove(Collection<String> nodeGroupsToRemove) {
            this.nodeGroupsToRemove = NodeGroupsToRemoveListCopier.copy(nodeGroupsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeGroupsToRemove(String ... nodeGroupsToRemove) {
            this.nodeGroupsToRemove(Arrays.asList(nodeGroupsToRemove));
            return this;
        }

        public final void setNodeGroupsToRemove(Collection<String> nodeGroupsToRemove) {
            this.nodeGroupsToRemove = NodeGroupsToRemoveListCopier.copy(nodeGroupsToRemove);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ModifyReplicationGroupShardConfigurationRequest build() {
            return new ModifyReplicationGroupShardConfigurationRequest(this);
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    CopyableBuilder<Builder, ModifyReplicationGroupShardConfigurationRequest> {
        public Builder replicationGroupId(String var1);

        public Builder nodeGroupCount(Integer var1);

        public Builder applyImmediately(Boolean var1);

        public Builder reshardingConfiguration(Collection<ReshardingConfiguration> var1);

        public Builder reshardingConfiguration(ReshardingConfiguration ... var1);

        public Builder nodeGroupsToRemove(Collection<String> var1);

        public Builder nodeGroupsToRemove(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

