/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.elasticache.model.CacheSecurityGroup;
import software.amazon.awssdk.services.elasticache.model.CacheSecurityGroupsCopier;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeCacheSecurityGroupsResponse
extends ElastiCacheResponse
implements ToCopyableBuilder<Builder, DescribeCacheSecurityGroupsResponse> {
    private final String marker;
    private final List<CacheSecurityGroup> cacheSecurityGroups;

    private DescribeCacheSecurityGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.cacheSecurityGroups = builder.cacheSecurityGroups;
    }

    public String marker() {
        return this.marker;
    }

    public List<CacheSecurityGroup> cacheSecurityGroups() {
        return this.cacheSecurityGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheSecurityGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCacheSecurityGroupsResponse)) {
            return false;
        }
        DescribeCacheSecurityGroupsResponse other = (DescribeCacheSecurityGroupsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.cacheSecurityGroups(), other.cacheSecurityGroups());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.cacheSecurityGroups() != null) {
            sb.append("CacheSecurityGroups: ").append(this.cacheSecurityGroups()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "CacheSecurityGroups": {
                return Optional.of(clazz.cast(this.cacheSecurityGroups()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElastiCacheResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<CacheSecurityGroup> cacheSecurityGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCacheSecurityGroupsResponse model) {
            this.marker(model.marker);
            this.cacheSecurityGroups(model.cacheSecurityGroups);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<CacheSecurityGroup.Builder> getCacheSecurityGroups() {
            return this.cacheSecurityGroups != null ? (Collection)this.cacheSecurityGroups.stream().map(CacheSecurityGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cacheSecurityGroups(Collection<CacheSecurityGroup> cacheSecurityGroups) {
            this.cacheSecurityGroups = CacheSecurityGroupsCopier.copy(cacheSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheSecurityGroups(CacheSecurityGroup ... cacheSecurityGroups) {
            this.cacheSecurityGroups(Arrays.asList(cacheSecurityGroups));
            return this;
        }

        public final void setCacheSecurityGroups(Collection<CacheSecurityGroup.BuilderImpl> cacheSecurityGroups) {
            this.cacheSecurityGroups = CacheSecurityGroupsCopier.copyFromBuilder(cacheSecurityGroups);
        }

        @Override
        public DescribeCacheSecurityGroupsResponse build() {
            return new DescribeCacheSecurityGroupsResponse(this);
        }
    }

    public static interface Builder
    extends ElastiCacheResponse.Builder,
    CopyableBuilder<Builder, DescribeCacheSecurityGroupsResponse> {
        public Builder marker(String var1);

        public Builder cacheSecurityGroups(Collection<CacheSecurityGroup> var1);

        public Builder cacheSecurityGroups(CacheSecurityGroup ... var1);
    }
}

