/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeCacheEngineVersionsRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, DescribeCacheEngineVersionsRequest> {
    private final String engine;
    private final String engineVersion;
    private final String cacheParameterGroupFamily;
    private final Integer maxRecords;
    private final String marker;
    private final Boolean defaultOnly;

    private DescribeCacheEngineVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.cacheParameterGroupFamily = builder.cacheParameterGroupFamily;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
        this.defaultOnly = builder.defaultOnly;
    }

    public String engine() {
        return this.engine;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public String cacheParameterGroupFamily() {
        return this.cacheParameterGroupFamily;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String marker() {
        return this.marker;
    }

    public Boolean defaultOnly() {
        return this.defaultOnly;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheParameterGroupFamily());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultOnly());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCacheEngineVersionsRequest)) {
            return false;
        }
        DescribeCacheEngineVersionsRequest other = (DescribeCacheEngineVersionsRequest)((Object)obj);
        return Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.cacheParameterGroupFamily(), other.cacheParameterGroupFamily()) && Objects.equals(this.maxRecords(), other.maxRecords()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.defaultOnly(), other.defaultOnly());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.engine() != null) {
            sb.append("Engine: ").append(this.engine()).append(",");
        }
        if (this.engineVersion() != null) {
            sb.append("EngineVersion: ").append(this.engineVersion()).append(",");
        }
        if (this.cacheParameterGroupFamily() != null) {
            sb.append("CacheParameterGroupFamily: ").append(this.cacheParameterGroupFamily()).append(",");
        }
        if (this.maxRecords() != null) {
            sb.append("MaxRecords: ").append(this.maxRecords()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.defaultOnly() != null) {
            sb.append("DefaultOnly: ").append(this.defaultOnly()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Engine": {
                return Optional.of(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.of(clazz.cast(this.engineVersion()));
            }
            case "CacheParameterGroupFamily": {
                return Optional.of(clazz.cast(this.cacheParameterGroupFamily()));
            }
            case "MaxRecords": {
                return Optional.of(clazz.cast(this.maxRecords()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "DefaultOnly": {
                return Optional.of(clazz.cast(this.defaultOnly()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String engine;
        private String engineVersion;
        private String cacheParameterGroupFamily;
        private Integer maxRecords;
        private String marker;
        private Boolean defaultOnly;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCacheEngineVersionsRequest model) {
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.cacheParameterGroupFamily(model.cacheParameterGroupFamily);
            this.maxRecords(model.maxRecords);
            this.marker(model.marker);
            this.defaultOnly(model.defaultOnly);
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getCacheParameterGroupFamily() {
            return this.cacheParameterGroupFamily;
        }

        @Override
        public final Builder cacheParameterGroupFamily(String cacheParameterGroupFamily) {
            this.cacheParameterGroupFamily = cacheParameterGroupFamily;
            return this;
        }

        public final void setCacheParameterGroupFamily(String cacheParameterGroupFamily) {
            this.cacheParameterGroupFamily = cacheParameterGroupFamily;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Boolean getDefaultOnly() {
            return this.defaultOnly;
        }

        @Override
        public final Builder defaultOnly(Boolean defaultOnly) {
            this.defaultOnly = defaultOnly;
            return this;
        }

        public final void setDefaultOnly(Boolean defaultOnly) {
            this.defaultOnly = defaultOnly;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeCacheEngineVersionsRequest build() {
            return new DescribeCacheEngineVersionsRequest(this);
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    CopyableBuilder<Builder, DescribeCacheEngineVersionsRequest> {
        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder cacheParameterGroupFamily(String var1);

        public Builder maxRecords(Integer var1);

        public Builder marker(String var1);

        public Builder defaultOnly(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

