/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticache.model.NodeSnapshot;
import software.amazon.awssdk.services.elasticache.model.Snapshot;
import software.amazon.awssdk.services.elasticache.transform.NodeSnapshotUnmarshaller;

public class SnapshotUnmarshaller
implements Unmarshaller<Snapshot, StaxUnmarshallerContext> {
    private static final SnapshotUnmarshaller INSTANCE = new SnapshotUnmarshaller();

    public Snapshot unmarshall(StaxUnmarshallerContext context) throws Exception {
        Snapshot.Builder snapshot;
        block28: {
            snapshot = Snapshot.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                targetDepth += 3;
            }
            ArrayList<NodeSnapshot> nodeSnapshots = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    snapshot.nodeSnapshots(nodeSnapshots);
                    break block28;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("SnapshotName", targetDepth)) {
                        snapshot.snapshotName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ReplicationGroupId", targetDepth)) {
                        snapshot.replicationGroupId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ReplicationGroupDescription", targetDepth)) {
                        snapshot.replicationGroupDescription(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("CacheClusterId", targetDepth)) {
                        snapshot.cacheClusterId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SnapshotStatus", targetDepth)) {
                        snapshot.snapshotStatus(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SnapshotSource", targetDepth)) {
                        snapshot.snapshotSource(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("CacheNodeType", targetDepth)) {
                        snapshot.cacheNodeType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Engine", targetDepth)) {
                        snapshot.engine(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("EngineVersion", targetDepth)) {
                        snapshot.engineVersion(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("NumCacheNodes", targetDepth)) {
                        snapshot.numCacheNodes(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("PreferredAvailabilityZone", targetDepth)) {
                        snapshot.preferredAvailabilityZone(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("CacheClusterCreateTime", targetDepth)) {
                        snapshot.cacheClusterCreateTime(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("PreferredMaintenanceWindow", targetDepth)) {
                        snapshot.preferredMaintenanceWindow(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("TopicArn", targetDepth)) {
                        snapshot.topicArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Port", targetDepth)) {
                        snapshot.port(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("CacheParameterGroupName", targetDepth)) {
                        snapshot.cacheParameterGroupName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("CacheSubnetGroupName", targetDepth)) {
                        snapshot.cacheSubnetGroupName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("VpcId", targetDepth)) {
                        snapshot.vpcId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("AutoMinorVersionUpgrade", targetDepth)) {
                        snapshot.autoMinorVersionUpgrade(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SnapshotRetentionLimit", targetDepth)) {
                        snapshot.snapshotRetentionLimit(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SnapshotWindow", targetDepth)) {
                        snapshot.snapshotWindow(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("NumNodeGroups", targetDepth)) {
                        snapshot.numNodeGroups(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("AutomaticFailover", targetDepth)) {
                        snapshot.automaticFailover(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("NodeSnapshots", targetDepth)) {
                        nodeSnapshots = new ArrayList<NodeSnapshot>();
                        continue;
                    }
                    if (!context.testExpression("NodeSnapshots/NodeSnapshot", targetDepth)) continue;
                    nodeSnapshots.add(NodeSnapshotUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            snapshot.nodeSnapshots(nodeSnapshots);
        }
        return (Snapshot)snapshot.build();
    }

    public static SnapshotUnmarshaller getInstance() {
        return INSTANCE;
    }
}

