/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupShardConfigurationRequest;
import software.amazon.awssdk.services.elasticache.model.ReshardingConfiguration;

public class ModifyReplicationGroupShardConfigurationRequestMarshaller
implements Marshaller<Request<ModifyReplicationGroupShardConfigurationRequest>, ModifyReplicationGroupShardConfigurationRequest> {
    public Request<ModifyReplicationGroupShardConfigurationRequest> marshall(ModifyReplicationGroupShardConfigurationRequest modifyReplicationGroupShardConfigurationRequest) {
        List<String> nodeGroupsToRemoveList;
        List<ReshardingConfiguration> reshardingConfigurationList;
        if (modifyReplicationGroupShardConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyReplicationGroupShardConfigurationRequest, "ElastiCacheClient");
        request.addParameter("Action", "ModifyReplicationGroupShardConfiguration");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyReplicationGroupShardConfigurationRequest.replicationGroupId() != null) {
            request.addParameter("ReplicationGroupId", StringUtils.fromString((String)modifyReplicationGroupShardConfigurationRequest.replicationGroupId()));
        }
        if (modifyReplicationGroupShardConfigurationRequest.nodeGroupCount() != null) {
            request.addParameter("NodeGroupCount", StringUtils.fromInteger((Integer)modifyReplicationGroupShardConfigurationRequest.nodeGroupCount()));
        }
        if (modifyReplicationGroupShardConfigurationRequest.applyImmediately() != null) {
            request.addParameter("ApplyImmediately", StringUtils.fromBoolean((Boolean)modifyReplicationGroupShardConfigurationRequest.applyImmediately()));
        }
        if ((reshardingConfigurationList = modifyReplicationGroupShardConfigurationRequest.reshardingConfiguration()) != null) {
            if (!reshardingConfigurationList.isEmpty()) {
                int reshardingConfigurationListIndex = 1;
                for (ReshardingConfiguration reshardingConfigurationListValue : reshardingConfigurationList) {
                    List<String> preferredAvailabilityZonesList = reshardingConfigurationListValue.preferredAvailabilityZones();
                    if (preferredAvailabilityZonesList != null) {
                        if (!preferredAvailabilityZonesList.isEmpty()) {
                            int preferredAvailabilityZonesListIndex = 1;
                            for (String preferredAvailabilityZonesListValue : preferredAvailabilityZonesList) {
                                if (preferredAvailabilityZonesListValue != null) {
                                    request.addParameter("ReshardingConfiguration.ReshardingConfiguration." + reshardingConfigurationListIndex + ".PreferredAvailabilityZones.AvailabilityZone." + preferredAvailabilityZonesListIndex, StringUtils.fromString((String)preferredAvailabilityZonesListValue));
                                }
                                ++preferredAvailabilityZonesListIndex;
                            }
                        } else {
                            request.addParameter("ReshardingConfiguration.ReshardingConfiguration." + reshardingConfigurationListIndex + ".PreferredAvailabilityZones", "");
                        }
                    }
                    ++reshardingConfigurationListIndex;
                }
            } else {
                request.addParameter("ReshardingConfiguration", "");
            }
        }
        if ((nodeGroupsToRemoveList = modifyReplicationGroupShardConfigurationRequest.nodeGroupsToRemove()) != null) {
            if (!nodeGroupsToRemoveList.isEmpty()) {
                int nodeGroupsToRemoveListIndex = 1;
                for (String nodeGroupsToRemoveListValue : nodeGroupsToRemoveList) {
                    if (nodeGroupsToRemoveListValue != null) {
                        request.addParameter("NodeGroupsToRemove.NodeGroupToRemove." + nodeGroupsToRemoveListIndex, StringUtils.fromString((String)nodeGroupsToRemoveListValue));
                    }
                    ++nodeGroupsToRemoveListIndex;
                }
            } else {
                request.addParameter("NodeGroupsToRemove", "");
            }
        }
        return request;
    }
}

