/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticache.model.ModifyCacheSubnetGroupRequest;

public class ModifyCacheSubnetGroupRequestMarshaller
implements Marshaller<Request<ModifyCacheSubnetGroupRequest>, ModifyCacheSubnetGroupRequest> {
    public Request<ModifyCacheSubnetGroupRequest> marshall(ModifyCacheSubnetGroupRequest modifyCacheSubnetGroupRequest) {
        List<String> subnetIdsList;
        if (modifyCacheSubnetGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyCacheSubnetGroupRequest, "ElastiCacheClient");
        request.addParameter("Action", "ModifyCacheSubnetGroup");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyCacheSubnetGroupRequest.cacheSubnetGroupName() != null) {
            request.addParameter("CacheSubnetGroupName", StringUtils.fromString((String)modifyCacheSubnetGroupRequest.cacheSubnetGroupName()));
        }
        if (modifyCacheSubnetGroupRequest.cacheSubnetGroupDescription() != null) {
            request.addParameter("CacheSubnetGroupDescription", StringUtils.fromString((String)modifyCacheSubnetGroupRequest.cacheSubnetGroupDescription()));
        }
        if ((subnetIdsList = modifyCacheSubnetGroupRequest.subnetIds()) != null) {
            if (!subnetIdsList.isEmpty()) {
                int subnetIdsListIndex = 1;
                for (String subnetIdsListValue : subnetIdsList) {
                    if (subnetIdsListValue != null) {
                        request.addParameter("SubnetIds.SubnetIdentifier." + subnetIdsListIndex, StringUtils.fromString((String)subnetIdsListValue));
                    }
                    ++subnetIdsListIndex;
                }
            } else {
                request.addParameter("SubnetIds", "");
            }
        }
        return request;
    }
}

