/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsRequest;

public class DescribeCacheSubnetGroupsRequestMarshaller
implements Marshaller<Request<DescribeCacheSubnetGroupsRequest>, DescribeCacheSubnetGroupsRequest> {
    public Request<DescribeCacheSubnetGroupsRequest> marshall(DescribeCacheSubnetGroupsRequest describeCacheSubnetGroupsRequest) {
        if (describeCacheSubnetGroupsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeCacheSubnetGroupsRequest, "ElastiCacheClient");
        request.addParameter("Action", "DescribeCacheSubnetGroups");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeCacheSubnetGroupsRequest.cacheSubnetGroupName() != null) {
            request.addParameter("CacheSubnetGroupName", StringUtils.fromString((String)describeCacheSubnetGroupsRequest.cacheSubnetGroupName()));
        }
        if (describeCacheSubnetGroupsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeCacheSubnetGroupsRequest.maxRecords()));
        }
        if (describeCacheSubnetGroupsRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeCacheSubnetGroupsRequest.marker()));
        }
        return request;
    }
}

