/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticache.model.DeleteReplicationGroupRequest;

public class DeleteReplicationGroupRequestMarshaller
implements Marshaller<Request<DeleteReplicationGroupRequest>, DeleteReplicationGroupRequest> {
    public Request<DeleteReplicationGroupRequest> marshall(DeleteReplicationGroupRequest deleteReplicationGroupRequest) {
        if (deleteReplicationGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteReplicationGroupRequest, "ElastiCacheClient");
        request.addParameter("Action", "DeleteReplicationGroup");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteReplicationGroupRequest.replicationGroupId() != null) {
            request.addParameter("ReplicationGroupId", StringUtils.fromString((String)deleteReplicationGroupRequest.replicationGroupId()));
        }
        if (deleteReplicationGroupRequest.retainPrimaryCluster() != null) {
            request.addParameter("RetainPrimaryCluster", StringUtils.fromBoolean((Boolean)deleteReplicationGroupRequest.retainPrimaryCluster()));
        }
        if (deleteReplicationGroupRequest.finalSnapshotIdentifier() != null) {
            request.addParameter("FinalSnapshotIdentifier", StringUtils.fromString((String)deleteReplicationGroupRequest.finalSnapshotIdentifier()));
        }
        return request;
    }
}

