/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticache.model.CreateCacheClusterRequest;
import software.amazon.awssdk.services.elasticache.model.Tag;

public class CreateCacheClusterRequestMarshaller
implements Marshaller<Request<CreateCacheClusterRequest>, CreateCacheClusterRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<CreateCacheClusterRequest> marshall(CreateCacheClusterRequest createCacheClusterRequest) {
        List<String> list;
        List<Tag> list2;
        List<String> securityGroupIdsList;
        List<String> cacheSecurityGroupNamesList;
        List<String> preferredAvailabilityZonesList;
        if (createCacheClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createCacheClusterRequest, "ElastiCacheClient");
        request.addParameter("Action", "CreateCacheCluster");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (createCacheClusterRequest.cacheClusterId() != null) {
            request.addParameter("CacheClusterId", StringUtils.fromString((String)createCacheClusterRequest.cacheClusterId()));
        }
        if (createCacheClusterRequest.replicationGroupId() != null) {
            request.addParameter("ReplicationGroupId", StringUtils.fromString((String)createCacheClusterRequest.replicationGroupId()));
        }
        if (createCacheClusterRequest.azModeString() != null) {
            request.addParameter("AZMode", StringUtils.fromString((String)createCacheClusterRequest.azModeString()));
        }
        if (createCacheClusterRequest.preferredAvailabilityZone() != null) {
            request.addParameter("PreferredAvailabilityZone", StringUtils.fromString((String)createCacheClusterRequest.preferredAvailabilityZone()));
        }
        if ((preferredAvailabilityZonesList = createCacheClusterRequest.preferredAvailabilityZones()) != null) {
            if (!preferredAvailabilityZonesList.isEmpty()) {
                int preferredAvailabilityZonesListIndex = 1;
                for (String string : preferredAvailabilityZonesList) {
                    if (string != null) {
                        request.addParameter("PreferredAvailabilityZones.PreferredAvailabilityZone." + preferredAvailabilityZonesListIndex, StringUtils.fromString((String)string));
                    }
                    ++preferredAvailabilityZonesListIndex;
                }
            } else {
                request.addParameter("PreferredAvailabilityZones", "");
            }
        }
        if (createCacheClusterRequest.numCacheNodes() != null) {
            request.addParameter("NumCacheNodes", StringUtils.fromInteger((Integer)createCacheClusterRequest.numCacheNodes()));
        }
        if (createCacheClusterRequest.cacheNodeType() != null) {
            request.addParameter("CacheNodeType", StringUtils.fromString((String)createCacheClusterRequest.cacheNodeType()));
        }
        if (createCacheClusterRequest.engine() != null) {
            request.addParameter("Engine", StringUtils.fromString((String)createCacheClusterRequest.engine()));
        }
        if (createCacheClusterRequest.engineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)createCacheClusterRequest.engineVersion()));
        }
        if (createCacheClusterRequest.cacheParameterGroupName() != null) {
            request.addParameter("CacheParameterGroupName", StringUtils.fromString((String)createCacheClusterRequest.cacheParameterGroupName()));
        }
        if (createCacheClusterRequest.cacheSubnetGroupName() != null) {
            request.addParameter("CacheSubnetGroupName", StringUtils.fromString((String)createCacheClusterRequest.cacheSubnetGroupName()));
        }
        if ((cacheSecurityGroupNamesList = createCacheClusterRequest.cacheSecurityGroupNames()) != null) {
            if (!cacheSecurityGroupNamesList.isEmpty()) {
                int cacheSecurityGroupNamesListIndex = 1;
                for (String string : cacheSecurityGroupNamesList) {
                    if (string != null) {
                        request.addParameter("CacheSecurityGroupNames.CacheSecurityGroupName." + cacheSecurityGroupNamesListIndex, StringUtils.fromString((String)string));
                    }
                    ++cacheSecurityGroupNamesListIndex;
                }
            } else {
                request.addParameter("CacheSecurityGroupNames", "");
            }
        }
        if ((securityGroupIdsList = createCacheClusterRequest.securityGroupIds()) != null) {
            if (!securityGroupIdsList.isEmpty()) {
                boolean bl = true;
                for (String string : securityGroupIdsList) {
                    void var6_12;
                    if (string != null) {
                        request.addParameter("SecurityGroupIds.SecurityGroupId." + (int)var6_12, StringUtils.fromString((String)string));
                    }
                    ++var6_12;
                }
            } else {
                request.addParameter("SecurityGroupIds", "");
            }
        }
        if ((list2 = createCacheClusterRequest.tags()) != null) {
            if (!list2.isEmpty()) {
                boolean bl = true;
                for (Tag tagsListValue : list2) {
                    void var7_18;
                    if (tagsListValue.key() != null) {
                        request.addParameter("Tags.Tag." + (int)var7_18 + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                    }
                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.Tag." + (int)var7_18 + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                    }
                    ++var7_18;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }
        if ((list = createCacheClusterRequest.snapshotArns()) != null) {
            if (!list.isEmpty()) {
                boolean bl = true;
                for (String snapshotArnsListValue : list) {
                    void var8_24;
                    if (snapshotArnsListValue != null) {
                        request.addParameter("SnapshotArns.SnapshotArn." + (int)var8_24, StringUtils.fromString((String)snapshotArnsListValue));
                    }
                    ++var8_24;
                }
            } else {
                request.addParameter("SnapshotArns", "");
            }
        }
        if (createCacheClusterRequest.snapshotName() != null) {
            request.addParameter("SnapshotName", StringUtils.fromString((String)createCacheClusterRequest.snapshotName()));
        }
        if (createCacheClusterRequest.preferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringUtils.fromString((String)createCacheClusterRequest.preferredMaintenanceWindow()));
        }
        if (createCacheClusterRequest.port() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)createCacheClusterRequest.port()));
        }
        if (createCacheClusterRequest.notificationTopicArn() != null) {
            request.addParameter("NotificationTopicArn", StringUtils.fromString((String)createCacheClusterRequest.notificationTopicArn()));
        }
        if (createCacheClusterRequest.autoMinorVersionUpgrade() != null) {
            request.addParameter("AutoMinorVersionUpgrade", StringUtils.fromBoolean((Boolean)createCacheClusterRequest.autoMinorVersionUpgrade()));
        }
        if (createCacheClusterRequest.snapshotRetentionLimit() != null) {
            request.addParameter("SnapshotRetentionLimit", StringUtils.fromInteger((Integer)createCacheClusterRequest.snapshotRetentionLimit()));
        }
        if (createCacheClusterRequest.snapshotWindow() != null) {
            request.addParameter("SnapshotWindow", StringUtils.fromString((String)createCacheClusterRequest.snapshotWindow()));
        }
        if (createCacheClusterRequest.authToken() != null) {
            request.addParameter("AuthToken", StringUtils.fromString((String)createCacheClusterRequest.authToken()));
        }
        return request;
    }
}

