/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.elasticache.ElastiCacheClient;
import software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersResponse;
import software.amazon.awssdk.services.elasticache.model.Parameter;

public final class DescribeEngineDefaultParametersPaginator
implements SdkIterable<DescribeEngineDefaultParametersResponse> {
    private final ElastiCacheClient client;
    private final DescribeEngineDefaultParametersRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeEngineDefaultParametersPaginator(ElastiCacheClient client, DescribeEngineDefaultParametersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeEngineDefaultParametersResponseFetcher();
    }

    public Iterator<DescribeEngineDefaultParametersResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Parameter> parameters() {
        Function<DescribeEngineDefaultParametersResponse, Iterator> getIterator = response -> response != null ? response.engineDefaults().parameters().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeEngineDefaultParametersResponseFetcher
    implements NextPageFetcher<DescribeEngineDefaultParametersResponse> {
        private DescribeEngineDefaultParametersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEngineDefaultParametersResponse previousPage) {
            return previousPage.engineDefaults().marker() != null;
        }

        public DescribeEngineDefaultParametersResponse nextPage(DescribeEngineDefaultParametersResponse previousPage) {
            if (previousPage == null) {
                return DescribeEngineDefaultParametersPaginator.this.client.describeEngineDefaultParameters(DescribeEngineDefaultParametersPaginator.this.firstRequest);
            }
            return DescribeEngineDefaultParametersPaginator.this.client.describeEngineDefaultParameters((DescribeEngineDefaultParametersRequest)((Object)DescribeEngineDefaultParametersPaginator.this.firstRequest.toBuilder().marker(previousPage.engineDefaults().marker()).build()));
        }
    }
}

