/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.elasticache.ElastiCacheClient;
import software.amazon.awssdk.services.elasticache.model.CacheParameterGroup;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsResponse;

public final class DescribeCacheParameterGroupsPaginator
implements SdkIterable<DescribeCacheParameterGroupsResponse> {
    private final ElastiCacheClient client;
    private final DescribeCacheParameterGroupsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeCacheParameterGroupsPaginator(ElastiCacheClient client, DescribeCacheParameterGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeCacheParameterGroupsResponseFetcher();
    }

    public Iterator<DescribeCacheParameterGroupsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<CacheParameterGroup> cacheParameterGroups() {
        Function<DescribeCacheParameterGroupsResponse, Iterator> getIterator = response -> response != null ? response.cacheParameterGroups().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeCacheParameterGroupsResponseFetcher
    implements NextPageFetcher<DescribeCacheParameterGroupsResponse> {
        private DescribeCacheParameterGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCacheParameterGroupsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeCacheParameterGroupsResponse nextPage(DescribeCacheParameterGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeCacheParameterGroupsPaginator.this.client.describeCacheParameterGroups(DescribeCacheParameterGroupsPaginator.this.firstRequest);
            }
            return DescribeCacheParameterGroupsPaginator.this.client.describeCacheParameterGroups((DescribeCacheParameterGroupsRequest)((Object)DescribeCacheParameterGroupsPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

