/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.elasticache.model.AutomaticFailoverStatus;
import software.amazon.awssdk.services.elasticache.model.ClusterIdListCopier;
import software.amazon.awssdk.services.elasticache.model.Endpoint;
import software.amazon.awssdk.services.elasticache.model.NodeGroup;
import software.amazon.awssdk.services.elasticache.model.NodeGroupListCopier;
import software.amazon.awssdk.services.elasticache.model.ReplicationGroupPendingModifiedValues;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReplicationGroup
implements ToCopyableBuilder<Builder, ReplicationGroup> {
    private final String replicationGroupId;
    private final String description;
    private final String status;
    private final ReplicationGroupPendingModifiedValues pendingModifiedValues;
    private final List<String> memberClusters;
    private final List<NodeGroup> nodeGroups;
    private final String snapshottingClusterId;
    private final String automaticFailover;
    private final Endpoint configurationEndpoint;
    private final Integer snapshotRetentionLimit;
    private final String snapshotWindow;
    private final Boolean clusterEnabled;
    private final String cacheNodeType;
    private final Boolean authTokenEnabled;
    private final Boolean transitEncryptionEnabled;
    private final Boolean atRestEncryptionEnabled;

    private ReplicationGroup(BuilderImpl builder) {
        this.replicationGroupId = builder.replicationGroupId;
        this.description = builder.description;
        this.status = builder.status;
        this.pendingModifiedValues = builder.pendingModifiedValues;
        this.memberClusters = builder.memberClusters;
        this.nodeGroups = builder.nodeGroups;
        this.snapshottingClusterId = builder.snapshottingClusterId;
        this.automaticFailover = builder.automaticFailover;
        this.configurationEndpoint = builder.configurationEndpoint;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.snapshotWindow = builder.snapshotWindow;
        this.clusterEnabled = builder.clusterEnabled;
        this.cacheNodeType = builder.cacheNodeType;
        this.authTokenEnabled = builder.authTokenEnabled;
        this.transitEncryptionEnabled = builder.transitEncryptionEnabled;
        this.atRestEncryptionEnabled = builder.atRestEncryptionEnabled;
    }

    public String replicationGroupId() {
        return this.replicationGroupId;
    }

    public String description() {
        return this.description;
    }

    public String status() {
        return this.status;
    }

    public ReplicationGroupPendingModifiedValues pendingModifiedValues() {
        return this.pendingModifiedValues;
    }

    public List<String> memberClusters() {
        return this.memberClusters;
    }

    public List<NodeGroup> nodeGroups() {
        return this.nodeGroups;
    }

    public String snapshottingClusterId() {
        return this.snapshottingClusterId;
    }

    public AutomaticFailoverStatus automaticFailover() {
        return AutomaticFailoverStatus.fromValue(this.automaticFailover);
    }

    public String automaticFailoverString() {
        return this.automaticFailover;
    }

    public Endpoint configurationEndpoint() {
        return this.configurationEndpoint;
    }

    public Integer snapshotRetentionLimit() {
        return this.snapshotRetentionLimit;
    }

    public String snapshotWindow() {
        return this.snapshotWindow;
    }

    public Boolean clusterEnabled() {
        return this.clusterEnabled;
    }

    public String cacheNodeType() {
        return this.cacheNodeType;
    }

    public Boolean authTokenEnabled() {
        return this.authTokenEnabled;
    }

    public Boolean transitEncryptionEnabled() {
        return this.transitEncryptionEnabled;
    }

    public Boolean atRestEncryptionEnabled() {
        return this.atRestEncryptionEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingModifiedValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberClusters());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshottingClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.automaticFailoverString());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotRetentionLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.authTokenEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.atRestEncryptionEnabled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationGroup)) {
            return false;
        }
        ReplicationGroup other = (ReplicationGroup)obj;
        return Objects.equals(this.replicationGroupId(), other.replicationGroupId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.pendingModifiedValues(), other.pendingModifiedValues()) && Objects.equals(this.memberClusters(), other.memberClusters()) && Objects.equals(this.nodeGroups(), other.nodeGroups()) && Objects.equals(this.snapshottingClusterId(), other.snapshottingClusterId()) && Objects.equals(this.automaticFailoverString(), other.automaticFailoverString()) && Objects.equals(this.configurationEndpoint(), other.configurationEndpoint()) && Objects.equals(this.snapshotRetentionLimit(), other.snapshotRetentionLimit()) && Objects.equals(this.snapshotWindow(), other.snapshotWindow()) && Objects.equals(this.clusterEnabled(), other.clusterEnabled()) && Objects.equals(this.cacheNodeType(), other.cacheNodeType()) && Objects.equals(this.authTokenEnabled(), other.authTokenEnabled()) && Objects.equals(this.transitEncryptionEnabled(), other.transitEncryptionEnabled()) && Objects.equals(this.atRestEncryptionEnabled(), other.atRestEncryptionEnabled());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.replicationGroupId() != null) {
            sb.append("ReplicationGroupId: ").append(this.replicationGroupId()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.pendingModifiedValues() != null) {
            sb.append("PendingModifiedValues: ").append(this.pendingModifiedValues()).append(",");
        }
        if (this.memberClusters() != null) {
            sb.append("MemberClusters: ").append(this.memberClusters()).append(",");
        }
        if (this.nodeGroups() != null) {
            sb.append("NodeGroups: ").append(this.nodeGroups()).append(",");
        }
        if (this.snapshottingClusterId() != null) {
            sb.append("SnapshottingClusterId: ").append(this.snapshottingClusterId()).append(",");
        }
        if (this.automaticFailoverString() != null) {
            sb.append("AutomaticFailover: ").append(this.automaticFailoverString()).append(",");
        }
        if (this.configurationEndpoint() != null) {
            sb.append("ConfigurationEndpoint: ").append(this.configurationEndpoint()).append(",");
        }
        if (this.snapshotRetentionLimit() != null) {
            sb.append("SnapshotRetentionLimit: ").append(this.snapshotRetentionLimit()).append(",");
        }
        if (this.snapshotWindow() != null) {
            sb.append("SnapshotWindow: ").append(this.snapshotWindow()).append(",");
        }
        if (this.clusterEnabled() != null) {
            sb.append("ClusterEnabled: ").append(this.clusterEnabled()).append(",");
        }
        if (this.cacheNodeType() != null) {
            sb.append("CacheNodeType: ").append(this.cacheNodeType()).append(",");
        }
        if (this.authTokenEnabled() != null) {
            sb.append("AuthTokenEnabled: ").append(this.authTokenEnabled()).append(",");
        }
        if (this.transitEncryptionEnabled() != null) {
            sb.append("TransitEncryptionEnabled: ").append(this.transitEncryptionEnabled()).append(",");
        }
        if (this.atRestEncryptionEnabled() != null) {
            sb.append("AtRestEncryptionEnabled: ").append(this.atRestEncryptionEnabled()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationGroupId": {
                return Optional.of(clazz.cast(this.replicationGroupId()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "PendingModifiedValues": {
                return Optional.of(clazz.cast(this.pendingModifiedValues()));
            }
            case "MemberClusters": {
                return Optional.of(clazz.cast(this.memberClusters()));
            }
            case "NodeGroups": {
                return Optional.of(clazz.cast(this.nodeGroups()));
            }
            case "SnapshottingClusterId": {
                return Optional.of(clazz.cast(this.snapshottingClusterId()));
            }
            case "AutomaticFailover": {
                return Optional.of(clazz.cast(this.automaticFailoverString()));
            }
            case "ConfigurationEndpoint": {
                return Optional.of(clazz.cast(this.configurationEndpoint()));
            }
            case "SnapshotRetentionLimit": {
                return Optional.of(clazz.cast(this.snapshotRetentionLimit()));
            }
            case "SnapshotWindow": {
                return Optional.of(clazz.cast(this.snapshotWindow()));
            }
            case "ClusterEnabled": {
                return Optional.of(clazz.cast(this.clusterEnabled()));
            }
            case "CacheNodeType": {
                return Optional.of(clazz.cast(this.cacheNodeType()));
            }
            case "AuthTokenEnabled": {
                return Optional.of(clazz.cast(this.authTokenEnabled()));
            }
            case "TransitEncryptionEnabled": {
                return Optional.of(clazz.cast(this.transitEncryptionEnabled()));
            }
            case "AtRestEncryptionEnabled": {
                return Optional.of(clazz.cast(this.atRestEncryptionEnabled()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String replicationGroupId;
        private String description;
        private String status;
        private ReplicationGroupPendingModifiedValues pendingModifiedValues;
        private List<String> memberClusters;
        private List<NodeGroup> nodeGroups;
        private String snapshottingClusterId;
        private String automaticFailover;
        private Endpoint configurationEndpoint;
        private Integer snapshotRetentionLimit;
        private String snapshotWindow;
        private Boolean clusterEnabled;
        private String cacheNodeType;
        private Boolean authTokenEnabled;
        private Boolean transitEncryptionEnabled;
        private Boolean atRestEncryptionEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationGroup model) {
            this.replicationGroupId(model.replicationGroupId);
            this.description(model.description);
            this.status(model.status);
            this.pendingModifiedValues(model.pendingModifiedValues);
            this.memberClusters(model.memberClusters);
            this.nodeGroups(model.nodeGroups);
            this.snapshottingClusterId(model.snapshottingClusterId);
            this.automaticFailover(model.automaticFailover);
            this.configurationEndpoint(model.configurationEndpoint);
            this.snapshotRetentionLimit(model.snapshotRetentionLimit);
            this.snapshotWindow(model.snapshotWindow);
            this.clusterEnabled(model.clusterEnabled);
            this.cacheNodeType(model.cacheNodeType);
            this.authTokenEnabled(model.authTokenEnabled);
            this.transitEncryptionEnabled(model.transitEncryptionEnabled);
            this.atRestEncryptionEnabled(model.atRestEncryptionEnabled);
        }

        public final String getReplicationGroupId() {
            return this.replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final ReplicationGroupPendingModifiedValues.Builder getPendingModifiedValues() {
            return this.pendingModifiedValues != null ? this.pendingModifiedValues.toBuilder() : null;
        }

        @Override
        public final Builder pendingModifiedValues(ReplicationGroupPendingModifiedValues pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues;
            return this;
        }

        public final void setPendingModifiedValues(ReplicationGroupPendingModifiedValues.BuilderImpl pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues != null ? pendingModifiedValues.build() : null;
        }

        public final Collection<String> getMemberClusters() {
            return this.memberClusters;
        }

        @Override
        public final Builder memberClusters(Collection<String> memberClusters) {
            this.memberClusters = ClusterIdListCopier.copy(memberClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberClusters(String ... memberClusters) {
            this.memberClusters(Arrays.asList(memberClusters));
            return this;
        }

        public final void setMemberClusters(Collection<String> memberClusters) {
            this.memberClusters = ClusterIdListCopier.copy(memberClusters);
        }

        public final Collection<NodeGroup.Builder> getNodeGroups() {
            return this.nodeGroups != null ? (Collection)this.nodeGroups.stream().map(NodeGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder nodeGroups(Collection<NodeGroup> nodeGroups) {
            this.nodeGroups = NodeGroupListCopier.copy(nodeGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeGroups(NodeGroup ... nodeGroups) {
            this.nodeGroups(Arrays.asList(nodeGroups));
            return this;
        }

        public final void setNodeGroups(Collection<NodeGroup.BuilderImpl> nodeGroups) {
            this.nodeGroups = NodeGroupListCopier.copyFromBuilder(nodeGroups);
        }

        public final String getSnapshottingClusterId() {
            return this.snapshottingClusterId;
        }

        @Override
        public final Builder snapshottingClusterId(String snapshottingClusterId) {
            this.snapshottingClusterId = snapshottingClusterId;
            return this;
        }

        public final void setSnapshottingClusterId(String snapshottingClusterId) {
            this.snapshottingClusterId = snapshottingClusterId;
        }

        public final String getAutomaticFailover() {
            return this.automaticFailover;
        }

        @Override
        public final Builder automaticFailover(String automaticFailover) {
            this.automaticFailover = automaticFailover;
            return this;
        }

        @Override
        public final Builder automaticFailover(AutomaticFailoverStatus automaticFailover) {
            this.automaticFailover(automaticFailover.toString());
            return this;
        }

        public final void setAutomaticFailover(String automaticFailover) {
            this.automaticFailover = automaticFailover;
        }

        public final Endpoint.Builder getConfigurationEndpoint() {
            return this.configurationEndpoint != null ? this.configurationEndpoint.toBuilder() : null;
        }

        @Override
        public final Builder configurationEndpoint(Endpoint configurationEndpoint) {
            this.configurationEndpoint = configurationEndpoint;
            return this;
        }

        public final void setConfigurationEndpoint(Endpoint.BuilderImpl configurationEndpoint) {
            this.configurationEndpoint = configurationEndpoint != null ? configurationEndpoint.build() : null;
        }

        public final Integer getSnapshotRetentionLimit() {
            return this.snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        public final String getSnapshotWindow() {
            return this.snapshotWindow;
        }

        @Override
        public final Builder snapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
            return this;
        }

        public final void setSnapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
        }

        public final Boolean getClusterEnabled() {
            return this.clusterEnabled;
        }

        @Override
        public final Builder clusterEnabled(Boolean clusterEnabled) {
            this.clusterEnabled = clusterEnabled;
            return this;
        }

        public final void setClusterEnabled(Boolean clusterEnabled) {
            this.clusterEnabled = clusterEnabled;
        }

        public final String getCacheNodeType() {
            return this.cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        public final Boolean getAuthTokenEnabled() {
            return this.authTokenEnabled;
        }

        @Override
        public final Builder authTokenEnabled(Boolean authTokenEnabled) {
            this.authTokenEnabled = authTokenEnabled;
            return this;
        }

        public final void setAuthTokenEnabled(Boolean authTokenEnabled) {
            this.authTokenEnabled = authTokenEnabled;
        }

        public final Boolean getTransitEncryptionEnabled() {
            return this.transitEncryptionEnabled;
        }

        @Override
        public final Builder transitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
            return this;
        }

        public final void setTransitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
        }

        public final Boolean getAtRestEncryptionEnabled() {
            return this.atRestEncryptionEnabled;
        }

        @Override
        public final Builder atRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
            this.atRestEncryptionEnabled = atRestEncryptionEnabled;
            return this;
        }

        public final void setAtRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
            this.atRestEncryptionEnabled = atRestEncryptionEnabled;
        }

        public ReplicationGroup build() {
            return new ReplicationGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReplicationGroup> {
        public Builder replicationGroupId(String var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder pendingModifiedValues(ReplicationGroupPendingModifiedValues var1);

        default public Builder pendingModifiedValues(Consumer<ReplicationGroupPendingModifiedValues.Builder> pendingModifiedValues) {
            return this.pendingModifiedValues((ReplicationGroupPendingModifiedValues)((ReplicationGroupPendingModifiedValues.Builder)ReplicationGroupPendingModifiedValues.builder().apply(pendingModifiedValues)).build());
        }

        public Builder memberClusters(Collection<String> var1);

        public Builder memberClusters(String ... var1);

        public Builder nodeGroups(Collection<NodeGroup> var1);

        public Builder nodeGroups(NodeGroup ... var1);

        public Builder snapshottingClusterId(String var1);

        public Builder automaticFailover(String var1);

        public Builder automaticFailover(AutomaticFailoverStatus var1);

        public Builder configurationEndpoint(Endpoint var1);

        default public Builder configurationEndpoint(Consumer<Endpoint.Builder> configurationEndpoint) {
            return this.configurationEndpoint((Endpoint)((Endpoint.Builder)Endpoint.builder().apply(configurationEndpoint)).build());
        }

        public Builder snapshotRetentionLimit(Integer var1);

        public Builder snapshotWindow(String var1);

        public Builder clusterEnabled(Boolean var1);

        public Builder cacheNodeType(String var1);

        public Builder authTokenEnabled(Boolean var1);

        public Builder transitEncryptionEnabled(Boolean var1);

        public Builder atRestEncryptionEnabled(Boolean var1);
    }
}

