/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticache.model.CacheSecurityGroupNameListCopier;
import software.amazon.awssdk.services.elasticache.model.SecurityGroupIdsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyReplicationGroupRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ModifyReplicationGroupRequest> {
    private final String replicationGroupId;
    private final String replicationGroupDescription;
    private final String primaryClusterId;
    private final String snapshottingClusterId;
    private final Boolean automaticFailoverEnabled;
    private final List<String> cacheSecurityGroupNames;
    private final List<String> securityGroupIds;
    private final String preferredMaintenanceWindow;
    private final String notificationTopicArn;
    private final String cacheParameterGroupName;
    private final String notificationTopicStatus;
    private final Boolean applyImmediately;
    private final String engineVersion;
    private final Boolean autoMinorVersionUpgrade;
    private final Integer snapshotRetentionLimit;
    private final String snapshotWindow;
    private final String cacheNodeType;
    private final String nodeGroupId;

    private ModifyReplicationGroupRequest(BuilderImpl builder) {
        this.replicationGroupId = builder.replicationGroupId;
        this.replicationGroupDescription = builder.replicationGroupDescription;
        this.primaryClusterId = builder.primaryClusterId;
        this.snapshottingClusterId = builder.snapshottingClusterId;
        this.automaticFailoverEnabled = builder.automaticFailoverEnabled;
        this.cacheSecurityGroupNames = builder.cacheSecurityGroupNames;
        this.securityGroupIds = builder.securityGroupIds;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.notificationTopicArn = builder.notificationTopicArn;
        this.cacheParameterGroupName = builder.cacheParameterGroupName;
        this.notificationTopicStatus = builder.notificationTopicStatus;
        this.applyImmediately = builder.applyImmediately;
        this.engineVersion = builder.engineVersion;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.snapshotWindow = builder.snapshotWindow;
        this.cacheNodeType = builder.cacheNodeType;
        this.nodeGroupId = builder.nodeGroupId;
    }

    public String replicationGroupId() {
        return this.replicationGroupId;
    }

    public String replicationGroupDescription() {
        return this.replicationGroupDescription;
    }

    public String primaryClusterId() {
        return this.primaryClusterId;
    }

    public String snapshottingClusterId() {
        return this.snapshottingClusterId;
    }

    public Boolean automaticFailoverEnabled() {
        return this.automaticFailoverEnabled;
    }

    public List<String> cacheSecurityGroupNames() {
        return this.cacheSecurityGroupNames;
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public String notificationTopicArn() {
        return this.notificationTopicArn;
    }

    public String cacheParameterGroupName() {
        return this.cacheParameterGroupName;
    }

    public String notificationTopicStatus() {
        return this.notificationTopicStatus;
    }

    public Boolean applyImmediately() {
        return this.applyImmediately;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public Integer snapshotRetentionLimit() {
        return this.snapshotRetentionLimit;
    }

    public String snapshotWindow() {
        return this.snapshotWindow;
    }

    public String cacheNodeType() {
        return this.cacheNodeType;
    }

    public String nodeGroupId() {
        return this.nodeGroupId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshottingClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.automaticFailoverEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheSecurityGroupNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationTopicStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.applyImmediately());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotRetentionLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeGroupId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyReplicationGroupRequest)) {
            return false;
        }
        ModifyReplicationGroupRequest other = (ModifyReplicationGroupRequest)((Object)obj);
        return Objects.equals(this.replicationGroupId(), other.replicationGroupId()) && Objects.equals(this.replicationGroupDescription(), other.replicationGroupDescription()) && Objects.equals(this.primaryClusterId(), other.primaryClusterId()) && Objects.equals(this.snapshottingClusterId(), other.snapshottingClusterId()) && Objects.equals(this.automaticFailoverEnabled(), other.automaticFailoverEnabled()) && Objects.equals(this.cacheSecurityGroupNames(), other.cacheSecurityGroupNames()) && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.notificationTopicArn(), other.notificationTopicArn()) && Objects.equals(this.cacheParameterGroupName(), other.cacheParameterGroupName()) && Objects.equals(this.notificationTopicStatus(), other.notificationTopicStatus()) && Objects.equals(this.applyImmediately(), other.applyImmediately()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade()) && Objects.equals(this.snapshotRetentionLimit(), other.snapshotRetentionLimit()) && Objects.equals(this.snapshotWindow(), other.snapshotWindow()) && Objects.equals(this.cacheNodeType(), other.cacheNodeType()) && Objects.equals(this.nodeGroupId(), other.nodeGroupId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.replicationGroupId() != null) {
            sb.append("ReplicationGroupId: ").append(this.replicationGroupId()).append(",");
        }
        if (this.replicationGroupDescription() != null) {
            sb.append("ReplicationGroupDescription: ").append(this.replicationGroupDescription()).append(",");
        }
        if (this.primaryClusterId() != null) {
            sb.append("PrimaryClusterId: ").append(this.primaryClusterId()).append(",");
        }
        if (this.snapshottingClusterId() != null) {
            sb.append("SnapshottingClusterId: ").append(this.snapshottingClusterId()).append(",");
        }
        if (this.automaticFailoverEnabled() != null) {
            sb.append("AutomaticFailoverEnabled: ").append(this.automaticFailoverEnabled()).append(",");
        }
        if (this.cacheSecurityGroupNames() != null) {
            sb.append("CacheSecurityGroupNames: ").append(this.cacheSecurityGroupNames()).append(",");
        }
        if (this.securityGroupIds() != null) {
            sb.append("SecurityGroupIds: ").append(this.securityGroupIds()).append(",");
        }
        if (this.preferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: ").append(this.preferredMaintenanceWindow()).append(",");
        }
        if (this.notificationTopicArn() != null) {
            sb.append("NotificationTopicArn: ").append(this.notificationTopicArn()).append(",");
        }
        if (this.cacheParameterGroupName() != null) {
            sb.append("CacheParameterGroupName: ").append(this.cacheParameterGroupName()).append(",");
        }
        if (this.notificationTopicStatus() != null) {
            sb.append("NotificationTopicStatus: ").append(this.notificationTopicStatus()).append(",");
        }
        if (this.applyImmediately() != null) {
            sb.append("ApplyImmediately: ").append(this.applyImmediately()).append(",");
        }
        if (this.engineVersion() != null) {
            sb.append("EngineVersion: ").append(this.engineVersion()).append(",");
        }
        if (this.autoMinorVersionUpgrade() != null) {
            sb.append("AutoMinorVersionUpgrade: ").append(this.autoMinorVersionUpgrade()).append(",");
        }
        if (this.snapshotRetentionLimit() != null) {
            sb.append("SnapshotRetentionLimit: ").append(this.snapshotRetentionLimit()).append(",");
        }
        if (this.snapshotWindow() != null) {
            sb.append("SnapshotWindow: ").append(this.snapshotWindow()).append(",");
        }
        if (this.cacheNodeType() != null) {
            sb.append("CacheNodeType: ").append(this.cacheNodeType()).append(",");
        }
        if (this.nodeGroupId() != null) {
            sb.append("NodeGroupId: ").append(this.nodeGroupId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationGroupId": {
                return Optional.of(clazz.cast(this.replicationGroupId()));
            }
            case "ReplicationGroupDescription": {
                return Optional.of(clazz.cast(this.replicationGroupDescription()));
            }
            case "PrimaryClusterId": {
                return Optional.of(clazz.cast(this.primaryClusterId()));
            }
            case "SnapshottingClusterId": {
                return Optional.of(clazz.cast(this.snapshottingClusterId()));
            }
            case "AutomaticFailoverEnabled": {
                return Optional.of(clazz.cast(this.automaticFailoverEnabled()));
            }
            case "CacheSecurityGroupNames": {
                return Optional.of(clazz.cast(this.cacheSecurityGroupNames()));
            }
            case "SecurityGroupIds": {
                return Optional.of(clazz.cast(this.securityGroupIds()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.of(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "NotificationTopicArn": {
                return Optional.of(clazz.cast(this.notificationTopicArn()));
            }
            case "CacheParameterGroupName": {
                return Optional.of(clazz.cast(this.cacheParameterGroupName()));
            }
            case "NotificationTopicStatus": {
                return Optional.of(clazz.cast(this.notificationTopicStatus()));
            }
            case "ApplyImmediately": {
                return Optional.of(clazz.cast(this.applyImmediately()));
            }
            case "EngineVersion": {
                return Optional.of(clazz.cast(this.engineVersion()));
            }
            case "AutoMinorVersionUpgrade": {
                return Optional.of(clazz.cast(this.autoMinorVersionUpgrade()));
            }
            case "SnapshotRetentionLimit": {
                return Optional.of(clazz.cast(this.snapshotRetentionLimit()));
            }
            case "SnapshotWindow": {
                return Optional.of(clazz.cast(this.snapshotWindow()));
            }
            case "CacheNodeType": {
                return Optional.of(clazz.cast(this.cacheNodeType()));
            }
            case "NodeGroupId": {
                return Optional.of(clazz.cast(this.nodeGroupId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String replicationGroupId;
        private String replicationGroupDescription;
        private String primaryClusterId;
        private String snapshottingClusterId;
        private Boolean automaticFailoverEnabled;
        private List<String> cacheSecurityGroupNames;
        private List<String> securityGroupIds;
        private String preferredMaintenanceWindow;
        private String notificationTopicArn;
        private String cacheParameterGroupName;
        private String notificationTopicStatus;
        private Boolean applyImmediately;
        private String engineVersion;
        private Boolean autoMinorVersionUpgrade;
        private Integer snapshotRetentionLimit;
        private String snapshotWindow;
        private String cacheNodeType;
        private String nodeGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyReplicationGroupRequest model) {
            this.replicationGroupId(model.replicationGroupId);
            this.replicationGroupDescription(model.replicationGroupDescription);
            this.primaryClusterId(model.primaryClusterId);
            this.snapshottingClusterId(model.snapshottingClusterId);
            this.automaticFailoverEnabled(model.automaticFailoverEnabled);
            this.cacheSecurityGroupNames(model.cacheSecurityGroupNames);
            this.securityGroupIds(model.securityGroupIds);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.notificationTopicArn(model.notificationTopicArn);
            this.cacheParameterGroupName(model.cacheParameterGroupName);
            this.notificationTopicStatus(model.notificationTopicStatus);
            this.applyImmediately(model.applyImmediately);
            this.engineVersion(model.engineVersion);
            this.autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.snapshotRetentionLimit(model.snapshotRetentionLimit);
            this.snapshotWindow(model.snapshotWindow);
            this.cacheNodeType(model.cacheNodeType);
            this.nodeGroupId(model.nodeGroupId);
        }

        public final String getReplicationGroupId() {
            return this.replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        public final String getReplicationGroupDescription() {
            return this.replicationGroupDescription;
        }

        @Override
        public final Builder replicationGroupDescription(String replicationGroupDescription) {
            this.replicationGroupDescription = replicationGroupDescription;
            return this;
        }

        public final void setReplicationGroupDescription(String replicationGroupDescription) {
            this.replicationGroupDescription = replicationGroupDescription;
        }

        public final String getPrimaryClusterId() {
            return this.primaryClusterId;
        }

        @Override
        public final Builder primaryClusterId(String primaryClusterId) {
            this.primaryClusterId = primaryClusterId;
            return this;
        }

        public final void setPrimaryClusterId(String primaryClusterId) {
            this.primaryClusterId = primaryClusterId;
        }

        public final String getSnapshottingClusterId() {
            return this.snapshottingClusterId;
        }

        @Override
        public final Builder snapshottingClusterId(String snapshottingClusterId) {
            this.snapshottingClusterId = snapshottingClusterId;
            return this;
        }

        public final void setSnapshottingClusterId(String snapshottingClusterId) {
            this.snapshottingClusterId = snapshottingClusterId;
        }

        public final Boolean getAutomaticFailoverEnabled() {
            return this.automaticFailoverEnabled;
        }

        @Override
        public final Builder automaticFailoverEnabled(Boolean automaticFailoverEnabled) {
            this.automaticFailoverEnabled = automaticFailoverEnabled;
            return this;
        }

        public final void setAutomaticFailoverEnabled(Boolean automaticFailoverEnabled) {
            this.automaticFailoverEnabled = automaticFailoverEnabled;
        }

        public final Collection<String> getCacheSecurityGroupNames() {
            return this.cacheSecurityGroupNames;
        }

        @Override
        public final Builder cacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames = CacheSecurityGroupNameListCopier.copy(cacheSecurityGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheSecurityGroupNames(String ... cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames(Arrays.asList(cacheSecurityGroupNames));
            return this;
        }

        public final void setCacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames = CacheSecurityGroupNameListCopier.copy(cacheSecurityGroupNames);
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final String getNotificationTopicArn() {
            return this.notificationTopicArn;
        }

        @Override
        public final Builder notificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
            return this;
        }

        public final void setNotificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
        }

        public final String getCacheParameterGroupName() {
            return this.cacheParameterGroupName;
        }

        @Override
        public final Builder cacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
            return this;
        }

        public final void setCacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
        }

        public final String getNotificationTopicStatus() {
            return this.notificationTopicStatus;
        }

        @Override
        public final Builder notificationTopicStatus(String notificationTopicStatus) {
            this.notificationTopicStatus = notificationTopicStatus;
            return this;
        }

        public final void setNotificationTopicStatus(String notificationTopicStatus) {
            this.notificationTopicStatus = notificationTopicStatus;
        }

        public final Boolean getApplyImmediately() {
            return this.applyImmediately;
        }

        @Override
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        public final Integer getSnapshotRetentionLimit() {
            return this.snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        public final String getSnapshotWindow() {
            return this.snapshotWindow;
        }

        @Override
        public final Builder snapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
            return this;
        }

        public final void setSnapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
        }

        public final String getCacheNodeType() {
            return this.cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        public final String getNodeGroupId() {
            return this.nodeGroupId;
        }

        @Override
        public final Builder nodeGroupId(String nodeGroupId) {
            this.nodeGroupId = nodeGroupId;
            return this;
        }

        public final void setNodeGroupId(String nodeGroupId) {
            this.nodeGroupId = nodeGroupId;
        }

        public ModifyReplicationGroupRequest build() {
            return new ModifyReplicationGroupRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifyReplicationGroupRequest> {
        public Builder replicationGroupId(String var1);

        public Builder replicationGroupDescription(String var1);

        public Builder primaryClusterId(String var1);

        public Builder snapshottingClusterId(String var1);

        public Builder automaticFailoverEnabled(Boolean var1);

        public Builder cacheSecurityGroupNames(Collection<String> var1);

        public Builder cacheSecurityGroupNames(String ... var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder notificationTopicArn(String var1);

        public Builder cacheParameterGroupName(String var1);

        public Builder notificationTopicStatus(String var1);

        public Builder applyImmediately(Boolean var1);

        public Builder engineVersion(String var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder snapshotRetentionLimit(Integer var1);

        public Builder snapshotWindow(String var1);

        public Builder cacheNodeType(String var1);

        public Builder nodeGroupId(String var1);
    }
}

