/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.elasticache.model.ReservedCacheNodesOffering;
import software.amazon.awssdk.services.elasticache.model.ReservedCacheNodesOfferingListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeReservedCacheNodesOfferingsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeReservedCacheNodesOfferingsResponse> {
    private final String marker;
    private final List<ReservedCacheNodesOffering> reservedCacheNodesOfferings;

    private DescribeReservedCacheNodesOfferingsResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.reservedCacheNodesOfferings = builder.reservedCacheNodesOfferings;
    }

    public String marker() {
        return this.marker;
    }

    public List<ReservedCacheNodesOffering> reservedCacheNodesOfferings() {
        return this.reservedCacheNodesOfferings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedCacheNodesOfferings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedCacheNodesOfferingsResponse)) {
            return false;
        }
        DescribeReservedCacheNodesOfferingsResponse other = (DescribeReservedCacheNodesOfferingsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.reservedCacheNodesOfferings(), other.reservedCacheNodesOfferings());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.reservedCacheNodesOfferings() != null) {
            sb.append("ReservedCacheNodesOfferings: ").append(this.reservedCacheNodesOfferings()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "ReservedCacheNodesOfferings": {
                return Optional.of(clazz.cast(this.reservedCacheNodesOfferings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<ReservedCacheNodesOffering> reservedCacheNodesOfferings;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedCacheNodesOfferingsResponse model) {
            this.marker(model.marker);
            this.reservedCacheNodesOfferings(model.reservedCacheNodesOfferings);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ReservedCacheNodesOffering.Builder> getReservedCacheNodesOfferings() {
            return this.reservedCacheNodesOfferings != null ? (Collection)this.reservedCacheNodesOfferings.stream().map(ReservedCacheNodesOffering::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservedCacheNodesOfferings(Collection<ReservedCacheNodesOffering> reservedCacheNodesOfferings) {
            this.reservedCacheNodesOfferings = ReservedCacheNodesOfferingListCopier.copy(reservedCacheNodesOfferings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedCacheNodesOfferings(ReservedCacheNodesOffering ... reservedCacheNodesOfferings) {
            this.reservedCacheNodesOfferings(Arrays.asList(reservedCacheNodesOfferings));
            return this;
        }

        public final void setReservedCacheNodesOfferings(Collection<ReservedCacheNodesOffering.BuilderImpl> reservedCacheNodesOfferings) {
            this.reservedCacheNodesOfferings = ReservedCacheNodesOfferingListCopier.copyFromBuilder(reservedCacheNodesOfferings);
        }

        public DescribeReservedCacheNodesOfferingsResponse build() {
            return new DescribeReservedCacheNodesOfferingsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeReservedCacheNodesOfferingsResponse> {
        public Builder marker(String var1);

        public Builder reservedCacheNodesOfferings(Collection<ReservedCacheNodesOffering> var1);

        public Builder reservedCacheNodesOfferings(ReservedCacheNodesOffering ... var1);
    }
}

