/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.elasticache.model.Endpoint;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CacheNode
implements ToCopyableBuilder<Builder, CacheNode> {
    private final String cacheNodeId;
    private final String cacheNodeStatus;
    private final Instant cacheNodeCreateTime;
    private final Endpoint endpoint;
    private final String parameterGroupStatus;
    private final String sourceCacheNodeId;
    private final String customerAvailabilityZone;

    private CacheNode(BuilderImpl builder) {
        this.cacheNodeId = builder.cacheNodeId;
        this.cacheNodeStatus = builder.cacheNodeStatus;
        this.cacheNodeCreateTime = builder.cacheNodeCreateTime;
        this.endpoint = builder.endpoint;
        this.parameterGroupStatus = builder.parameterGroupStatus;
        this.sourceCacheNodeId = builder.sourceCacheNodeId;
        this.customerAvailabilityZone = builder.customerAvailabilityZone;
    }

    public String cacheNodeId() {
        return this.cacheNodeId;
    }

    public String cacheNodeStatus() {
        return this.cacheNodeStatus;
    }

    public Instant cacheNodeCreateTime() {
        return this.cacheNodeCreateTime;
    }

    public Endpoint endpoint() {
        return this.endpoint;
    }

    public String parameterGroupStatus() {
        return this.parameterGroupStatus;
    }

    public String sourceCacheNodeId() {
        return this.sourceCacheNodeId;
    }

    public String customerAvailabilityZone() {
        return this.customerAvailabilityZone;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNodeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNodeStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNodeCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterGroupStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCacheNodeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerAvailabilityZone());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheNode)) {
            return false;
        }
        CacheNode other = (CacheNode)obj;
        return Objects.equals(this.cacheNodeId(), other.cacheNodeId()) && Objects.equals(this.cacheNodeStatus(), other.cacheNodeStatus()) && Objects.equals(this.cacheNodeCreateTime(), other.cacheNodeCreateTime()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.parameterGroupStatus(), other.parameterGroupStatus()) && Objects.equals(this.sourceCacheNodeId(), other.sourceCacheNodeId()) && Objects.equals(this.customerAvailabilityZone(), other.customerAvailabilityZone());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.cacheNodeId() != null) {
            sb.append("CacheNodeId: ").append(this.cacheNodeId()).append(",");
        }
        if (this.cacheNodeStatus() != null) {
            sb.append("CacheNodeStatus: ").append(this.cacheNodeStatus()).append(",");
        }
        if (this.cacheNodeCreateTime() != null) {
            sb.append("CacheNodeCreateTime: ").append(this.cacheNodeCreateTime()).append(",");
        }
        if (this.endpoint() != null) {
            sb.append("Endpoint: ").append(this.endpoint()).append(",");
        }
        if (this.parameterGroupStatus() != null) {
            sb.append("ParameterGroupStatus: ").append(this.parameterGroupStatus()).append(",");
        }
        if (this.sourceCacheNodeId() != null) {
            sb.append("SourceCacheNodeId: ").append(this.sourceCacheNodeId()).append(",");
        }
        if (this.customerAvailabilityZone() != null) {
            sb.append("CustomerAvailabilityZone: ").append(this.customerAvailabilityZone()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CacheNodeId": {
                return Optional.of(clazz.cast(this.cacheNodeId()));
            }
            case "CacheNodeStatus": {
                return Optional.of(clazz.cast(this.cacheNodeStatus()));
            }
            case "CacheNodeCreateTime": {
                return Optional.of(clazz.cast(this.cacheNodeCreateTime()));
            }
            case "Endpoint": {
                return Optional.of(clazz.cast(this.endpoint()));
            }
            case "ParameterGroupStatus": {
                return Optional.of(clazz.cast(this.parameterGroupStatus()));
            }
            case "SourceCacheNodeId": {
                return Optional.of(clazz.cast(this.sourceCacheNodeId()));
            }
            case "CustomerAvailabilityZone": {
                return Optional.of(clazz.cast(this.customerAvailabilityZone()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String cacheNodeId;
        private String cacheNodeStatus;
        private Instant cacheNodeCreateTime;
        private Endpoint endpoint;
        private String parameterGroupStatus;
        private String sourceCacheNodeId;
        private String customerAvailabilityZone;

        private BuilderImpl() {
        }

        private BuilderImpl(CacheNode model) {
            this.cacheNodeId(model.cacheNodeId);
            this.cacheNodeStatus(model.cacheNodeStatus);
            this.cacheNodeCreateTime(model.cacheNodeCreateTime);
            this.endpoint(model.endpoint);
            this.parameterGroupStatus(model.parameterGroupStatus);
            this.sourceCacheNodeId(model.sourceCacheNodeId);
            this.customerAvailabilityZone(model.customerAvailabilityZone);
        }

        public final String getCacheNodeId() {
            return this.cacheNodeId;
        }

        @Override
        public final Builder cacheNodeId(String cacheNodeId) {
            this.cacheNodeId = cacheNodeId;
            return this;
        }

        public final void setCacheNodeId(String cacheNodeId) {
            this.cacheNodeId = cacheNodeId;
        }

        public final String getCacheNodeStatus() {
            return this.cacheNodeStatus;
        }

        @Override
        public final Builder cacheNodeStatus(String cacheNodeStatus) {
            this.cacheNodeStatus = cacheNodeStatus;
            return this;
        }

        public final void setCacheNodeStatus(String cacheNodeStatus) {
            this.cacheNodeStatus = cacheNodeStatus;
        }

        public final Instant getCacheNodeCreateTime() {
            return this.cacheNodeCreateTime;
        }

        @Override
        public final Builder cacheNodeCreateTime(Instant cacheNodeCreateTime) {
            this.cacheNodeCreateTime = cacheNodeCreateTime;
            return this;
        }

        public final void setCacheNodeCreateTime(Instant cacheNodeCreateTime) {
            this.cacheNodeCreateTime = cacheNodeCreateTime;
        }

        public final Endpoint.Builder getEndpoint() {
            return this.endpoint != null ? this.endpoint.toBuilder() : null;
        }

        @Override
        public final Builder endpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(Endpoint.BuilderImpl endpoint) {
            this.endpoint = endpoint != null ? endpoint.build() : null;
        }

        public final String getParameterGroupStatus() {
            return this.parameterGroupStatus;
        }

        @Override
        public final Builder parameterGroupStatus(String parameterGroupStatus) {
            this.parameterGroupStatus = parameterGroupStatus;
            return this;
        }

        public final void setParameterGroupStatus(String parameterGroupStatus) {
            this.parameterGroupStatus = parameterGroupStatus;
        }

        public final String getSourceCacheNodeId() {
            return this.sourceCacheNodeId;
        }

        @Override
        public final Builder sourceCacheNodeId(String sourceCacheNodeId) {
            this.sourceCacheNodeId = sourceCacheNodeId;
            return this;
        }

        public final void setSourceCacheNodeId(String sourceCacheNodeId) {
            this.sourceCacheNodeId = sourceCacheNodeId;
        }

        public final String getCustomerAvailabilityZone() {
            return this.customerAvailabilityZone;
        }

        @Override
        public final Builder customerAvailabilityZone(String customerAvailabilityZone) {
            this.customerAvailabilityZone = customerAvailabilityZone;
            return this;
        }

        public final void setCustomerAvailabilityZone(String customerAvailabilityZone) {
            this.customerAvailabilityZone = customerAvailabilityZone;
        }

        public CacheNode build() {
            return new CacheNode(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CacheNode> {
        public Builder cacheNodeId(String var1);

        public Builder cacheNodeStatus(String var1);

        public Builder cacheNodeCreateTime(Instant var1);

        public Builder endpoint(Endpoint var1);

        default public Builder endpoint(Consumer<Endpoint.Builder> endpoint) {
            return this.endpoint((Endpoint)((Endpoint.Builder)Endpoint.builder().apply(endpoint)).build());
        }

        public Builder parameterGroupStatus(String var1);

        public Builder sourceCacheNodeId(String var1);

        public Builder customerAvailabilityZone(String var1);
    }
}

