/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.services.elasticache.model.NodeGroupConfiguration;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class NodeSnapshot
implements ToCopyableBuilder<Builder, NodeSnapshot> {
    private final String cacheClusterId;
    private final String nodeGroupId;
    private final String cacheNodeId;
    private final NodeGroupConfiguration nodeGroupConfiguration;
    private final String cacheSize;
    private final Instant cacheNodeCreateTime;
    private final Instant snapshotCreateTime;

    private NodeSnapshot(BuilderImpl builder) {
        this.cacheClusterId = builder.cacheClusterId;
        this.nodeGroupId = builder.nodeGroupId;
        this.cacheNodeId = builder.cacheNodeId;
        this.nodeGroupConfiguration = builder.nodeGroupConfiguration;
        this.cacheSize = builder.cacheSize;
        this.cacheNodeCreateTime = builder.cacheNodeCreateTime;
        this.snapshotCreateTime = builder.snapshotCreateTime;
    }

    public String cacheClusterId() {
        return this.cacheClusterId;
    }

    public String nodeGroupId() {
        return this.nodeGroupId;
    }

    public String cacheNodeId() {
        return this.cacheNodeId;
    }

    public NodeGroupConfiguration nodeGroupConfiguration() {
        return this.nodeGroupConfiguration;
    }

    public String cacheSize() {
        return this.cacheSize;
    }

    public Instant cacheNodeCreateTime() {
        return this.cacheNodeCreateTime;
    }

    public Instant snapshotCreateTime() {
        return this.snapshotCreateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.cacheClusterId() == null ? 0 : this.cacheClusterId().hashCode());
        hashCode = 31 * hashCode + (this.nodeGroupId() == null ? 0 : this.nodeGroupId().hashCode());
        hashCode = 31 * hashCode + (this.cacheNodeId() == null ? 0 : this.cacheNodeId().hashCode());
        hashCode = 31 * hashCode + (this.nodeGroupConfiguration() == null ? 0 : this.nodeGroupConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.cacheSize() == null ? 0 : this.cacheSize().hashCode());
        hashCode = 31 * hashCode + (this.cacheNodeCreateTime() == null ? 0 : this.cacheNodeCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.snapshotCreateTime() == null ? 0 : this.snapshotCreateTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeSnapshot)) {
            return false;
        }
        NodeSnapshot other = (NodeSnapshot)obj;
        if (other.cacheClusterId() == null ^ this.cacheClusterId() == null) {
            return false;
        }
        if (other.cacheClusterId() != null && !other.cacheClusterId().equals(this.cacheClusterId())) {
            return false;
        }
        if (other.nodeGroupId() == null ^ this.nodeGroupId() == null) {
            return false;
        }
        if (other.nodeGroupId() != null && !other.nodeGroupId().equals(this.nodeGroupId())) {
            return false;
        }
        if (other.cacheNodeId() == null ^ this.cacheNodeId() == null) {
            return false;
        }
        if (other.cacheNodeId() != null && !other.cacheNodeId().equals(this.cacheNodeId())) {
            return false;
        }
        if (other.nodeGroupConfiguration() == null ^ this.nodeGroupConfiguration() == null) {
            return false;
        }
        if (other.nodeGroupConfiguration() != null && !other.nodeGroupConfiguration().equals(this.nodeGroupConfiguration())) {
            return false;
        }
        if (other.cacheSize() == null ^ this.cacheSize() == null) {
            return false;
        }
        if (other.cacheSize() != null && !other.cacheSize().equals(this.cacheSize())) {
            return false;
        }
        if (other.cacheNodeCreateTime() == null ^ this.cacheNodeCreateTime() == null) {
            return false;
        }
        if (other.cacheNodeCreateTime() != null && !other.cacheNodeCreateTime().equals(this.cacheNodeCreateTime())) {
            return false;
        }
        if (other.snapshotCreateTime() == null ^ this.snapshotCreateTime() == null) {
            return false;
        }
        return other.snapshotCreateTime() == null || other.snapshotCreateTime().equals(this.snapshotCreateTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.cacheClusterId() != null) {
            sb.append("CacheClusterId: ").append(this.cacheClusterId()).append(",");
        }
        if (this.nodeGroupId() != null) {
            sb.append("NodeGroupId: ").append(this.nodeGroupId()).append(",");
        }
        if (this.cacheNodeId() != null) {
            sb.append("CacheNodeId: ").append(this.cacheNodeId()).append(",");
        }
        if (this.nodeGroupConfiguration() != null) {
            sb.append("NodeGroupConfiguration: ").append(this.nodeGroupConfiguration()).append(",");
        }
        if (this.cacheSize() != null) {
            sb.append("CacheSize: ").append(this.cacheSize()).append(",");
        }
        if (this.cacheNodeCreateTime() != null) {
            sb.append("CacheNodeCreateTime: ").append(this.cacheNodeCreateTime()).append(",");
        }
        if (this.snapshotCreateTime() != null) {
            sb.append("SnapshotCreateTime: ").append(this.snapshotCreateTime()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CacheClusterId": {
                return Optional.of(clazz.cast(this.cacheClusterId()));
            }
            case "NodeGroupId": {
                return Optional.of(clazz.cast(this.nodeGroupId()));
            }
            case "CacheNodeId": {
                return Optional.of(clazz.cast(this.cacheNodeId()));
            }
            case "NodeGroupConfiguration": {
                return Optional.of(clazz.cast(this.nodeGroupConfiguration()));
            }
            case "CacheSize": {
                return Optional.of(clazz.cast(this.cacheSize()));
            }
            case "CacheNodeCreateTime": {
                return Optional.of(clazz.cast(this.cacheNodeCreateTime()));
            }
            case "SnapshotCreateTime": {
                return Optional.of(clazz.cast(this.snapshotCreateTime()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String cacheClusterId;
        private String nodeGroupId;
        private String cacheNodeId;
        private NodeGroupConfiguration nodeGroupConfiguration;
        private String cacheSize;
        private Instant cacheNodeCreateTime;
        private Instant snapshotCreateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeSnapshot model) {
            this.cacheClusterId(model.cacheClusterId);
            this.nodeGroupId(model.nodeGroupId);
            this.cacheNodeId(model.cacheNodeId);
            this.nodeGroupConfiguration(model.nodeGroupConfiguration);
            this.cacheSize(model.cacheSize);
            this.cacheNodeCreateTime(model.cacheNodeCreateTime);
            this.snapshotCreateTime(model.snapshotCreateTime);
        }

        public final String getCacheClusterId() {
            return this.cacheClusterId;
        }

        @Override
        public final Builder cacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
            return this;
        }

        public final void setCacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
        }

        public final String getNodeGroupId() {
            return this.nodeGroupId;
        }

        @Override
        public final Builder nodeGroupId(String nodeGroupId) {
            this.nodeGroupId = nodeGroupId;
            return this;
        }

        public final void setNodeGroupId(String nodeGroupId) {
            this.nodeGroupId = nodeGroupId;
        }

        public final String getCacheNodeId() {
            return this.cacheNodeId;
        }

        @Override
        public final Builder cacheNodeId(String cacheNodeId) {
            this.cacheNodeId = cacheNodeId;
            return this;
        }

        public final void setCacheNodeId(String cacheNodeId) {
            this.cacheNodeId = cacheNodeId;
        }

        public final NodeGroupConfiguration.Builder getNodeGroupConfiguration() {
            return this.nodeGroupConfiguration != null ? this.nodeGroupConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder nodeGroupConfiguration(NodeGroupConfiguration nodeGroupConfiguration) {
            this.nodeGroupConfiguration = nodeGroupConfiguration;
            return this;
        }

        public final void setNodeGroupConfiguration(NodeGroupConfiguration.BuilderImpl nodeGroupConfiguration) {
            this.nodeGroupConfiguration = nodeGroupConfiguration != null ? nodeGroupConfiguration.build() : null;
        }

        public final String getCacheSize() {
            return this.cacheSize;
        }

        @Override
        public final Builder cacheSize(String cacheSize) {
            this.cacheSize = cacheSize;
            return this;
        }

        public final void setCacheSize(String cacheSize) {
            this.cacheSize = cacheSize;
        }

        public final Instant getCacheNodeCreateTime() {
            return this.cacheNodeCreateTime;
        }

        @Override
        public final Builder cacheNodeCreateTime(Instant cacheNodeCreateTime) {
            this.cacheNodeCreateTime = cacheNodeCreateTime;
            return this;
        }

        public final void setCacheNodeCreateTime(Instant cacheNodeCreateTime) {
            this.cacheNodeCreateTime = cacheNodeCreateTime;
        }

        public final Instant getSnapshotCreateTime() {
            return this.snapshotCreateTime;
        }

        @Override
        public final Builder snapshotCreateTime(Instant snapshotCreateTime) {
            this.snapshotCreateTime = snapshotCreateTime;
            return this;
        }

        public final void setSnapshotCreateTime(Instant snapshotCreateTime) {
            this.snapshotCreateTime = snapshotCreateTime;
        }

        public NodeSnapshot build() {
            return new NodeSnapshot(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NodeSnapshot> {
        public Builder cacheClusterId(String var1);

        public Builder nodeGroupId(String var1);

        public Builder cacheNodeId(String var1);

        public Builder nodeGroupConfiguration(NodeGroupConfiguration var1);

        public Builder cacheSize(String var1);

        public Builder cacheNodeCreateTime(Instant var1);

        public Builder snapshotCreateTime(Instant var1);
    }
}

