/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.elasticache.model.Endpoint;
import software.amazon.awssdk.services.elasticache.model.NodeGroupMember;
import software.amazon.awssdk.services.elasticache.model.NodeGroupMemberListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class NodeGroup
implements ToCopyableBuilder<Builder, NodeGroup> {
    private final String nodeGroupId;
    private final String status;
    private final Endpoint primaryEndpoint;
    private final String slots;
    private final List<NodeGroupMember> nodeGroupMembers;

    private NodeGroup(BuilderImpl builder) {
        this.nodeGroupId = builder.nodeGroupId;
        this.status = builder.status;
        this.primaryEndpoint = builder.primaryEndpoint;
        this.slots = builder.slots;
        this.nodeGroupMembers = builder.nodeGroupMembers;
    }

    public String nodeGroupId() {
        return this.nodeGroupId;
    }

    public String status() {
        return this.status;
    }

    public Endpoint primaryEndpoint() {
        return this.primaryEndpoint;
    }

    public String slots() {
        return this.slots;
    }

    public List<NodeGroupMember> nodeGroupMembers() {
        return this.nodeGroupMembers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nodeGroupId() == null ? 0 : this.nodeGroupId().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.primaryEndpoint() == null ? 0 : this.primaryEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.slots() == null ? 0 : this.slots().hashCode());
        hashCode = 31 * hashCode + (this.nodeGroupMembers() == null ? 0 : this.nodeGroupMembers().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeGroup)) {
            return false;
        }
        NodeGroup other = (NodeGroup)obj;
        if (other.nodeGroupId() == null ^ this.nodeGroupId() == null) {
            return false;
        }
        if (other.nodeGroupId() != null && !other.nodeGroupId().equals(this.nodeGroupId())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.primaryEndpoint() == null ^ this.primaryEndpoint() == null) {
            return false;
        }
        if (other.primaryEndpoint() != null && !other.primaryEndpoint().equals(this.primaryEndpoint())) {
            return false;
        }
        if (other.slots() == null ^ this.slots() == null) {
            return false;
        }
        if (other.slots() != null && !other.slots().equals(this.slots())) {
            return false;
        }
        if (other.nodeGroupMembers() == null ^ this.nodeGroupMembers() == null) {
            return false;
        }
        return other.nodeGroupMembers() == null || other.nodeGroupMembers().equals(this.nodeGroupMembers());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.nodeGroupId() != null) {
            sb.append("NodeGroupId: ").append(this.nodeGroupId()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.primaryEndpoint() != null) {
            sb.append("PrimaryEndpoint: ").append(this.primaryEndpoint()).append(",");
        }
        if (this.slots() != null) {
            sb.append("Slots: ").append(this.slots()).append(",");
        }
        if (this.nodeGroupMembers() != null) {
            sb.append("NodeGroupMembers: ").append(this.nodeGroupMembers()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NodeGroupId": {
                return Optional.of(clazz.cast(this.nodeGroupId()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "PrimaryEndpoint": {
                return Optional.of(clazz.cast(this.primaryEndpoint()));
            }
            case "Slots": {
                return Optional.of(clazz.cast(this.slots()));
            }
            case "NodeGroupMembers": {
                return Optional.of(clazz.cast(this.nodeGroupMembers()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String nodeGroupId;
        private String status;
        private Endpoint primaryEndpoint;
        private String slots;
        private List<NodeGroupMember> nodeGroupMembers;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeGroup model) {
            this.nodeGroupId(model.nodeGroupId);
            this.status(model.status);
            this.primaryEndpoint(model.primaryEndpoint);
            this.slots(model.slots);
            this.nodeGroupMembers(model.nodeGroupMembers);
        }

        public final String getNodeGroupId() {
            return this.nodeGroupId;
        }

        @Override
        public final Builder nodeGroupId(String nodeGroupId) {
            this.nodeGroupId = nodeGroupId;
            return this;
        }

        public final void setNodeGroupId(String nodeGroupId) {
            this.nodeGroupId = nodeGroupId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Endpoint.Builder getPrimaryEndpoint() {
            return this.primaryEndpoint != null ? this.primaryEndpoint.toBuilder() : null;
        }

        @Override
        public final Builder primaryEndpoint(Endpoint primaryEndpoint) {
            this.primaryEndpoint = primaryEndpoint;
            return this;
        }

        public final void setPrimaryEndpoint(Endpoint.BuilderImpl primaryEndpoint) {
            this.primaryEndpoint = primaryEndpoint != null ? primaryEndpoint.build() : null;
        }

        public final String getSlots() {
            return this.slots;
        }

        @Override
        public final Builder slots(String slots) {
            this.slots = slots;
            return this;
        }

        public final void setSlots(String slots) {
            this.slots = slots;
        }

        public final Collection<NodeGroupMember.Builder> getNodeGroupMembers() {
            return this.nodeGroupMembers != null ? (Collection)this.nodeGroupMembers.stream().map(NodeGroupMember::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder nodeGroupMembers(Collection<NodeGroupMember> nodeGroupMembers) {
            this.nodeGroupMembers = NodeGroupMemberListCopier.copy(nodeGroupMembers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeGroupMembers(NodeGroupMember ... nodeGroupMembers) {
            this.nodeGroupMembers(Arrays.asList(nodeGroupMembers));
            return this;
        }

        public final void setNodeGroupMembers(Collection<NodeGroupMember.BuilderImpl> nodeGroupMembers) {
            this.nodeGroupMembers = NodeGroupMemberListCopier.copyFromBuilder(nodeGroupMembers);
        }

        public NodeGroup build() {
            return new NodeGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NodeGroup> {
        public Builder nodeGroupId(String var1);

        public Builder status(String var1);

        public Builder primaryEndpoint(Endpoint var1);

        public Builder slots(String var1);

        public Builder nodeGroupMembers(Collection<NodeGroupMember> var1);

        public Builder nodeGroupMembers(NodeGroupMember ... var1);
    }
}

