/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.elasticache.model.CacheNodeTypeSpecificParameter;
import software.amazon.awssdk.services.elasticache.model.CacheNodeTypeSpecificParametersListCopier;
import software.amazon.awssdk.services.elasticache.model.Parameter;
import software.amazon.awssdk.services.elasticache.model.ParametersListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeCacheParametersResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeCacheParametersResponse> {
    private final String marker;
    private final List<Parameter> parameters;
    private final List<CacheNodeTypeSpecificParameter> cacheNodeTypeSpecificParameters;

    private DescribeCacheParametersResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.parameters = builder.parameters;
        this.cacheNodeTypeSpecificParameters = builder.cacheNodeTypeSpecificParameters;
    }

    public String marker() {
        return this.marker;
    }

    public List<Parameter> parameters() {
        return this.parameters;
    }

    public List<CacheNodeTypeSpecificParameter> cacheNodeTypeSpecificParameters() {
        return this.cacheNodeTypeSpecificParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.parameters() == null ? 0 : this.parameters().hashCode());
        hashCode = 31 * hashCode + (this.cacheNodeTypeSpecificParameters() == null ? 0 : this.cacheNodeTypeSpecificParameters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCacheParametersResponse)) {
            return false;
        }
        DescribeCacheParametersResponse other = (DescribeCacheParametersResponse)((Object)obj);
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.cacheNodeTypeSpecificParameters() == null ^ this.cacheNodeTypeSpecificParameters() == null) {
            return false;
        }
        return other.cacheNodeTypeSpecificParameters() == null || other.cacheNodeTypeSpecificParameters().equals(this.cacheNodeTypeSpecificParameters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        if (this.cacheNodeTypeSpecificParameters() != null) {
            sb.append("CacheNodeTypeSpecificParameters: ").append(this.cacheNodeTypeSpecificParameters()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "Parameters": {
                return Optional.of(clazz.cast(this.parameters()));
            }
            case "CacheNodeTypeSpecificParameters": {
                return Optional.of(clazz.cast(this.cacheNodeTypeSpecificParameters()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<Parameter> parameters;
        private List<CacheNodeTypeSpecificParameter> cacheNodeTypeSpecificParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCacheParametersResponse model) {
            this.marker(model.marker);
            this.parameters(model.parameters);
            this.cacheNodeTypeSpecificParameters(model.cacheNodeTypeSpecificParameters);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<Parameter.Builder> getParameters() {
            return this.parameters != null ? (Collection)this.parameters.stream().map(Parameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        public final void setParameters(Collection<Parameter.BuilderImpl> parameters) {
            this.parameters = ParametersListCopier.copyFromBuilder(parameters);
        }

        public final Collection<CacheNodeTypeSpecificParameter.Builder> getCacheNodeTypeSpecificParameters() {
            return this.cacheNodeTypeSpecificParameters != null ? (Collection)this.cacheNodeTypeSpecificParameters.stream().map(CacheNodeTypeSpecificParameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cacheNodeTypeSpecificParameters(Collection<CacheNodeTypeSpecificParameter> cacheNodeTypeSpecificParameters) {
            this.cacheNodeTypeSpecificParameters = CacheNodeTypeSpecificParametersListCopier.copy(cacheNodeTypeSpecificParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheNodeTypeSpecificParameters(CacheNodeTypeSpecificParameter ... cacheNodeTypeSpecificParameters) {
            this.cacheNodeTypeSpecificParameters(Arrays.asList(cacheNodeTypeSpecificParameters));
            return this;
        }

        public final void setCacheNodeTypeSpecificParameters(Collection<CacheNodeTypeSpecificParameter.BuilderImpl> cacheNodeTypeSpecificParameters) {
            this.cacheNodeTypeSpecificParameters = CacheNodeTypeSpecificParametersListCopier.copyFromBuilder(cacheNodeTypeSpecificParameters);
        }

        public DescribeCacheParametersResponse build() {
            return new DescribeCacheParametersResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeCacheParametersResponse> {
        public Builder marker(String var1);

        public Builder parameters(Collection<Parameter> var1);

        public Builder parameters(Parameter ... var1);

        public Builder cacheNodeTypeSpecificParameters(Collection<CacheNodeTypeSpecificParameter> var1);

        public Builder cacheNodeTypeSpecificParameters(CacheNodeTypeSpecificParameter ... var1);
    }
}

