/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.services.elasticache.model.CacheNodeIdsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CacheParameterGroupStatus
implements ToCopyableBuilder<Builder, CacheParameterGroupStatus> {
    private final String cacheParameterGroupName;
    private final String parameterApplyStatus;
    private final List<String> cacheNodeIdsToReboot;

    private CacheParameterGroupStatus(BuilderImpl builder) {
        this.cacheParameterGroupName = builder.cacheParameterGroupName;
        this.parameterApplyStatus = builder.parameterApplyStatus;
        this.cacheNodeIdsToReboot = builder.cacheNodeIdsToReboot;
    }

    public String cacheParameterGroupName() {
        return this.cacheParameterGroupName;
    }

    public String parameterApplyStatus() {
        return this.parameterApplyStatus;
    }

    public List<String> cacheNodeIdsToReboot() {
        return this.cacheNodeIdsToReboot;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.cacheParameterGroupName() == null ? 0 : this.cacheParameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.parameterApplyStatus() == null ? 0 : this.parameterApplyStatus().hashCode());
        hashCode = 31 * hashCode + (this.cacheNodeIdsToReboot() == null ? 0 : this.cacheNodeIdsToReboot().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheParameterGroupStatus)) {
            return false;
        }
        CacheParameterGroupStatus other = (CacheParameterGroupStatus)obj;
        if (other.cacheParameterGroupName() == null ^ this.cacheParameterGroupName() == null) {
            return false;
        }
        if (other.cacheParameterGroupName() != null && !other.cacheParameterGroupName().equals(this.cacheParameterGroupName())) {
            return false;
        }
        if (other.parameterApplyStatus() == null ^ this.parameterApplyStatus() == null) {
            return false;
        }
        if (other.parameterApplyStatus() != null && !other.parameterApplyStatus().equals(this.parameterApplyStatus())) {
            return false;
        }
        if (other.cacheNodeIdsToReboot() == null ^ this.cacheNodeIdsToReboot() == null) {
            return false;
        }
        return other.cacheNodeIdsToReboot() == null || other.cacheNodeIdsToReboot().equals(this.cacheNodeIdsToReboot());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.cacheParameterGroupName() != null) {
            sb.append("CacheParameterGroupName: ").append(this.cacheParameterGroupName()).append(",");
        }
        if (this.parameterApplyStatus() != null) {
            sb.append("ParameterApplyStatus: ").append(this.parameterApplyStatus()).append(",");
        }
        if (this.cacheNodeIdsToReboot() != null) {
            sb.append("CacheNodeIdsToReboot: ").append(this.cacheNodeIdsToReboot()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CacheParameterGroupName": {
                return Optional.of(clazz.cast(this.cacheParameterGroupName()));
            }
            case "ParameterApplyStatus": {
                return Optional.of(clazz.cast(this.parameterApplyStatus()));
            }
            case "CacheNodeIdsToReboot": {
                return Optional.of(clazz.cast(this.cacheNodeIdsToReboot()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String cacheParameterGroupName;
        private String parameterApplyStatus;
        private List<String> cacheNodeIdsToReboot;

        private BuilderImpl() {
        }

        private BuilderImpl(CacheParameterGroupStatus model) {
            this.cacheParameterGroupName(model.cacheParameterGroupName);
            this.parameterApplyStatus(model.parameterApplyStatus);
            this.cacheNodeIdsToReboot(model.cacheNodeIdsToReboot);
        }

        public final String getCacheParameterGroupName() {
            return this.cacheParameterGroupName;
        }

        @Override
        public final Builder cacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
            return this;
        }

        public final void setCacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
        }

        public final String getParameterApplyStatus() {
            return this.parameterApplyStatus;
        }

        @Override
        public final Builder parameterApplyStatus(String parameterApplyStatus) {
            this.parameterApplyStatus = parameterApplyStatus;
            return this;
        }

        public final void setParameterApplyStatus(String parameterApplyStatus) {
            this.parameterApplyStatus = parameterApplyStatus;
        }

        public final Collection<String> getCacheNodeIdsToReboot() {
            return this.cacheNodeIdsToReboot;
        }

        @Override
        public final Builder cacheNodeIdsToReboot(Collection<String> cacheNodeIdsToReboot) {
            this.cacheNodeIdsToReboot = CacheNodeIdsListCopier.copy(cacheNodeIdsToReboot);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheNodeIdsToReboot(String ... cacheNodeIdsToReboot) {
            this.cacheNodeIdsToReboot(Arrays.asList(cacheNodeIdsToReboot));
            return this;
        }

        public final void setCacheNodeIdsToReboot(Collection<String> cacheNodeIdsToReboot) {
            this.cacheNodeIdsToReboot = CacheNodeIdsListCopier.copy(cacheNodeIdsToReboot);
        }

        public CacheParameterGroupStatus build() {
            return new CacheParameterGroupStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CacheParameterGroupStatus> {
        public Builder cacheParameterGroupName(String var1);

        public Builder parameterApplyStatus(String var1);

        public Builder cacheNodeIdsToReboot(Collection<String> var1);

        public Builder cacheNodeIdsToReboot(String ... var1);
    }
}

