/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeCacheParametersRequestMarshaller
implements Marshaller<Request<DescribeCacheParametersRequest>, DescribeCacheParametersRequest> {
    public Request<DescribeCacheParametersRequest> marshall(DescribeCacheParametersRequest describeCacheParametersRequest) {
        if (describeCacheParametersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeCacheParametersRequest, "ElastiCacheClient");
        request.addParameter("Action", "DescribeCacheParameters");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeCacheParametersRequest.cacheParameterGroupName() != null) {
            request.addParameter("CacheParameterGroupName", StringUtils.fromString((String)describeCacheParametersRequest.cacheParameterGroupName()));
        }
        if (describeCacheParametersRequest.source() != null) {
            request.addParameter("Source", StringUtils.fromString((String)describeCacheParametersRequest.source()));
        }
        if (describeCacheParametersRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeCacheParametersRequest.maxRecords()));
        }
        if (describeCacheParametersRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeCacheParametersRequest.marker()));
        }
        return request;
    }
}

