/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.elasticache.model.AutomaticFailoverStatus;
import software.amazon.awssdk.services.elasticache.model.NodeSnapshot;
import software.amazon.awssdk.services.elasticache.model.NodeSnapshotListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Snapshot
implements ToCopyableBuilder<Builder, Snapshot> {
    private final String snapshotName;
    private final String replicationGroupId;
    private final String replicationGroupDescription;
    private final String cacheClusterId;
    private final String snapshotStatus;
    private final String snapshotSource;
    private final String cacheNodeType;
    private final String engine;
    private final String engineVersion;
    private final Integer numCacheNodes;
    private final String preferredAvailabilityZone;
    private final Instant cacheClusterCreateTime;
    private final String preferredMaintenanceWindow;
    private final String topicArn;
    private final Integer port;
    private final String cacheParameterGroupName;
    private final String cacheSubnetGroupName;
    private final String vpcId;
    private final Boolean autoMinorVersionUpgrade;
    private final Integer snapshotRetentionLimit;
    private final String snapshotWindow;
    private final Integer numNodeGroups;
    private final String automaticFailover;
    private final List<NodeSnapshot> nodeSnapshots;

    private Snapshot(BuilderImpl builder) {
        this.snapshotName = builder.snapshotName;
        this.replicationGroupId = builder.replicationGroupId;
        this.replicationGroupDescription = builder.replicationGroupDescription;
        this.cacheClusterId = builder.cacheClusterId;
        this.snapshotStatus = builder.snapshotStatus;
        this.snapshotSource = builder.snapshotSource;
        this.cacheNodeType = builder.cacheNodeType;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.numCacheNodes = builder.numCacheNodes;
        this.preferredAvailabilityZone = builder.preferredAvailabilityZone;
        this.cacheClusterCreateTime = builder.cacheClusterCreateTime;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.topicArn = builder.topicArn;
        this.port = builder.port;
        this.cacheParameterGroupName = builder.cacheParameterGroupName;
        this.cacheSubnetGroupName = builder.cacheSubnetGroupName;
        this.vpcId = builder.vpcId;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.snapshotWindow = builder.snapshotWindow;
        this.numNodeGroups = builder.numNodeGroups;
        this.automaticFailover = builder.automaticFailover;
        this.nodeSnapshots = builder.nodeSnapshots;
    }

    public String snapshotName() {
        return this.snapshotName;
    }

    public String replicationGroupId() {
        return this.replicationGroupId;
    }

    public String replicationGroupDescription() {
        return this.replicationGroupDescription;
    }

    public String cacheClusterId() {
        return this.cacheClusterId;
    }

    public String snapshotStatus() {
        return this.snapshotStatus;
    }

    public String snapshotSource() {
        return this.snapshotSource;
    }

    public String cacheNodeType() {
        return this.cacheNodeType;
    }

    public String engine() {
        return this.engine;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public Integer numCacheNodes() {
        return this.numCacheNodes;
    }

    public String preferredAvailabilityZone() {
        return this.preferredAvailabilityZone;
    }

    public Instant cacheClusterCreateTime() {
        return this.cacheClusterCreateTime;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public String topicArn() {
        return this.topicArn;
    }

    public Integer port() {
        return this.port;
    }

    public String cacheParameterGroupName() {
        return this.cacheParameterGroupName;
    }

    public String cacheSubnetGroupName() {
        return this.cacheSubnetGroupName;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public Integer snapshotRetentionLimit() {
        return this.snapshotRetentionLimit;
    }

    public String snapshotWindow() {
        return this.snapshotWindow;
    }

    public Integer numNodeGroups() {
        return this.numNodeGroups;
    }

    public String automaticFailover() {
        return this.automaticFailover;
    }

    public List<NodeSnapshot> nodeSnapshots() {
        return this.nodeSnapshots;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.snapshotName() == null ? 0 : this.snapshotName().hashCode());
        hashCode = 31 * hashCode + (this.replicationGroupId() == null ? 0 : this.replicationGroupId().hashCode());
        hashCode = 31 * hashCode + (this.replicationGroupDescription() == null ? 0 : this.replicationGroupDescription().hashCode());
        hashCode = 31 * hashCode + (this.cacheClusterId() == null ? 0 : this.cacheClusterId().hashCode());
        hashCode = 31 * hashCode + (this.snapshotStatus() == null ? 0 : this.snapshotStatus().hashCode());
        hashCode = 31 * hashCode + (this.snapshotSource() == null ? 0 : this.snapshotSource().hashCode());
        hashCode = 31 * hashCode + (this.cacheNodeType() == null ? 0 : this.cacheNodeType().hashCode());
        hashCode = 31 * hashCode + (this.engine() == null ? 0 : this.engine().hashCode());
        hashCode = 31 * hashCode + (this.engineVersion() == null ? 0 : this.engineVersion().hashCode());
        hashCode = 31 * hashCode + (this.numCacheNodes() == null ? 0 : this.numCacheNodes().hashCode());
        hashCode = 31 * hashCode + (this.preferredAvailabilityZone() == null ? 0 : this.preferredAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.cacheClusterCreateTime() == null ? 0 : this.cacheClusterCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.preferredMaintenanceWindow() == null ? 0 : this.preferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.topicArn() == null ? 0 : this.topicArn().hashCode());
        hashCode = 31 * hashCode + (this.port() == null ? 0 : this.port().hashCode());
        hashCode = 31 * hashCode + (this.cacheParameterGroupName() == null ? 0 : this.cacheParameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.cacheSubnetGroupName() == null ? 0 : this.cacheSubnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.vpcId() == null ? 0 : this.vpcId().hashCode());
        hashCode = 31 * hashCode + (this.autoMinorVersionUpgrade() == null ? 0 : this.autoMinorVersionUpgrade().hashCode());
        hashCode = 31 * hashCode + (this.snapshotRetentionLimit() == null ? 0 : this.snapshotRetentionLimit().hashCode());
        hashCode = 31 * hashCode + (this.snapshotWindow() == null ? 0 : this.snapshotWindow().hashCode());
        hashCode = 31 * hashCode + (this.numNodeGroups() == null ? 0 : this.numNodeGroups().hashCode());
        hashCode = 31 * hashCode + (this.automaticFailover() == null ? 0 : this.automaticFailover().hashCode());
        hashCode = 31 * hashCode + (this.nodeSnapshots() == null ? 0 : this.nodeSnapshots().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Snapshot)) {
            return false;
        }
        Snapshot other = (Snapshot)obj;
        if (other.snapshotName() == null ^ this.snapshotName() == null) {
            return false;
        }
        if (other.snapshotName() != null && !other.snapshotName().equals(this.snapshotName())) {
            return false;
        }
        if (other.replicationGroupId() == null ^ this.replicationGroupId() == null) {
            return false;
        }
        if (other.replicationGroupId() != null && !other.replicationGroupId().equals(this.replicationGroupId())) {
            return false;
        }
        if (other.replicationGroupDescription() == null ^ this.replicationGroupDescription() == null) {
            return false;
        }
        if (other.replicationGroupDescription() != null && !other.replicationGroupDescription().equals(this.replicationGroupDescription())) {
            return false;
        }
        if (other.cacheClusterId() == null ^ this.cacheClusterId() == null) {
            return false;
        }
        if (other.cacheClusterId() != null && !other.cacheClusterId().equals(this.cacheClusterId())) {
            return false;
        }
        if (other.snapshotStatus() == null ^ this.snapshotStatus() == null) {
            return false;
        }
        if (other.snapshotStatus() != null && !other.snapshotStatus().equals(this.snapshotStatus())) {
            return false;
        }
        if (other.snapshotSource() == null ^ this.snapshotSource() == null) {
            return false;
        }
        if (other.snapshotSource() != null && !other.snapshotSource().equals(this.snapshotSource())) {
            return false;
        }
        if (other.cacheNodeType() == null ^ this.cacheNodeType() == null) {
            return false;
        }
        if (other.cacheNodeType() != null && !other.cacheNodeType().equals(this.cacheNodeType())) {
            return false;
        }
        if (other.engine() == null ^ this.engine() == null) {
            return false;
        }
        if (other.engine() != null && !other.engine().equals(this.engine())) {
            return false;
        }
        if (other.engineVersion() == null ^ this.engineVersion() == null) {
            return false;
        }
        if (other.engineVersion() != null && !other.engineVersion().equals(this.engineVersion())) {
            return false;
        }
        if (other.numCacheNodes() == null ^ this.numCacheNodes() == null) {
            return false;
        }
        if (other.numCacheNodes() != null && !other.numCacheNodes().equals(this.numCacheNodes())) {
            return false;
        }
        if (other.preferredAvailabilityZone() == null ^ this.preferredAvailabilityZone() == null) {
            return false;
        }
        if (other.preferredAvailabilityZone() != null && !other.preferredAvailabilityZone().equals(this.preferredAvailabilityZone())) {
            return false;
        }
        if (other.cacheClusterCreateTime() == null ^ this.cacheClusterCreateTime() == null) {
            return false;
        }
        if (other.cacheClusterCreateTime() != null && !other.cacheClusterCreateTime().equals(this.cacheClusterCreateTime())) {
            return false;
        }
        if (other.preferredMaintenanceWindow() == null ^ this.preferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.preferredMaintenanceWindow() != null && !other.preferredMaintenanceWindow().equals(this.preferredMaintenanceWindow())) {
            return false;
        }
        if (other.topicArn() == null ^ this.topicArn() == null) {
            return false;
        }
        if (other.topicArn() != null && !other.topicArn().equals(this.topicArn())) {
            return false;
        }
        if (other.port() == null ^ this.port() == null) {
            return false;
        }
        if (other.port() != null && !other.port().equals(this.port())) {
            return false;
        }
        if (other.cacheParameterGroupName() == null ^ this.cacheParameterGroupName() == null) {
            return false;
        }
        if (other.cacheParameterGroupName() != null && !other.cacheParameterGroupName().equals(this.cacheParameterGroupName())) {
            return false;
        }
        if (other.cacheSubnetGroupName() == null ^ this.cacheSubnetGroupName() == null) {
            return false;
        }
        if (other.cacheSubnetGroupName() != null && !other.cacheSubnetGroupName().equals(this.cacheSubnetGroupName())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        if (other.autoMinorVersionUpgrade() == null ^ this.autoMinorVersionUpgrade() == null) {
            return false;
        }
        if (other.autoMinorVersionUpgrade() != null && !other.autoMinorVersionUpgrade().equals(this.autoMinorVersionUpgrade())) {
            return false;
        }
        if (other.snapshotRetentionLimit() == null ^ this.snapshotRetentionLimit() == null) {
            return false;
        }
        if (other.snapshotRetentionLimit() != null && !other.snapshotRetentionLimit().equals(this.snapshotRetentionLimit())) {
            return false;
        }
        if (other.snapshotWindow() == null ^ this.snapshotWindow() == null) {
            return false;
        }
        if (other.snapshotWindow() != null && !other.snapshotWindow().equals(this.snapshotWindow())) {
            return false;
        }
        if (other.numNodeGroups() == null ^ this.numNodeGroups() == null) {
            return false;
        }
        if (other.numNodeGroups() != null && !other.numNodeGroups().equals(this.numNodeGroups())) {
            return false;
        }
        if (other.automaticFailover() == null ^ this.automaticFailover() == null) {
            return false;
        }
        if (other.automaticFailover() != null && !other.automaticFailover().equals(this.automaticFailover())) {
            return false;
        }
        if (other.nodeSnapshots() == null ^ this.nodeSnapshots() == null) {
            return false;
        }
        return other.nodeSnapshots() == null || other.nodeSnapshots().equals(this.nodeSnapshots());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.snapshotName() != null) {
            sb.append("SnapshotName: ").append(this.snapshotName()).append(",");
        }
        if (this.replicationGroupId() != null) {
            sb.append("ReplicationGroupId: ").append(this.replicationGroupId()).append(",");
        }
        if (this.replicationGroupDescription() != null) {
            sb.append("ReplicationGroupDescription: ").append(this.replicationGroupDescription()).append(",");
        }
        if (this.cacheClusterId() != null) {
            sb.append("CacheClusterId: ").append(this.cacheClusterId()).append(",");
        }
        if (this.snapshotStatus() != null) {
            sb.append("SnapshotStatus: ").append(this.snapshotStatus()).append(",");
        }
        if (this.snapshotSource() != null) {
            sb.append("SnapshotSource: ").append(this.snapshotSource()).append(",");
        }
        if (this.cacheNodeType() != null) {
            sb.append("CacheNodeType: ").append(this.cacheNodeType()).append(",");
        }
        if (this.engine() != null) {
            sb.append("Engine: ").append(this.engine()).append(",");
        }
        if (this.engineVersion() != null) {
            sb.append("EngineVersion: ").append(this.engineVersion()).append(",");
        }
        if (this.numCacheNodes() != null) {
            sb.append("NumCacheNodes: ").append(this.numCacheNodes()).append(",");
        }
        if (this.preferredAvailabilityZone() != null) {
            sb.append("PreferredAvailabilityZone: ").append(this.preferredAvailabilityZone()).append(",");
        }
        if (this.cacheClusterCreateTime() != null) {
            sb.append("CacheClusterCreateTime: ").append(this.cacheClusterCreateTime()).append(",");
        }
        if (this.preferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: ").append(this.preferredMaintenanceWindow()).append(",");
        }
        if (this.topicArn() != null) {
            sb.append("TopicArn: ").append(this.topicArn()).append(",");
        }
        if (this.port() != null) {
            sb.append("Port: ").append(this.port()).append(",");
        }
        if (this.cacheParameterGroupName() != null) {
            sb.append("CacheParameterGroupName: ").append(this.cacheParameterGroupName()).append(",");
        }
        if (this.cacheSubnetGroupName() != null) {
            sb.append("CacheSubnetGroupName: ").append(this.cacheSubnetGroupName()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        if (this.autoMinorVersionUpgrade() != null) {
            sb.append("AutoMinorVersionUpgrade: ").append(this.autoMinorVersionUpgrade()).append(",");
        }
        if (this.snapshotRetentionLimit() != null) {
            sb.append("SnapshotRetentionLimit: ").append(this.snapshotRetentionLimit()).append(",");
        }
        if (this.snapshotWindow() != null) {
            sb.append("SnapshotWindow: ").append(this.snapshotWindow()).append(",");
        }
        if (this.numNodeGroups() != null) {
            sb.append("NumNodeGroups: ").append(this.numNodeGroups()).append(",");
        }
        if (this.automaticFailover() != null) {
            sb.append("AutomaticFailover: ").append(this.automaticFailover()).append(",");
        }
        if (this.nodeSnapshots() != null) {
            sb.append("NodeSnapshots: ").append(this.nodeSnapshots()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String snapshotName;
        private String replicationGroupId;
        private String replicationGroupDescription;
        private String cacheClusterId;
        private String snapshotStatus;
        private String snapshotSource;
        private String cacheNodeType;
        private String engine;
        private String engineVersion;
        private Integer numCacheNodes;
        private String preferredAvailabilityZone;
        private Instant cacheClusterCreateTime;
        private String preferredMaintenanceWindow;
        private String topicArn;
        private Integer port;
        private String cacheParameterGroupName;
        private String cacheSubnetGroupName;
        private String vpcId;
        private Boolean autoMinorVersionUpgrade;
        private Integer snapshotRetentionLimit;
        private String snapshotWindow;
        private Integer numNodeGroups;
        private String automaticFailover;
        private List<NodeSnapshot> nodeSnapshots;

        private BuilderImpl() {
        }

        private BuilderImpl(Snapshot model) {
            this.setSnapshotName(model.snapshotName);
            this.setReplicationGroupId(model.replicationGroupId);
            this.setReplicationGroupDescription(model.replicationGroupDescription);
            this.setCacheClusterId(model.cacheClusterId);
            this.setSnapshotStatus(model.snapshotStatus);
            this.setSnapshotSource(model.snapshotSource);
            this.setCacheNodeType(model.cacheNodeType);
            this.setEngine(model.engine);
            this.setEngineVersion(model.engineVersion);
            this.setNumCacheNodes(model.numCacheNodes);
            this.setPreferredAvailabilityZone(model.preferredAvailabilityZone);
            this.setCacheClusterCreateTime(model.cacheClusterCreateTime);
            this.setPreferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.setTopicArn(model.topicArn);
            this.setPort(model.port);
            this.setCacheParameterGroupName(model.cacheParameterGroupName);
            this.setCacheSubnetGroupName(model.cacheSubnetGroupName);
            this.setVpcId(model.vpcId);
            this.setAutoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.setSnapshotRetentionLimit(model.snapshotRetentionLimit);
            this.setSnapshotWindow(model.snapshotWindow);
            this.setNumNodeGroups(model.numNodeGroups);
            this.setAutomaticFailover(model.automaticFailover);
            this.setNodeSnapshots(model.nodeSnapshots);
        }

        public final String getSnapshotName() {
            return this.snapshotName;
        }

        @Override
        public final Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public final void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        public final String getReplicationGroupId() {
            return this.replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        public final String getReplicationGroupDescription() {
            return this.replicationGroupDescription;
        }

        @Override
        public final Builder replicationGroupDescription(String replicationGroupDescription) {
            this.replicationGroupDescription = replicationGroupDescription;
            return this;
        }

        public final void setReplicationGroupDescription(String replicationGroupDescription) {
            this.replicationGroupDescription = replicationGroupDescription;
        }

        public final String getCacheClusterId() {
            return this.cacheClusterId;
        }

        @Override
        public final Builder cacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
            return this;
        }

        public final void setCacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
        }

        public final String getSnapshotStatus() {
            return this.snapshotStatus;
        }

        @Override
        public final Builder snapshotStatus(String snapshotStatus) {
            this.snapshotStatus = snapshotStatus;
            return this;
        }

        public final void setSnapshotStatus(String snapshotStatus) {
            this.snapshotStatus = snapshotStatus;
        }

        public final String getSnapshotSource() {
            return this.snapshotSource;
        }

        @Override
        public final Builder snapshotSource(String snapshotSource) {
            this.snapshotSource = snapshotSource;
            return this;
        }

        public final void setSnapshotSource(String snapshotSource) {
            this.snapshotSource = snapshotSource;
        }

        public final String getCacheNodeType() {
            return this.cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Integer getNumCacheNodes() {
            return this.numCacheNodes;
        }

        @Override
        public final Builder numCacheNodes(Integer numCacheNodes) {
            this.numCacheNodes = numCacheNodes;
            return this;
        }

        public final void setNumCacheNodes(Integer numCacheNodes) {
            this.numCacheNodes = numCacheNodes;
        }

        public final String getPreferredAvailabilityZone() {
            return this.preferredAvailabilityZone;
        }

        @Override
        public final Builder preferredAvailabilityZone(String preferredAvailabilityZone) {
            this.preferredAvailabilityZone = preferredAvailabilityZone;
            return this;
        }

        public final void setPreferredAvailabilityZone(String preferredAvailabilityZone) {
            this.preferredAvailabilityZone = preferredAvailabilityZone;
        }

        public final Instant getCacheClusterCreateTime() {
            return this.cacheClusterCreateTime;
        }

        @Override
        public final Builder cacheClusterCreateTime(Instant cacheClusterCreateTime) {
            this.cacheClusterCreateTime = cacheClusterCreateTime;
            return this;
        }

        public final void setCacheClusterCreateTime(Instant cacheClusterCreateTime) {
            this.cacheClusterCreateTime = cacheClusterCreateTime;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final String getTopicArn() {
            return this.topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getCacheParameterGroupName() {
            return this.cacheParameterGroupName;
        }

        @Override
        public final Builder cacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
            return this;
        }

        public final void setCacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
        }

        public final String getCacheSubnetGroupName() {
            return this.cacheSubnetGroupName;
        }

        @Override
        public final Builder cacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
            return this;
        }

        public final void setCacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        public final Integer getSnapshotRetentionLimit() {
            return this.snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        public final String getSnapshotWindow() {
            return this.snapshotWindow;
        }

        @Override
        public final Builder snapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
            return this;
        }

        public final void setSnapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
        }

        public final Integer getNumNodeGroups() {
            return this.numNodeGroups;
        }

        @Override
        public final Builder numNodeGroups(Integer numNodeGroups) {
            this.numNodeGroups = numNodeGroups;
            return this;
        }

        public final void setNumNodeGroups(Integer numNodeGroups) {
            this.numNodeGroups = numNodeGroups;
        }

        public final String getAutomaticFailover() {
            return this.automaticFailover;
        }

        @Override
        public final Builder automaticFailover(String automaticFailover) {
            this.automaticFailover = automaticFailover;
            return this;
        }

        @Override
        public final Builder automaticFailover(AutomaticFailoverStatus automaticFailover) {
            this.automaticFailover(automaticFailover.toString());
            return this;
        }

        public final void setAutomaticFailover(String automaticFailover) {
            this.automaticFailover = automaticFailover;
        }

        public final Collection<NodeSnapshot> getNodeSnapshots() {
            return this.nodeSnapshots;
        }

        @Override
        public final Builder nodeSnapshots(Collection<NodeSnapshot> nodeSnapshots) {
            this.nodeSnapshots = NodeSnapshotListCopier.copy(nodeSnapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeSnapshots(NodeSnapshot ... nodeSnapshots) {
            this.nodeSnapshots(Arrays.asList(nodeSnapshots));
            return this;
        }

        public final void setNodeSnapshots(Collection<NodeSnapshot> nodeSnapshots) {
            this.nodeSnapshots = NodeSnapshotListCopier.copy(nodeSnapshots);
        }

        public Snapshot build() {
            return new Snapshot(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Snapshot> {
        public Builder snapshotName(String var1);

        public Builder replicationGroupId(String var1);

        public Builder replicationGroupDescription(String var1);

        public Builder cacheClusterId(String var1);

        public Builder snapshotStatus(String var1);

        public Builder snapshotSource(String var1);

        public Builder cacheNodeType(String var1);

        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder numCacheNodes(Integer var1);

        public Builder preferredAvailabilityZone(String var1);

        public Builder cacheClusterCreateTime(Instant var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder topicArn(String var1);

        public Builder port(Integer var1);

        public Builder cacheParameterGroupName(String var1);

        public Builder cacheSubnetGroupName(String var1);

        public Builder vpcId(String var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder snapshotRetentionLimit(Integer var1);

        public Builder snapshotWindow(String var1);

        public Builder numNodeGroups(Integer var1);

        public Builder automaticFailover(String var1);

        public Builder automaticFailover(AutomaticFailoverStatus var1);

        public Builder nodeSnapshots(Collection<NodeSnapshot> var1);

        public Builder nodeSnapshots(NodeSnapshot ... var1);
    }
}

