/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.elasticache.model.Snapshot;
import software.amazon.awssdk.services.elasticache.model.SnapshotListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeSnapshotsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeSnapshotsResponse> {
    private final String marker;
    private final List<Snapshot> snapshots;

    private DescribeSnapshotsResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.snapshots = builder.snapshots;
    }

    public String marker() {
        return this.marker;
    }

    public List<Snapshot> snapshots() {
        return this.snapshots;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.snapshots() == null ? 0 : this.snapshots().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotsResponse)) {
            return false;
        }
        DescribeSnapshotsResponse other = (DescribeSnapshotsResponse)((Object)obj);
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.snapshots() == null ^ this.snapshots() == null) {
            return false;
        }
        return other.snapshots() == null || other.snapshots().equals(this.snapshots());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.snapshots() != null) {
            sb.append("Snapshots: ").append(this.snapshots()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<Snapshot> snapshots;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSnapshotsResponse model) {
            this.setMarker(model.marker);
            this.setSnapshots(model.snapshots);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<Snapshot> getSnapshots() {
            return this.snapshots;
        }

        @Override
        public final Builder snapshots(Collection<Snapshot> snapshots) {
            this.snapshots = SnapshotListCopier.copy(snapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshots(Snapshot ... snapshots) {
            this.snapshots(Arrays.asList(snapshots));
            return this;
        }

        public final void setSnapshots(Collection<Snapshot> snapshots) {
            this.snapshots = SnapshotListCopier.copy(snapshots);
        }

        public DescribeSnapshotsResponse build() {
            return new DescribeSnapshotsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeSnapshotsResponse> {
        public Builder marker(String var1);

        public Builder snapshots(Collection<Snapshot> var1);

        public Builder snapshots(Snapshot ... var1);
    }
}

