/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.elasticache.model.ReplicationGroup;
import software.amazon.awssdk.services.elasticache.model.ReplicationGroupListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeReplicationGroupsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeReplicationGroupsResponse> {
    private final String marker;
    private final List<ReplicationGroup> replicationGroups;

    private DescribeReplicationGroupsResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.replicationGroups = builder.replicationGroups;
    }

    public String marker() {
        return this.marker;
    }

    public List<ReplicationGroup> replicationGroups() {
        return this.replicationGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.replicationGroups() == null ? 0 : this.replicationGroups().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReplicationGroupsResponse)) {
            return false;
        }
        DescribeReplicationGroupsResponse other = (DescribeReplicationGroupsResponse)((Object)obj);
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.replicationGroups() == null ^ this.replicationGroups() == null) {
            return false;
        }
        return other.replicationGroups() == null || other.replicationGroups().equals(this.replicationGroups());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.replicationGroups() != null) {
            sb.append("ReplicationGroups: ").append(this.replicationGroups()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<ReplicationGroup> replicationGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReplicationGroupsResponse model) {
            this.setMarker(model.marker);
            this.setReplicationGroups(model.replicationGroups);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ReplicationGroup> getReplicationGroups() {
            return this.replicationGroups;
        }

        @Override
        public final Builder replicationGroups(Collection<ReplicationGroup> replicationGroups) {
            this.replicationGroups = ReplicationGroupListCopier.copy(replicationGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationGroups(ReplicationGroup ... replicationGroups) {
            this.replicationGroups(Arrays.asList(replicationGroups));
            return this;
        }

        public final void setReplicationGroups(Collection<ReplicationGroup> replicationGroups) {
            this.replicationGroups = ReplicationGroupListCopier.copy(replicationGroups);
        }

        public DescribeReplicationGroupsResponse build() {
            return new DescribeReplicationGroupsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeReplicationGroupsResponse> {
        public Builder marker(String var1);

        public Builder replicationGroups(Collection<ReplicationGroup> var1);

        public Builder replicationGroups(ReplicationGroup ... var1);
    }
}

