/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteReplicationGroupRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteReplicationGroupRequest> {
    private final String replicationGroupId;
    private final Boolean retainPrimaryCluster;
    private final String finalSnapshotIdentifier;

    private DeleteReplicationGroupRequest(BuilderImpl builder) {
        this.replicationGroupId = builder.replicationGroupId;
        this.retainPrimaryCluster = builder.retainPrimaryCluster;
        this.finalSnapshotIdentifier = builder.finalSnapshotIdentifier;
    }

    public String replicationGroupId() {
        return this.replicationGroupId;
    }

    public Boolean retainPrimaryCluster() {
        return this.retainPrimaryCluster;
    }

    public String finalSnapshotIdentifier() {
        return this.finalSnapshotIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.replicationGroupId() == null ? 0 : this.replicationGroupId().hashCode());
        hashCode = 31 * hashCode + (this.retainPrimaryCluster() == null ? 0 : this.retainPrimaryCluster().hashCode());
        hashCode = 31 * hashCode + (this.finalSnapshotIdentifier() == null ? 0 : this.finalSnapshotIdentifier().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteReplicationGroupRequest)) {
            return false;
        }
        DeleteReplicationGroupRequest other = (DeleteReplicationGroupRequest)((Object)obj);
        if (other.replicationGroupId() == null ^ this.replicationGroupId() == null) {
            return false;
        }
        if (other.replicationGroupId() != null && !other.replicationGroupId().equals(this.replicationGroupId())) {
            return false;
        }
        if (other.retainPrimaryCluster() == null ^ this.retainPrimaryCluster() == null) {
            return false;
        }
        if (other.retainPrimaryCluster() != null && !other.retainPrimaryCluster().equals(this.retainPrimaryCluster())) {
            return false;
        }
        if (other.finalSnapshotIdentifier() == null ^ this.finalSnapshotIdentifier() == null) {
            return false;
        }
        return other.finalSnapshotIdentifier() == null || other.finalSnapshotIdentifier().equals(this.finalSnapshotIdentifier());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.replicationGroupId() != null) {
            sb.append("ReplicationGroupId: ").append(this.replicationGroupId()).append(",");
        }
        if (this.retainPrimaryCluster() != null) {
            sb.append("RetainPrimaryCluster: ").append(this.retainPrimaryCluster()).append(",");
        }
        if (this.finalSnapshotIdentifier() != null) {
            sb.append("FinalSnapshotIdentifier: ").append(this.finalSnapshotIdentifier()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String replicationGroupId;
        private Boolean retainPrimaryCluster;
        private String finalSnapshotIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteReplicationGroupRequest model) {
            this.setReplicationGroupId(model.replicationGroupId);
            this.setRetainPrimaryCluster(model.retainPrimaryCluster);
            this.setFinalSnapshotIdentifier(model.finalSnapshotIdentifier);
        }

        public final String getReplicationGroupId() {
            return this.replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        public final Boolean getRetainPrimaryCluster() {
            return this.retainPrimaryCluster;
        }

        @Override
        public final Builder retainPrimaryCluster(Boolean retainPrimaryCluster) {
            this.retainPrimaryCluster = retainPrimaryCluster;
            return this;
        }

        public final void setRetainPrimaryCluster(Boolean retainPrimaryCluster) {
            this.retainPrimaryCluster = retainPrimaryCluster;
        }

        public final String getFinalSnapshotIdentifier() {
            return this.finalSnapshotIdentifier;
        }

        @Override
        public final Builder finalSnapshotIdentifier(String finalSnapshotIdentifier) {
            this.finalSnapshotIdentifier = finalSnapshotIdentifier;
            return this;
        }

        public final void setFinalSnapshotIdentifier(String finalSnapshotIdentifier) {
            this.finalSnapshotIdentifier = finalSnapshotIdentifier;
        }

        public DeleteReplicationGroupRequest build() {
            return new DeleteReplicationGroupRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteReplicationGroupRequest> {
        public Builder replicationGroupId(String var1);

        public Builder retainPrimaryCluster(Boolean var1);

        public Builder finalSnapshotIdentifier(String var1);
    }
}

