/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticache.model.NodeGroup;
import software.amazon.awssdk.services.elasticache.model.ReplicationGroup;
import software.amazon.awssdk.services.elasticache.transform.EndpointUnmarshaller;
import software.amazon.awssdk.services.elasticache.transform.NodeGroupUnmarshaller;
import software.amazon.awssdk.services.elasticache.transform.ReplicationGroupPendingModifiedValuesUnmarshaller;

public class ReplicationGroupUnmarshaller
implements Unmarshaller<ReplicationGroup, StaxUnmarshallerContext> {
    private static final ReplicationGroupUnmarshaller INSTANCE = new ReplicationGroupUnmarshaller();

    public ReplicationGroup unmarshall(StaxUnmarshallerContext context) throws Exception {
        ReplicationGroup.Builder replicationGroup;
        block18: {
            replicationGroup = ReplicationGroup.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                targetDepth += 3;
            }
            ArrayList<String> memberClusters = null;
            ArrayList<NodeGroup> nodeGroups = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    replicationGroup.memberClusters(memberClusters);
                    replicationGroup.nodeGroups(nodeGroups);
                    break block18;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("ReplicationGroupId", targetDepth)) {
                        replicationGroup.replicationGroupId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Description", targetDepth)) {
                        replicationGroup.description(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Status", targetDepth)) {
                        replicationGroup.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("PendingModifiedValues", targetDepth)) {
                        replicationGroup.pendingModifiedValues(ReplicationGroupPendingModifiedValuesUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("MemberClusters", targetDepth)) {
                        memberClusters = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("MemberClusters/ClusterId", targetDepth)) {
                        memberClusters.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("NodeGroups", targetDepth)) {
                        nodeGroups = new ArrayList<NodeGroup>();
                        continue;
                    }
                    if (context.testExpression("NodeGroups/NodeGroup", targetDepth)) {
                        nodeGroups.add(NodeGroupUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SnapshottingClusterId", targetDepth)) {
                        replicationGroup.snapshottingClusterId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("AutomaticFailover", targetDepth)) {
                        replicationGroup.automaticFailover(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ConfigurationEndpoint", targetDepth)) {
                        replicationGroup.configurationEndpoint(EndpointUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SnapshotRetentionLimit", targetDepth)) {
                        replicationGroup.snapshotRetentionLimit(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SnapshotWindow", targetDepth)) {
                        replicationGroup.snapshotWindow(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ClusterEnabled", targetDepth)) {
                        replicationGroup.clusterEnabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("CacheNodeType", targetDepth)) continue;
                    replicationGroup.cacheNodeType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            replicationGroup.memberClusters(memberClusters);
            replicationGroup.nodeGroups(nodeGroups);
        }
        return (ReplicationGroup)replicationGroup.build();
    }

    public static ReplicationGroupUnmarshaller getInstance() {
        return INSTANCE;
    }
}

