/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import java.time.Instant;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticache.model.DescribeEventsRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeEventsRequestMarshaller
implements Marshaller<Request<DescribeEventsRequest>, DescribeEventsRequest> {
    public Request<DescribeEventsRequest> marshall(DescribeEventsRequest describeEventsRequest) {
        if (describeEventsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeEventsRequest, "ElastiCacheClient");
        request.addParameter("Action", "DescribeEvents");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeEventsRequest.sourceIdentifier() != null) {
            request.addParameter("SourceIdentifier", StringUtils.fromString((String)describeEventsRequest.sourceIdentifier()));
        }
        if (describeEventsRequest.sourceType() != null) {
            request.addParameter("SourceType", StringUtils.fromString((String)describeEventsRequest.sourceType()));
        }
        if (describeEventsRequest.startTime() != null) {
            request.addParameter("StartTime", StringUtils.fromInstant((Instant)describeEventsRequest.startTime()));
        }
        if (describeEventsRequest.endTime() != null) {
            request.addParameter("EndTime", StringUtils.fromInstant((Instant)describeEventsRequest.endTime()));
        }
        if (describeEventsRequest.duration() != null) {
            request.addParameter("Duration", StringUtils.fromInteger((Integer)describeEventsRequest.duration()));
        }
        if (describeEventsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeEventsRequest.maxRecords()));
        }
        if (describeEventsRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeEventsRequest.marker()));
        }
        return request;
    }
}

