/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.elasticache.model.AvailabilityZonesListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class NodeGroupConfiguration
implements ToCopyableBuilder<Builder, NodeGroupConfiguration> {
    private final String slots;
    private final Integer replicaCount;
    private final String primaryAvailabilityZone;
    private final List<String> replicaAvailabilityZones;

    private NodeGroupConfiguration(BuilderImpl builder) {
        this.slots = builder.slots;
        this.replicaCount = builder.replicaCount;
        this.primaryAvailabilityZone = builder.primaryAvailabilityZone;
        this.replicaAvailabilityZones = builder.replicaAvailabilityZones;
    }

    public String slots() {
        return this.slots;
    }

    public Integer replicaCount() {
        return this.replicaCount;
    }

    public String primaryAvailabilityZone() {
        return this.primaryAvailabilityZone;
    }

    public List<String> replicaAvailabilityZones() {
        return this.replicaAvailabilityZones;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.slots() == null ? 0 : this.slots().hashCode());
        hashCode = 31 * hashCode + (this.replicaCount() == null ? 0 : this.replicaCount().hashCode());
        hashCode = 31 * hashCode + (this.primaryAvailabilityZone() == null ? 0 : this.primaryAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.replicaAvailabilityZones() == null ? 0 : this.replicaAvailabilityZones().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeGroupConfiguration)) {
            return false;
        }
        NodeGroupConfiguration other = (NodeGroupConfiguration)obj;
        if (other.slots() == null ^ this.slots() == null) {
            return false;
        }
        if (other.slots() != null && !other.slots().equals(this.slots())) {
            return false;
        }
        if (other.replicaCount() == null ^ this.replicaCount() == null) {
            return false;
        }
        if (other.replicaCount() != null && !other.replicaCount().equals(this.replicaCount())) {
            return false;
        }
        if (other.primaryAvailabilityZone() == null ^ this.primaryAvailabilityZone() == null) {
            return false;
        }
        if (other.primaryAvailabilityZone() != null && !other.primaryAvailabilityZone().equals(this.primaryAvailabilityZone())) {
            return false;
        }
        if (other.replicaAvailabilityZones() == null ^ this.replicaAvailabilityZones() == null) {
            return false;
        }
        return other.replicaAvailabilityZones() == null || other.replicaAvailabilityZones().equals(this.replicaAvailabilityZones());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.slots() != null) {
            sb.append("Slots: ").append(this.slots()).append(",");
        }
        if (this.replicaCount() != null) {
            sb.append("ReplicaCount: ").append(this.replicaCount()).append(",");
        }
        if (this.primaryAvailabilityZone() != null) {
            sb.append("PrimaryAvailabilityZone: ").append(this.primaryAvailabilityZone()).append(",");
        }
        if (this.replicaAvailabilityZones() != null) {
            sb.append("ReplicaAvailabilityZones: ").append(this.replicaAvailabilityZones()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String slots;
        private Integer replicaCount;
        private String primaryAvailabilityZone;
        private List<String> replicaAvailabilityZones;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeGroupConfiguration model) {
            this.setSlots(model.slots);
            this.setReplicaCount(model.replicaCount);
            this.setPrimaryAvailabilityZone(model.primaryAvailabilityZone);
            this.setReplicaAvailabilityZones(model.replicaAvailabilityZones);
        }

        public final String getSlots() {
            return this.slots;
        }

        @Override
        public final Builder slots(String slots) {
            this.slots = slots;
            return this;
        }

        public final void setSlots(String slots) {
            this.slots = slots;
        }

        public final Integer getReplicaCount() {
            return this.replicaCount;
        }

        @Override
        public final Builder replicaCount(Integer replicaCount) {
            this.replicaCount = replicaCount;
            return this;
        }

        public final void setReplicaCount(Integer replicaCount) {
            this.replicaCount = replicaCount;
        }

        public final String getPrimaryAvailabilityZone() {
            return this.primaryAvailabilityZone;
        }

        @Override
        public final Builder primaryAvailabilityZone(String primaryAvailabilityZone) {
            this.primaryAvailabilityZone = primaryAvailabilityZone;
            return this;
        }

        public final void setPrimaryAvailabilityZone(String primaryAvailabilityZone) {
            this.primaryAvailabilityZone = primaryAvailabilityZone;
        }

        public final Collection<String> getReplicaAvailabilityZones() {
            return this.replicaAvailabilityZones;
        }

        @Override
        public final Builder replicaAvailabilityZones(Collection<String> replicaAvailabilityZones) {
            this.replicaAvailabilityZones = AvailabilityZonesListCopier.copy(replicaAvailabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaAvailabilityZones(String ... replicaAvailabilityZones) {
            this.replicaAvailabilityZones(Arrays.asList(replicaAvailabilityZones));
            return this;
        }

        public final void setReplicaAvailabilityZones(Collection<String> replicaAvailabilityZones) {
            this.replicaAvailabilityZones = AvailabilityZonesListCopier.copy(replicaAvailabilityZones);
        }

        public NodeGroupConfiguration build() {
            return new NodeGroupConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NodeGroupConfiguration> {
        public Builder slots(String var1);

        public Builder replicaCount(Integer var1);

        public Builder primaryAvailabilityZone(String var1);

        public Builder replicaAvailabilityZones(Collection<String> var1);

        public Builder replicaAvailabilityZones(String ... var1);
    }
}

