/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.waiters;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.services.elasticache.ElastiCacheClient;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsRequest;
import software.amazon.awssdk.services.elasticache.waiters.CacheClusterAvailable;
import software.amazon.awssdk.services.elasticache.waiters.CacheClusterDeleted;
import software.amazon.awssdk.services.elasticache.waiters.DescribeCacheClustersFunction;
import software.amazon.awssdk.services.elasticache.waiters.DescribeReplicationGroupsFunction;
import software.amazon.awssdk.services.elasticache.waiters.ReplicationGroupAvailable;
import software.amazon.awssdk.services.elasticache.waiters.ReplicationGroupDeleted;
import software.amazon.awssdk.waiters.FixedDelayStrategy;
import software.amazon.awssdk.waiters.MaxAttemptsRetryStrategy;
import software.amazon.awssdk.waiters.PollingStrategy;
import software.amazon.awssdk.waiters.SdkFunction;
import software.amazon.awssdk.waiters.Waiter;
import software.amazon.awssdk.waiters.WaiterAcceptor;
import software.amazon.awssdk.waiters.WaiterBuilder;

public class ElastiCacheClientWaiters {
    private final ElastiCacheClient client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public ElastiCacheClientWaiters(ElastiCacheClient client) {
        this.client = client;
    }

    public Waiter<DescribeCacheClustersRequest> cacheClusterDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeCacheClustersFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new CacheClusterDeleted.IsDeletedMatcher(), new CacheClusterDeleted.IsCacheClusterNotFoundMatcher(), new CacheClusterDeleted.IsAvailableMatcher(), new CacheClusterDeleted.IsCreatingMatcher(), new CacheClusterDeleted.IsIncompatiblenetworkMatcher(), new CacheClusterDeleted.IsModifyingMatcher(), new CacheClusterDeleted.IsRestorefailedMatcher(), new CacheClusterDeleted.IsSnapshottingMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeReplicationGroupsRequest> replicationGroupAvailable() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeReplicationGroupsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ReplicationGroupAvailable.IsAvailableMatcher(), new ReplicationGroupAvailable.IsDeletedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeCacheClustersRequest> cacheClusterAvailable() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeCacheClustersFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new CacheClusterAvailable.IsAvailableMatcher(), new CacheClusterAvailable.IsDeletedMatcher(), new CacheClusterAvailable.IsDeletingMatcher(), new CacheClusterAvailable.IsIncompatiblenetworkMatcher(), new CacheClusterAvailable.IsRestorefailedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeReplicationGroupsRequest> replicationGroupDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeReplicationGroupsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ReplicationGroupDeleted.IsDeletedMatcher(), new ReplicationGroupDeleted.IsAvailableMatcher(), new ReplicationGroupDeleted.IsReplicationGroupNotFoundFaultMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }
}

