/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticache.model.NodeGroup;
import software.amazon.awssdk.services.elasticache.model.NodeGroupMember;
import software.amazon.awssdk.services.elasticache.transform.EndpointUnmarshaller;
import software.amazon.awssdk.services.elasticache.transform.NodeGroupMemberUnmarshaller;

public class NodeGroupUnmarshaller
implements Unmarshaller<NodeGroup, StaxUnmarshallerContext> {
    private static NodeGroupUnmarshaller INSTANCE;

    public NodeGroup unmarshall(StaxUnmarshallerContext context) throws Exception {
        NodeGroup.Builder nodeGroup;
        block9: {
            nodeGroup = NodeGroup.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<NodeGroupMember> nodeGroupMembers = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    nodeGroup.nodeGroupMembers(nodeGroupMembers);
                    break block9;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("NodeGroupId", targetDepth)) {
                        nodeGroup.nodeGroupId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Status", targetDepth)) {
                        nodeGroup.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("PrimaryEndpoint", targetDepth)) {
                        nodeGroup.primaryEndpoint(EndpointUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Slots", targetDepth)) {
                        nodeGroup.slots(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("NodeGroupMembers", targetDepth)) {
                        nodeGroupMembers = new ArrayList<NodeGroupMember>();
                        continue;
                    }
                    if (!context.testExpression("NodeGroupMembers/NodeGroupMember", targetDepth)) continue;
                    nodeGroupMembers.add(NodeGroupMemberUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            nodeGroup.nodeGroupMembers(nodeGroupMembers);
        }
        return (NodeGroup)nodeGroup.build();
    }

    public static NodeGroupUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new NodeGroupUnmarshaller();
        }
        return INSTANCE;
    }
}

