/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticache.model.Event;

public class EventUnmarshaller
implements Unmarshaller<Event, StaxUnmarshallerContext> {
    private static EventUnmarshaller INSTANCE;

    public Event unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Event.Builder event = Event.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("SourceIdentifier", targetDepth)) {
                    event.sourceIdentifier(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SourceType", targetDepth)) {
                    event.sourceType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Message", targetDepth)) {
                    event.message(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Date", targetDepth)) continue;
                event.date(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Event)event.build();
    }

    public static EventUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EventUnmarshaller();
        }
        return INSTANCE;
    }
}

