/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeCacheEngineVersionsRequestMarshaller
implements Marshaller<Request<DescribeCacheEngineVersionsRequest>, DescribeCacheEngineVersionsRequest> {
    public Request<DescribeCacheEngineVersionsRequest> marshall(DescribeCacheEngineVersionsRequest describeCacheEngineVersionsRequest) {
        if (describeCacheEngineVersionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeCacheEngineVersionsRequest, "ElastiCacheClient");
        request.addParameter("Action", "DescribeCacheEngineVersions");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeCacheEngineVersionsRequest.engine() != null) {
            request.addParameter("Engine", StringUtils.fromString((String)describeCacheEngineVersionsRequest.engine()));
        }
        if (describeCacheEngineVersionsRequest.engineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)describeCacheEngineVersionsRequest.engineVersion()));
        }
        if (describeCacheEngineVersionsRequest.cacheParameterGroupFamily() != null) {
            request.addParameter("CacheParameterGroupFamily", StringUtils.fromString((String)describeCacheEngineVersionsRequest.cacheParameterGroupFamily()));
        }
        if (describeCacheEngineVersionsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeCacheEngineVersionsRequest.maxRecords()));
        }
        if (describeCacheEngineVersionsRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeCacheEngineVersionsRequest.marker()));
        }
        if (describeCacheEngineVersionsRequest.defaultOnly() != null) {
            request.addParameter("DefaultOnly", StringUtils.fromBoolean((Boolean)describeCacheEngineVersionsRequest.defaultOnly()));
        }
        return request;
    }
}

