/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticache.model.CreateSnapshotRequest;
import software.amazon.awssdk.util.StringUtils;

public class CreateSnapshotRequestMarshaller
implements Marshaller<Request<CreateSnapshotRequest>, CreateSnapshotRequest> {
    public Request<CreateSnapshotRequest> marshall(CreateSnapshotRequest createSnapshotRequest) {
        if (createSnapshotRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createSnapshotRequest, "ElastiCacheClient");
        request.addParameter("Action", "CreateSnapshot");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (createSnapshotRequest.replicationGroupId() != null) {
            request.addParameter("ReplicationGroupId", StringUtils.fromString((String)createSnapshotRequest.replicationGroupId()));
        }
        if (createSnapshotRequest.cacheClusterId() != null) {
            request.addParameter("CacheClusterId", StringUtils.fromString((String)createSnapshotRequest.cacheClusterId()));
        }
        if (createSnapshotRequest.snapshotName() != null) {
            request.addParameter("SnapshotName", StringUtils.fromString((String)createSnapshotRequest.snapshotName()));
        }
        return request;
    }
}

