/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticache.model.CacheEngineVersion;

public class CacheEngineVersionUnmarshaller
implements Unmarshaller<CacheEngineVersion, StaxUnmarshallerContext> {
    private static CacheEngineVersionUnmarshaller INSTANCE;

    public CacheEngineVersion unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        CacheEngineVersion.Builder cacheEngineVersion = CacheEngineVersion.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Engine", targetDepth)) {
                    cacheEngineVersion.engine(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EngineVersion", targetDepth)) {
                    cacheEngineVersion.engineVersion(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CacheParameterGroupFamily", targetDepth)) {
                    cacheEngineVersion.cacheParameterGroupFamily(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CacheEngineDescription", targetDepth)) {
                    cacheEngineVersion.cacheEngineDescription(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("CacheEngineVersionDescription", targetDepth)) continue;
                cacheEngineVersion.cacheEngineVersionDescription(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (CacheEngineVersion)cacheEngineVersion.build();
    }

    public static CacheEngineVersionUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CacheEngineVersionUnmarshaller();
        }
        return INSTANCE;
    }
}

